;;; elite-variables.el -  Variable declarations for Emacs-Elite

;; Elite for EMACS is based on Elite series by Ian Bell and David Braben.
;; Original Elite, (C) 1984 Ian Bell and David Braben.
;; Elite for EMACS uses code from original Elite and it is (C) 1984 Ian Bell and David Braben.
;; Additional code :
;; Author: Sami Salkosuo (sami@roguemail.net)


;; This file is not part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

(defconst elite-user-interface-width 115)
(defconst elite-user-interface-height 35)

(defconst base0 ?\x5a4a)
(defconst base1 ?\x0248)
(defconst base2 ?\xb753)


(defconst numforLave 7); Lave is 7th generated planet in galaxy one
(defconst numforZaonce 129)
(defconst numforDiso 147)
(defconst numforRied 46)

(defconst AlienItems 16)
(defconst lasttrade AlienItems)


(defvar elite-buffer-name "*Elite*"
  "Elite buffer name")

(defvar elite-welcome-message
;(setq elite-welcome-message
  "Welcome to Elite for EMACS")

(defvar elite-commander-save-file "~/.elite-commander")

(defvar elite-commander-save-directory "~"
  "Directory where additional commander specific data is saved.
   Default file name is .elite-commander_<commander name>"
  )

(defvar elite-autofuel nil
  "If this is true fuel tank is automatically filled after entering station.")

(defvar elite-autosave nil
  "If this is true commander is saved automatically when docked.")

(defvar elite-combat t
  "t enables combat")

(defvar elite-day 0
  "Current day in elite universe")

;;define constants and variables as in TXTELITE.C
(defconst galsize 256
  "Galaxy size")

(defvar lastrand 12345
  "Default random seed.")

(defvar galaxynum 1
  "Default galaxy number.")

(defvar pairs0 "ABOUSEITILETSTONLONUTHNO"
  "Characters used in planet names.")
;must continue into ..
(defvar pairs "..LEXEGEZACEBISOUSESARMAINDIREA.ERATENBERALAVETIEDORQUANTEISRION"
  "Characters for planet names.")
;Dots should be nullprint characters

(defvar elite-planet-completion-list (make-vector galsize [])
  "Completion list for planet info.")

(defstruct seedtype
  ;six byte random number used as seed for planets
  w0
  w1
  w2
)

(defvar seed
  ;variable seed
  (make-seedtype
   :w0 1
   :w1 2
   :w2 3
   ))

(defstruct fastseedtype
  ;four byte random number used for planet description
  a
  b
  c
  d
)

;(defstruct (plansys (:type list))
(defstruct plansys
  ;planet structure
  x
  y
  economy
  govtype
  techlevel
  population
  productivity
  radius
  goatsoupseed
  name ;12 characters
)
(defvar govnames (vector "Anarchy" "Feudal" "Multi-gov" "Dictatorship" "Communist" "Confederacy" "Democracy" "Corporate State")
  "Government names.")
(defvar econnames (vector "Rich Ind" "Average Ind" "Poor Ind" "Mainly Ind"  "Mainly Agri" "Rich Agri" "Average Agri" "Poor Agri")
  "Econonmy names.")

(defvar galaxy (make-vector galsize [])
  "galaxy is a array of plansys"
  )
;(setq galaxy (make-vector 2 []))

(defvar unitnames (vector "t" "kg" "g")
  "unit types for commodities"
  )



(defstruct tradegood
  ;define tradegood struct
  baseprice
  gradient
  basequant
  maskbyte
  units
  name)

(defconst TRADEGOOD_FOOD 0)
(defconst TRADEGOOD_TEXTILES 1)
(defconst TRADEGOOD_RADIOACTIVES 2)
(defconst TRADEGOOD_SLAVES 3)
(defconst TRADEGOOD_LIQUOR 4)
(defconst TRADEGOOD_LUXURIES 5)
(defconst TRADEGOOD_NARCOTICS 6)
(defconst TRADEGOOD_COMPUTERS 7)
(defconst TRADEGOOD_MACHINERY 8)
(defconst TRADEGOOD_ALLOYS 9)
(defconst TRADEGOOD_FIREARMS 10)
(defconst TRADEGOOD_FURS 11)
(defconst TRADEGOOD_MINERALS 12)
(defconst TRADEGOOD_GOLD 13)
(defconst TRADEGOOD_PLATINUM 14)
(defconst TRADEGOOD_GEMS 15)
(defconst TRADEGOOD_ALIENITEMS 16)


(defvar commodities
  ;array of tradegoods
  (vector
   (make-tradegood 
    :baseprice 19
    :gradient -2
    :basequant 6
    :maskbyte 1
    :units 0
    :name "Food        ")
   (make-tradegood 
    :baseprice 20
    :gradient -1
    :basequant 10
    :maskbyte 3
    :units 0
    :name "Textiles    ")
   (make-tradegood 
    :baseprice 65
    :gradient -3
    :basequant 2
    :maskbyte 7
    :units 0
    :name "Radioactives")
   (make-tradegood 
    :baseprice 40 
    :gradient -5
    :basequant 226
    :maskbyte 31
    :units 0
    :name "Slaves      ")
   (make-tradegood 
    :baseprice 83
    :gradient -5
    :basequant 251
    :maskbyte 15
    :units 0
    :name "Liquor/Wines")
   (make-tradegood 
    :baseprice 196
    :gradient 8
    :basequant 54
    :maskbyte 3
    :units 0
    :name "Luxuries    ")
   (make-tradegood 
    :baseprice 235
    :gradient 29
    :basequant 8
    :maskbyte 120
    :units 0
    :name "Narcotics   ")
   (make-tradegood 
    :baseprice 154 
    :gradient 14
    :basequant 56
    :maskbyte 3
    :units 0
    :name "Computers   ")
   (make-tradegood 
    :baseprice 117
    :gradient 6
    :basequant 40
    :maskbyte 7
    :units 0
    :name "Machinery   ")
   (make-tradegood 
    :baseprice 78
    :gradient 1
    :basequant 17
    :maskbyte 31
    :units 0
    :name "Alloys      ")
   (make-tradegood 
    :baseprice 124
    :gradient 13
    :basequant 29
    :maskbyte 7
    :units 0
    :name "Firearms    ")
   (make-tradegood 
    :baseprice 176
    :gradient -9
    :basequant 220
    :maskbyte 63
    :units 0
    :name "Furs        ")
   (make-tradegood 
    :baseprice 32
    :gradient -1
    :basequant 53
    :maskbyte 3
    :units 0
    :name "Minerals    ")
   (make-tradegood 
    :baseprice 97
    :gradient -1
    :basequant 66
    :maskbyte 7
    :units 1
    :name "Gold        ")
   (make-tradegood 
    :baseprice 171
    :gradient -2 
    :basequant 55 
    :maskbyte 31
    :units 1
    :name "Platinum    ")
   (make-tradegood 
    :baseprice 45
    :gradient -1
    :basequant 250
    :maskbyte 15
    :units 2
    :name "Gem-Strones ")
   (make-tradegood 
    :baseprice 53
    :gradient 15
    :basequant 192
    :maskbyte 7
    :units 0
    :name "Alien Items ")

   ))
              
(defvar tradnames (make-vector (length commodities) "")
  "Tradegood names array.")

;equipment
(defvar number-of-equip-items 14
  "Number equipments in game.")

(defstruct equipitem 
  canbuy
  y
  show
  techlevel
  price
  name
  type
)

(defvar equipment-stock (make-vector number-of-equip-items [])
  "Equipment stock."
)

(defstruct markettype
  quantity
  price
  )


;Player workspace
(defvar elite-commander-name ""
  "Active players name.")

(defconst ELITE_GENDER_MALE 1)
(defconst ELITE_GENDER_FEMALE 0)

(defvar elite-commander-gender -1
  "Active players gender. 1=male,0=female")


(defvar shipshold (make-vector (+ lasttrade 1) 0)
  "Contents of cargobay.")
;(setq shipshold  (make-vector (+ lasttrade 1) 0))

(defvar currentplanet 0
  " Current planet")

(defvar  elite-player-cash 1000
  "Player cash. 1000 is 100 CR")

(defvar  fuel 70
  "Player fuel.")

(defvar localmarket (make-markettype 
		     :quantity 0
		     :price))

(defvar holdspace 20)


(defvar elite-fuelcost 2
  "0.2 CR/Light year")

(defvar maxfuel 70
  "7.0 LY tank")


(defvar elite-galaxies-in-universe '[[[cl-struct-plansys 2 90 2 1 8 36 11520 4610 [cl-struct-fastseedtype 72 2 83 12014336] "TIBEDIED"] [cl-struct-plansys 152 205 5 7 6 37 16280 5528 [cl-struct-fastseedtype 184 920 29 108666112] "QUBE"] [cl-struct-plansys 77 243 3 3 7 35 13720 3149 [cl-struct-fastseedtype 156 10317 27 -98493696] "LELEER"] [cl-struct-plansys 83 208 0 2 11 47 22560 4435 [cl-struct-fastseedtype 148 118099 13 8785152] "BIARGE"] [cl-struct-plansys 180 131 3 4 6 32 14336 3508 [cl-struct-fastseedtype 32 303028 51 -18730240] "XEQUERIN"] [cl-struct-plansys 172 176 0 4 9 41 26240 4780 [cl-struct-fastseedtype 224 788396 141 7834880] "TIRAOR"] [cl-struct-plansys 69 249 1 2 8 36 15552 3909 [cl-struct-fastseedtype 212 868421 27 1317632] "RABEDIRA"] [cl-struct-plansys 20 173 5 3 4 25 7000 4116 [cl-struct-fastseedtype 156 166164 29 34938112] "LAVE"] [cl-struct-plansys 236 0 0 7 11 52 45760 4076 [cl-struct-fastseedtype 184 666860 83 130306816] "ZAATXE"] [cl-struct-plansys 216 98 2 1 6 28 8960 6360 [cl-struct-fastseedtype 200 646104 61 -1229568] "DIUSREZA"] [cl-struct-plansys 4 238 6 1 2 16 2560 5892 [cl-struct-fastseedtype 204 121860 91 -132359424] "TEAATIS"] [cl-struct-plansys 93 49 1 4 9 42 24192 6493 [cl-struct-fastseedtype 100 1043549 109 10382592] "RIINUS"] [cl-struct-plansys 244 40 0 2 8 35 16800 5364 [cl-struct-fastseedtype 16 151540 179 -11947264] "ESBIZA"] [cl-struct-plansys 84 164 4 6 6 35 16800 6740 [cl-struct-fastseedtype 112 715092 45 56569088] "ONTIMAXE"] [cl-struct-plansys 194 11 3 0 6 28 6272 4290 [cl-struct-fastseedtype 132 230082 219 36035328] "CEBETELA"] [cl-struct-plansys 245 220 4 5 7 38 16416 4341 [cl-struct-fastseedtype 236 1015029 253 130415872] "CEEDRA"] [cl-struct-plansys 178 84 4 5 8 42 18144 6578 [cl-struct-fastseedtype 40 447922 83 60707584] "RIZALA"] [cl-struct-plansys 55 245 5 3 7 37 10360 3127 [cl-struct-fastseedtype 216 795191 93 13720832] "ATRISO"] [cl-struct-plansys 214 7 7 7 6 39 10296 6102 [cl-struct-fastseedtype 252 467414 155 48012032] "TEANREBI"] [cl-struct-plansys 6 110 6 6 6 37 11840 6662 [cl-struct-fastseedtype 52 128262 205 120573184] "AZAQU"] [cl-struct-plansys 175 218 2 0 8 35 8960 6575 [cl-struct-fastseedtype 0 348847 51 -30526720] "RETILA"] [cl-struct-plansys 123 149 7 0 3 20 1920 4731 [cl-struct-fastseedtype 0 751739 205 46648576] "SOTIQU"] [cl-struct-plansys 186 26 2 6 10 49 31360 6074 [cl-struct-fastseedtype 52 704442 155 -55796992] "INLEUS"] [cl-struct-plansys 22 232 0 7 13 60 52800 6678 [cl-struct-fastseedtype 60 322070 221 125820160] "ONRIRA"] [cl-struct-plansys 18 20 4 3 7 36 12096 4114 [cl-struct-fastseedtype 152 476690 83 77943552] "CEINZALA"] [cl-struct-plansys 245 132 4 5 7 38 16416 4597 [cl-struct-fastseedtype 232 218357 125 88505600] "BIISZA"] [cl-struct-plansys 4 253 5 5 5 31 11160 3076 [cl-struct-fastseedtype 44 913156 219 -121513216] "LEGEES"] [cl-struct-plansys 14 137 3 0 6 28 6272 5390 [cl-struct-fastseedtype 4 78862 45 -10867456] "QUATOR"] [cl-struct-plansys 164 89 1 6 9 44 31680 6820 [cl-struct-fastseedtype 240 408740 179 -101731584] "AREXE"] [cl-struct-plansys 96 130 2 2 6 29 11136 3168 [cl-struct-fastseedtype 144 560736 109 47279360] "ATRABIIN"] [cl-struct-plansys 108 230 6 4 3 23 5888 4972 [cl-struct-fastseedtype 228 950636 91 547584] "USANAT"] [cl-struct-plansys 53 209 3 1 6 29 8120 3381 [cl-struct-fastseedtype 140 37941 189 -127746816] "XEESLE"] [cl-struct-plansys 206 1 3 1 7 33 9240 5326 [cl-struct-fastseedtype 8 488398 83 -13020416] "ORESEREN"] [cl-struct-plansys 82 16 0 7 13 60 52800 5970 [cl-struct-fastseedtype 248 221266 157 23895296] "INERA"] [cl-struct-plansys 204 143 7 3 2 19 3192 6092 [cl-struct-fastseedtype 92 719564 27 69999360] "INUS"] [cl-struct-plansys 52 128 0 2 8 35 16800 6196 [cl-struct-fastseedtype 212 72756 141 71142656] "ISENCE"] [cl-struct-plansys 149 101 5 4 5 30 9600 6549 [cl-struct-fastseedtype 224 425109 51 82719488] "REESDICE"] [cl-struct-plansys 69 109 5 4 5 30 9600 5957 [cl-struct-fastseedtype 32 516677 13 -6550272] "TEREA"] [cl-struct-plansys 26 47 7 2 3 22 3168 5146 [cl-struct-fastseedtype 148 541722 27 -124183808] "ORGETIBE"] [cl-struct-plansys 19 151 7 3 5 31 5208 6419 [cl-struct-fastseedtype 220 578835 157 26123520] "REORTE"] [cl-struct-plansys 164 220 4 7 7 40 21120 5540 [cl-struct-fastseedtype 120 155300 83 -71675136] "QUQUOR"] [cl-struct-plansys 143 153 3 1 8 37 10360 3727 [cl-struct-fastseedtype 8 949903 189 23313664] "GEINONA"] [cl-struct-plansys 111 127 7 1 4 25 3000 5743 [cl-struct-fastseedtype 140 269935 91 -75801856] "ANARLAQU"] [cl-struct-plansys 58 85 5 4 6 34 10880 5178 [cl-struct-fastseedtype 164 534074 237 16379136] "ORESRI"] [cl-struct-plansys 65 190 6 2 3 21 4032 5185 [cl-struct-fastseedtype 208 834369 179 92910336] "ESESLA"] [cl-struct-plansys 104 85 5 6 5 32 12800 4712 [cl-struct-fastseedtype 176 584040 173 -45634304] "SOCELAGE"] [cl-struct-plansys 3 181 7 0 3 20 1920 6403 [cl-struct-fastseedtype 68 644611 219 -21046528] "RIEDQUAT"] [cl-struct-plansys 113 58 2 5 9 44 25344 3697 [cl-struct-fastseedtype 44 359537 125 -98337536] "GEREGE"] [cl-struct-plansys 85 99 3 5 8 41 20664 4949 [cl-struct-fastseedtype 232 421973 83 109597440] "USLE"] [cl-struct-plansys 234 32 0 3 11 48 26880 5866 [cl-struct-fastseedtype 24 792554 221 -112468736] "MALAMA"] [cl-struct-plansys 45 139 3 7 9 47 28952 6701 [cl-struct-fastseedtype 188 701741 155 17799936] "AESBION"] [cl-struct-plansys 223 6 6 6 7 41 13120 6879 [cl-struct-fastseedtype 116 569567 77 11488512] "ALAZA"] [cl-struct-plansys 104 36 6 0 1 11 1408 3432 [cl-struct-fastseedtype 192 80744 51 102904576] "XEAQU"] [cl-struct-plansys 11 58 2 0 8 35 8960 3851 [cl-struct-fastseedtype 64 243467 77 133451008] "RAOROR"] [cl-struct-plansys 102 57 1 6 11 52 37440 5222 [cl-struct-fastseedtype 244 505702 155 114924288] "ORORQU"] [cl-struct-plansys 13 186 2 7 10 50 35200 3085 [cl-struct-fastseedtype 124 569357 93 -113156864] "LEESTI"] [cl-struct-plansys 162 87 7 3 4 27 4536 3746 [cl-struct-fastseedtype 88 646306 83 217856] "GEISGEZA"] [cl-struct-plansys 164 163 3 5 7 37 18648 4004 [cl-struct-fastseedtype 40 1024676 253 88407296] "ZAINLABI"] [cl-struct-plansys 70 117 5 5 7 39 14040 4934 [cl-struct-fastseedtype 236 392262 219 55106304] "USCELA"] [cl-struct-plansys 227 149 7 0 3 20 1920 6371 [cl-struct-fastseedtype 68 647395 173 -25318144] "ISVEVE"] [cl-struct-plansys 202 86 6 6 6 37 11840 4810 [cl-struct-fastseedtype 176 670154 179 85439232] "TIORANIN"] [cl-struct-plansys 108 27 3 2 5 26 8736 3180 [cl-struct-fastseedtype 208 515180 237 63040768] "LEARORCE"] [cl-struct-plansys 133 121 1 4 9 42 24192 5253 [cl-struct-fastseedtype 164 227973 91 21584640] "ESUSTI"] [cl-struct-plansys 168 23 7 1 1 13 1560 5032 [cl-struct-fastseedtype 204 510888 61 101203200] "USUSOR"] [cl-struct-plansys 73 121 3 1 6 29 8120 5705 [cl-struct-fastseedtype 200 983369 83 -57978112] "MAREGEIS"] [cl-struct-plansys 253 35 3 7 9 47 28952 6909 [cl-struct-fastseedtype 56 1016573 29 -110158592] "AATE"] [cl-struct-plansys 251 252 4 3 8 40 13440 4859 [cl-struct-fastseedtype 28 881403 27 -58254592] "SORI"] [cl-struct-plansys 6 0 0 2 10 43 20640 4102 [cl-struct-fastseedtype 20 33030 13 92605696] "CEMAVE"] [cl-struct-plansys 39 22 6 4 6 35 8960 5415 [cl-struct-fastseedtype 160 544039 51 80360192] "ARUSQUDI"] [cl-struct-plansys 205 250 2 4 8 39 19968 3021 [cl-struct-fastseedtype 96 739533 141 -53441280] "EREDVE"] [cl-struct-plansys 159 54 6 2 5 29 5568 6559 [cl-struct-fastseedtype 84 402335 27 -93447424] "REGEATGE"] [cl-struct-plansys 3 81 1 3 11 49 24696 4867 [cl-struct-fastseedtype 28 278787 29 127409408] "EDINSO"] [cl-struct-plansys 12 135 7 7 4 31 8184 2828 [cl-struct-fastseedtype 56 574988 83 75518720] "RA"] [cl-struct-plansys 53 160 2 1 7 32 10240 5429 [cl-struct-fastseedtype 72 781109 61 32128256] "ARONAR"] [cl-struct-plansys 138 223 7 1 3 21 2520 5514 [cl-struct-fastseedtype 76 211594 91 53107456] "ARRAESSO"] [cl-struct-plansys 7 73 1 4 11 50 28800 4103 [cl-struct-fastseedtype 228 516615 109 15035648] "CEVEGE"] [cl-struct-plansys 63 35 3 2 8 38 12768 5183 [cl-struct-fastseedtype 144 181823 179 -73813248] "ORTEVE"] [cl-struct-plansys 108 214 6 6 4 29 9280 2924 [cl-struct-fastseedtype 240 600428 45 121646336] "GEERRA"] [cl-struct-plansys 244 48 2 0 5 23 5888 4852 [cl-struct-fastseedtype 4 690420 219 -89662720] "SOINUSTE"] [cl-struct-plansys 220 104 0 5 10 46 33120 3036 [cl-struct-fastseedtype 108 292828 253 84999424] "ERLAGE"] [cl-struct-plansys 169 67 3 5 8 41 20664 3497 [cl-struct-fastseedtype 168 982185 83 71455488] "XEAAN"] [cl-struct-plansys 140 27 3 3 6 31 12152 4492 [cl-struct-fastseedtype 88 375692 93 47602944] "VEIS"] [cl-struct-plansys 52 224 0 7 11 52 45760 3380 [cl-struct-fastseedtype 124 947764 155 -107832576] "ENSOREUS"] [cl-struct-plansys 168 110 6 6 4 29 9280 6568 [cl-struct-fastseedtype 180 703144 205 -71381760] "RIVEIS"] [cl-struct-plansys 210 61 7 0 2 16 1536 4562 [cl-struct-fastseedtype 128 266194 51 65417984] "BIVEA"] [cl-struct-plansys 139 175 7 0 3 20 1920 2955 [cl-struct-fastseedtype 128 51595 205 -13579008] "ERMASO"] [cl-struct-plansys 195 39 7 6 6 38 9120 4547 [cl-struct-fastseedtype 180 504515 155 106339072] "VELETE"] [cl-struct-plansys 244 92 4 7 7 40 21120 3572 [cl-struct-fastseedtype 188 830964 221 93510912] "ENGEMA"] [cl-struct-plansys 226 107 3 3 8 39 15288 3298 [cl-struct-fastseedtype 24 180450 83 -63876352] "ATRIENXE"] [cl-struct-plansys 66 146 2 5 10 48 27648 3650 [cl-struct-fastseedtype 104 352834 125 -128746240] "BEUSRIOR"] [cl-struct-plansys 57 190 6 5 5 32 9216 6713 [cl-struct-fastseedtype 172 371513 219 -31466752] "ONTIAT"] [cl-struct-plansys 168 113 3 0 4 20 4480 3240 [cl-struct-fastseedtype 132 788392 45 20000000] "ATARZA"] [cl-struct-plansys 160 36 4 6 6 35 16800 6816 [cl-struct-fastseedtype 112 396960 179 -66080000] "ARAZAES"] [cl-struct-plansys 105 132 4 2 5 27 7776 3433 [cl-struct-fastseedtype 16 291433 109 -121475840] "XEERANRE"] [cl-struct-plansys 78 219 3 4 8 40 17920 5454 [cl-struct-fastseedtype 100 736078 91 -36021504] "QUZADI"] [cl-struct-plansys 12 45 7 1 1 13 1560 6156 [cl-struct-fastseedtype 12 513804 189 4046080] "ISTI"] [cl-struct-plansys 117 192 2 1 7 32 10240 6261 [cl-struct-fastseedtype 136 186485 83 11358976] "DIGEBITI"] [cl-struct-plansys 151 6 6 7 8 46 16192 3223 [cl-struct-fastseedtype 120 113559 157 109157632] "LEONED"] [cl-struct-plansys 217 56 0 3 10 44 24640 3545 [cl-struct-fastseedtype 220 598233 27 -80602368] "ENZAER"] [cl-struct-plansys 199 80 0 2 11 47 22560 6087 [cl-struct-fastseedtype 84 1043399 141 -61043456] "TERAED"] [cl-struct-plansys 105 152 0 4 10 45 28800 4457 [cl-struct-fastseedtype 96 950633 51 108409600] "VETITICE"] [cl-struct-plansys 69 87 7 4 3 24 4608 4165 [cl-struct-fastseedtype 160 543557 13 1379584] "LAENIN"] [cl-struct-plansys 212 12 4 2 4 23 6624 3796 [cl-struct-fastseedtype 20 241364 27 -40690944] "BERAANXE"] [cl-struct-plansys 226 219 3 3 8 39 15288 3298 [cl-struct-fastseedtype 92 31970 157 -63857408] "ATAGE"] [cl-struct-plansys 35 3 3 7 11 55 33880 4387 [cl-struct-fastseedtype 248 4899 83 -99200256] "VEISTI"] [cl-struct-plansys 203 119 7 1 4 25 3000 3019 [cl-struct-fastseedtype 136 455115 189 -109003520] "ZAERLA"] [cl-struct-plansys 85 16 2 1 7 32 10240 5205 [cl-struct-fastseedtype 12 868437 91 120150784] "ESREDICE"] [cl-struct-plansys 197 13 5 4 5 30 9600 3013 [cl-struct-fastseedtype 36 298949 237 -127865600] "BEOR"] [cl-struct-plansys 237 89 1 2 8 36 15552 5357 [cl-struct-fastseedtype 80 745709 179 -109464832] "ORSO"] [cl-struct-plansys 97 39 7 6 4 30 7200 4961 [cl-struct-fastseedtype 48 80225 173 -112677632] "USATQURA"] [cl-struct-plansys 148 122 2 0 5 23 5888 2964 [cl-struct-fastseedtype 196 715668 219 -35595520] "ERBITI"] [cl-struct-plansys 55 102 6 5 7 40 11520 6455 [cl-struct-fastseedtype 172 630583 125 9338112] "REINEN"] [cl-struct-plansys 173 242 2 5 9 44 25344 6061 [cl-struct-fastseedtype 104 109229 83 80499456] "ININBI"] [cl-struct-plansys 30 230 6 3 5 30 6720 2846 [cl-struct-fastseedtype 152 875806 221 91282688] "ERLAZA"] [cl-struct-plansys 235 4 4 7 10 52 27456 4331 [cl-struct-fastseedtype 60 324843 155 73767680] "CELABILE"] [cl-struct-plansys 97 166 6 6 5 33 10560 6497 [cl-struct-fastseedtype 244 721505 77 6180096] "RIBISO"] [cl-struct-plansys 236 39 7 0 0 8 768 5612 [cl-struct-fastseedtype 64 999404 51 -8768768] "QUDIRA"] [cl-struct-plansys 251 244 6 0 4 23 2944 6395 [cl-struct-fastseedtype 192 245755 77 8211712] "ISDIBI"] [cl-struct-plansys 208 230 6 6 4 29 9280 3792 [cl-struct-fastseedtype 116 33232 155 52665088] "GEQURE"] [cl-struct-plansys 203 206 6 7 8 46 16192 4043 [cl-struct-fastseedtype 252 496587 93 74734848] "RARERE"] [cl-struct-plansys 209 78 6 3 4 26 5824 6865 [cl-struct-fastseedtype 216 631505 83 19878656] "AERATER"] [cl-struct-plansys 208 81 1 5 9 43 27864 3280 [cl-struct-fastseedtype 168 25552 253 108133632] "ATBEVETE"] [cl-struct-plansys 220 214 6 5 4 28 8064 4572 [cl-struct-fastseedtype 108 789468 219 21420800] "BIORIS"] [cl-struct-plansys 93 29 7 0 1 12 1152 3933 [cl-struct-fastseedtype 196 6237 173 -9130752] "RAALE"] [cl-struct-plansys 38 193 1 6 11 52 37440 4646 [cl-struct-fastseedtype 48 895782 179 114799360] "TIONISLA"] [cl-struct-plansys 85 189 5 2 4 24 5760 3413 [cl-struct-fastseedtype 80 188501 237 -103617280] "ENCERESO"] [cl-struct-plansys 199 14 6 4 6 35 8960 5831 [cl-struct-fastseedtype 36 267207 91 -38053120] "ANERBE"] [cl-struct-plansys 95 19 3 1 8 37 10360 3679 [cl-struct-fastseedtype 76 583263 61 -16564992] "GELAED"] [cl-struct-plansys 81 216 2 1 7 32 10240 6737 [cl-struct-fastseedtype 72 600401 83 60773120] "ONUSORLE"] [cl-struct-plansys 33 185 1 7 11 53 41976 3873 [cl-struct-fastseedtype 184 350753 29 10755328] "ZAONCE"] [cl-struct-plansys 104 69 5 3 4 25 7000 6248 [cl-struct-fastseedtype 156 103528 27 -131261696] "DIQUER"] [cl-struct-plansys 120 112 0 2 8 35 16800 3960 [cl-struct-fastseedtype 148 347256 13 12848384] "ZADIES"] [cl-struct-plansys 91 233 1 4 11 50 28800 3419 [cl-struct-fastseedtype 32 493915 51 32649984] "ENTIZADI"] [cl-struct-plansys 173 132 4 4 6 33 12672 5293 [cl-struct-fastseedtype 224 981421 141 23694592] "ESANBE"] [cl-struct-plansys 184 179 3 2 5 26 8736 5048 [cl-struct-fastseedtype 212 1029560 27 -100132096] "USRALAAT"] [cl-struct-plansys 177 53 5 3 5 29 8120 5809 [cl-struct-fastseedtype 156 997553 29 123411712] "ANLERE"] [cl-struct-plansys 235 78 6 7 8 46 16192 6123 [cl-struct-fastseedtype 184 325099 83 75256576] "TEVERI"] [cl-struct-plansys 81 30 6 1 3 20 3200 4689 [cl-struct-fastseedtype 200 156241 61 2571520] "SOTIERA"] [cl-struct-plansys 207 16 2 1 9 40 12800 5071 [cl-struct-fastseedtype 204 147407 91 -8889600] "EDEDLEEN"] [cl-struct-plansys 114 161 1 4 10 46 26496 6002 [cl-struct-fastseedtype 100 630642 109 -9671424] "INONRI"] [cl-struct-plansys 75 94 6 2 5 29 5568 5195 [cl-struct-fastseedtype 16 490315 179 120173312] "ESBEUS"] [cl-struct-plansys 69 72 0 6 11 51 40800 3141 [cl-struct-fastseedtype 112 305477 45 -77517568] "LERELACE"] [cl-struct-plansys 229 149 7 0 1 12 1152 5349 [cl-struct-fastseedtype 132 151013 219 6937344] "ESZARAXE"] [cl-struct-plansys 130 52 4 5 8 42 18144 5762 [cl-struct-fastseedtype 236 533122 253 77331712] "ANBEEN"] [cl-struct-plansys 97 114 2 5 9 44 25344 4449 [cl-struct-fastseedtype 40 633441 83 2511616] "BIORLE"] [cl-struct-plansys 160 129 1 3 8 37 18648 5792 [cl-struct-fastseedtype 216 347296 93 -115647232] "ANISOR"] [cl-struct-plansys 81 249 1 7 11 53 41976 4945 [cl-struct-fastseedtype 252 180561 155 -108487936] "USRAREMA"] [cl-struct-plansys 11 174 6 6 7 41 13120 6155 [cl-struct-fastseedtype 52 161803 205 109956352] "DISO"] [cl-struct-plansys 182 224 2 0 7 31 7936 6582 [cl-struct-fastseedtype 0 932790 51 14562048] "RIRAES"] [cl-struct-plansys 92 9 3 0 4 20 4480 5212 [cl-struct-fastseedtype 0 764508 205 64605440] "ORRIRA"] [cl-struct-plansys 141 116 4 6 7 39 18720 2957 [cl-struct-fastseedtype 52 652429 155 88120064] "XEER"] [cl-struct-plansys 147 16 0 7 14 64 56320 4243 [cl-struct-fastseedtype 60 397715 221 -35267328] "CEESXE"] [cl-struct-plansys 113 2 2 3 8 38 17024 6257 [cl-struct-fastseedtype 152 12913 83 117265152] "ISATRE"] [cl-struct-plansys 78 224 0 5 12 54 38880 2894 [cl-struct-fastseedtype 232 685902 125 127958272] "AONA"] [cl-struct-plansys 47 191 7 5 6 37 7992 6191 [cl-struct-fastseedtype 44 667183 219 79551232] "ISINOR"] [cl-struct-plansys 3 153 3 0 7 32 7168 4867 [cl-struct-fastseedtype 4 295683 45 21507328] "USZAA"] [cl-struct-plansys 91 47 7 6 6 38 9120 6747 [cl-struct-fastseedtype 240 982875 179 -43011328] "AANBIAT"] [cl-struct-plansys 49 198 6 2 3 21 4032 3633 [cl-struct-fastseedtype 144 374321 109 -17601280] "BEMAERA"] [cl-struct-plansys 239 16 0 4 12 53 33920 6127 [cl-struct-fastseedtype 228 938991 91 -118727936] "ININES"] [cl-struct-plansys 162 201 3 1 7 33 9240 5026 [cl-struct-fastseedtype 140 600482 189 -94847744] "EDZAON"] [cl-struct-plansys 221 191 7 1 2 17 2040 3293 [cl-struct-fastseedtype 8 140253 83 -43953408] "LERITEAN"] [cl-struct-plansys 155 60 4 7 10 52 27456 4507 [cl-struct-fastseedtype 248 241307 157 -2712320] "VEALE"] [cl-struct-plansys 167 33 1 3 11 49 24696 5031 [cl-struct-fastseedtype 92 810407 27 -76014848] "EDLE"] [cl-struct-plansys 25 96 0 2 9 39 18720 5657 [cl-struct-fastseedtype 212 824089 141 -88371968] "ANLAMA"] [cl-struct-plansys 252 11 3 4 6 32 14336 6652 [cl-struct-fastseedtype 224 775420 51 -12700928] "RIBILEBI"] [cl-struct-plansys 6 129 1 4 10 46 26496 6406 [cl-struct-fastseedtype 32 877574 13 -120713984] "RELAES"] [cl-struct-plansys 77 41 1 2 8 36 15552 6221 [cl-struct-fastseedtype 148 723021 27 130882304] "DIZAONER"] [cl-struct-plansys 112 95 7 3 2 19 3192 3952 [cl-struct-fastseedtype 220 533616 157 18128128] "RAZAAR"] [cl-struct-plansys 99 106 2 7 12 58 40832 3427 [cl-struct-fastseedtype 120 925283 83 -72199424] "ENONLA"] [cl-struct-plansys 200 149 7 1 1 13 1560 6344 [cl-struct-fastseedtype 8 986312 189 -35799808] "ISANLEQU"] [cl-struct-plansys 250 225 3 1 7 33 9240 4858 [cl-struct-fastseedtype 140 280826 91 68639488] "TIBECEA"] [cl-struct-plansys 15 5 5 4 7 38 12160 4623 [cl-struct-fastseedtype 164 557327 237 -33035008] "SOTERA"] [cl-struct-plansys 88 52 4 2 4 23 6624 5208 [cl-struct-fastseedtype 208 132440 179 -55987456] "ESVEOR"] [cl-struct-plansys 25 57 1 6 10 48 34560 5145 [cl-struct-fastseedtype 176 330009 173 92908800] "ESTEONBI"] [cl-struct-plansys 230 127 7 0 2 16 1536 3558 [cl-struct-fastseedtype 68 655334 219 -96281856] "XEESENRI"] [cl-struct-plansys 190 210 2 5 10 48 27648 5310 [cl-struct-fastseedtype 44 602558 125 -113672960] "ORESLE"] [cl-struct-plansys 196 193 1 5 9 43 27864 3012 [cl-struct-fastseedtype 232 797636 83 -28290304] "ERVEIN"] [cl-struct-plansys 19 236 4 3 8 40 13440 4115 [cl-struct-fastseedtype 24 907795 221 97901824] "LARAIS"] [cl-struct-plansys 104 189 5 7 6 37 16280 5736 [cl-struct-fastseedtype 188 945000 155 16489216] "ANXEBIZA"] [cl-struct-plansys 164 134 6 6 4 29 9280 6308 [cl-struct-fastseedtype 116 2980 77 105729280] "DIEDAR"] [cl-struct-plansys 47 106 2 0 8 35 8960 3375 [cl-struct-fastseedtype 192 422703 51 1192704] "ENINRE"] [cl-struct-plansys 172 238 6 0 1 11 1408 4524 [cl-struct-fastseedtype 64 366764 77 21384448] "BIBE"] [cl-struct-plansys 249 211 3 6 8 42 23520 6393 [cl-struct-fastseedtype 244 908025 155 78486272] "DIQUXE"] [cl-struct-plansys 74 34 2 7 11 54 38016 4682 [cl-struct-fastseedtype 124 710474 93 -102277888] "SORACE"] [cl-struct-plansys 193 133 5 3 5 29 8120 5825 [cl-struct-fastseedtype 88 139201 83 94065408] "ANXEONIS"] [cl-struct-plansys 189 63 7 5 4 29 6264 6589 [cl-struct-fastseedtype 40 748733 253 64945408] "RIANTIAT"] [cl-struct-plansys 49 119 7 5 4 29 6264 3889 [cl-struct-fastseedtype 236 205361 219 8706816] "ZARECE"] [cl-struct-plansys 152 229 7 0 0 8 768 5784 [cl-struct-fastseedtype 68 898968 173 -22303488] "MAESIN"] [cl-struct-plansys 65 108 4 6 7 39 18720 4673 [cl-struct-fastseedtype 176 129857 179 131576576] "TIBIONIS"] [cl-struct-plansys 253 159 7 2 2 18 2592 3837 [cl-struct-fastseedtype 208 885757 237 2354432] "GELEGEUS"] [cl-struct-plansys 200 227 3 4 6 32 14336 6344 [cl-struct-fastseedtype 164 805832 91 124607232] "DIORA"] [cl-struct-plansys 213 79 7 1 2 17 2040 6613 [cl-struct-fastseedtype 204 839893 61 -96584448] "RIGETI"] [cl-struct-plansys 24 119 7 1 1 13 1560 3608 [cl-struct-fastseedtype 200 522264 83 99832576] "BEGEABI"] [cl-struct-plansys 6 143 7 7 6 39 10296 5126 [cl-struct-fastseedtype 56 264454 29 -65463040] "ORRERE"] [cl-struct-plansys 150 206 6 3 5 30 6720 3734 [cl-struct-fastseedtype 28 68758 27 -49079552] "BETI"] [cl-struct-plansys 171 32 0 2 11 47 22560 3755 [cl-struct-fastseedtype 20 503723 13 37948672] "GERETE"] [cl-struct-plansys 78 252 4 4 7 37 14208 5454 [cl-struct-fastseedtype 160 906318 51 106574592] "QUCERERE"] [cl-struct-plansys 78 78 6 4 5 31 7936 3406 [cl-struct-fastseedtype 96 1022542 141 -29192960] "XEONER"] [cl-struct-plansys 146 112 0 2 10 43 20640 3474 [cl-struct-fastseedtype 84 554642 27 -18736384] "XEZAOR"] [cl-struct-plansys 32 89 1 3 8 37 18648 6432 [cl-struct-fastseedtype 28 585760 29 22945024] "RITILA"] [cl-struct-plansys 139 85 5 7 9 49 21560 5003 [cl-struct-fastseedtype 56 801931 83 129520384] "EDORTE"] [cl-struct-plansys 46 220 6 1 4 24 3840 3886 [cl-struct-fastseedtype 72 770350 61 -89899776] "ZAALELA"] [cl-struct-plansys 213 129 3 1 6 29 8120 4565 [cl-struct-fastseedtype 76 486357 91 -49915136] "BIISORTE"] [cl-struct-plansys 156 57 1 4 8 38 21888 3740 [cl-struct-fastseedtype 228 566428 109 -63738624] "BEESOR"] [cl-struct-plansys 22 217 1 2 9 40 17280 5142 [cl-struct-fastseedtype 144 1044246 179 33141504] "ORESQU"] [cl-struct-plansys 221 250 2 6 9 45 28800 3549 [cl-struct-fastseedtype 240 125149 45 -4051712] "XEQUQUTI"] [cl-struct-plansys 151 58 2 0 8 35 8960 5783 [cl-struct-fastseedtype 4 872855 219 57400064] "MAISES"] [cl-struct-plansys 233 64 0 5 11 50 36000 4585 [cl-struct-fastseedtype 108 785641 253 107412736] "BIERLE"] [cl-struct-plansys 216 225 1 5 9 43 27864 5592 [cl-struct-fastseedtype 168 548568 83 122311424] "ARZASO"] [cl-struct-plansys 117 39 7 3 3 23 3864 2933 [cl-struct-fastseedtype 88 349557 93 60841216] "TEEN"] [cl-struct-plansys 47 82 2 7 12 58 40832 6447 [cl-struct-fastseedtype 124 33583 155 46045952] "RIREDI"] [cl-struct-plansys 45 46 6 6 5 33 10560 5933 [cl-struct-fastseedtype 180 568621 205 127716608] "TEORGE"] [cl-struct-plansys 89 195 3 0 5 24 5376 4441 [cl-struct-fastseedtype 128 480857 51 85340928] "VEBEGE"] [cl-struct-plansys 236 163 3 0 4 20 4480 3564 [cl-struct-fastseedtype 128 826092 205 12766464] "XEENLE"] [cl-struct-plansys 22 1 1 6 11 52 37440 5398 [cl-struct-fastseedtype 180 525590 155 -110454016] "ARXEZA"] [cl-struct-plansys 241 4 4 7 8 44 23232 5105 [cl-struct-fastseedtype 188 955633 221 7920896] "EDREOR"] [cl-struct-plansys 193 217 1 3 9 41 20664 5313 [cl-struct-fastseedtype 24 334529 83 84497152] "ESGEREAN"] [cl-struct-plansys 27 110 6 5 7 40 11520 6171 [cl-struct-fastseedtype 104 594971 125 53312768] "DITIZA"] [cl-struct-plansys 228 0 0 5 10 46 33120 5860 [cl-struct-fastseedtype 172 784356 219 -56894720] "ANLE"] [cl-struct-plansys 29 1 3 0 5 24 5376 6685 [cl-struct-fastseedtype 132 402973 45 -6345472] "ONISQU"] [cl-struct-plansys 215 122 2 6 11 53 33920 6871 [cl-struct-fastseedtype 112 560855 179 -32525568] "ALEUSQU"] [cl-struct-plansys 186 72 0 2 10 43 20640 4026 [cl-struct-fastseedtype 16 580026 109 90467584] "ZASOCEAT"] [cl-struct-plansys 81 133 5 4 5 30 9600 6481 [cl-struct-fastseedtype 100 150353 91 20863744] "RILACE"] [cl-struct-plansys 249 165 7 1 2 17 2040 3833 [cl-struct-fastseedtype 12 920569 189 112442624] "BEENRI"] [cl-struct-plansys 4 254 6 1 2 16 2560 4100 [cl-struct-fastseedtype 136 972292 83 89477888] "LAEDEN"] [cl-struct-plansys 96 178 2 7 9 46 32384 5728 [cl-struct-fastseedtype 120 768352 157 -43279104] "MARIAR"] [cl-struct-plansys 52 74 2 3 7 34 15232 6452 [cl-struct-fastseedtype 220 602420 27 83761920] "RIISER"] [cl-struct-plansys 44 176 0 2 8 35 16800 5420 [cl-struct-fastseedtype 84 954924 141 -10842880] "QUTIRI"] [cl-struct-plansys 80 190 6 4 3 23 5888 4432 [cl-struct-fastseedtype 96 653136 51 -12176640] "BIRAMABI"] [cl-struct-plansys 134 235 3 4 8 40 17920 4742 [cl-struct-fastseedtype 160 1027206 13 -104395520] "SOORBI"] [cl-struct-plansys 135 134 6 2 5 29 5568 4743 [cl-struct-fastseedtype 20 839815 27 122100480] "SOLAGEON"] [cl-struct-plansys 191 35 3 3 9 43 16856 4799 [cl-struct-fastseedtype 92 347071 157 3644672] "TIQUAT"] [cl-struct-plansys 98 17 1 7 12 57 45144 6498 [cl-struct-fastseedtype 248 655458 83 9327360] "REXEBE"] [cl-struct-plansys 132 243 3 1 5 25 7000 5508 [cl-struct-fastseedtype 136 348036 189 -25510656] "QUBEEN"] [cl-struct-plansys 96 242 2 1 6 28 8960 4192 [cl-struct-fastseedtype 12 112736 91 38099712] "CETIISQU"] [cl-struct-plansys 26 61 5 4 6 34 10880 6426 [cl-struct-fastseedtype 36 490010 237 32435456] "REBIA"] [cl-struct-plansys 132 79 7 2 1 14 2016 5252 [cl-struct-fastseedtype 80 10372 179 -15092992] "ORDIMA"] [cl-struct-plansys 146 139 3 6 9 46 25760 5522 [cl-struct-fastseedtype 48 579730 173 34254080] "ARUSZATI"] [cl-struct-plansys 247 196 6 0 4 23 2944 4087 [cl-struct-fastseedtype 196 627447 219 65329920] "ZALERIZA"] [cl-struct-plansys 4 126 6 5 4 28 8064 3844 [cl-struct-fastseedtype 172 373764 125 69500160] "ZASOER"] [cl-struct-plansys 156 208 0 5 10 46 33120 3996 [cl-struct-fastseedtype 104 488348 83 51663616] "RALEEN"] [cl-struct-plansys 199 50 2 3 10 46 20608 5575 [cl-struct-fastseedtype 152 528071 221 -92611328] "QURAVE"] [cl-struct-plansys 166 182 6 7 7 42 14784 3238 [cl-struct-fastseedtype 60 235686 155 114400000] "ATREBIBI"] [cl-struct-plansys 166 166 6 6 6 37 11840 6054 [cl-struct-fastseedtype 244 478374 77 41700608] "TEESDI"] [cl-struct-plansys 51 237 7 0 3 20 1920 5427 [cl-struct-fastseedtype 64 677171 51 132788992] "ARARUS"] [cl-struct-plansys 28 40 2 0 5 23 5888 6684 [cl-struct-fastseedtype 192 639260 77 -95466240] "ARA"] [cl-struct-plansys 227 0 0 6 13 59 47200 4835 [cl-struct-fastseedtype 116 410339 155 -76047616] "TIANVE"] [cl-struct-plansys 136 182 6 7 5 34 11968 5512 [cl-struct-fastseedtype 252 1047176 93 -107324160] "QUORTE"] [cl-struct-plansys 112 252 4 3 5 28 9408 4720 [cl-struct-fastseedtype 216 578416 83 -45657344] "SOLADIES"] [cl-struct-plansys 105 109 5 5 6 35 12600 5737 [cl-struct-fastseedtype 168 474473 253 -41157376] "MAXEEDSO"] [cl-struct-plansys 71 88 0 5 13 58 41760 3399 [cl-struct-fastseedtype 108 769863 219 16964352] "XEXEDI"] [cl-struct-plansys 146 237 7 0 2 16 1536 3474 [cl-struct-fastseedtype 196 933522 173 -64836352] "XEXETI"] [cl-struct-plansys 29 87 7 6 4 30 7200 4637 [cl-struct-fastseedtype 48 961053 179 -132664576] "TIINLEBI"] [cl-struct-plansys 102 193 1 2 9 40 17280 3942 [cl-struct-fastseedtype 80 280422 237 112520448] "RATEEDAR"] [cl-struct-plansys 138 248 0 4 11 49 31360 6794 [cl-struct-fastseedtype 36 434826 91 -27305216] "ONLEMA"] [cl-struct-plansys 12 203 3 1 5 25 7000 5132 [cl-struct-fastseedtype 76 854796 61 129580288] "ORERVE"]] [[cl-struct-plansys 4 180 4 2 4 23 6624 6660 [cl-struct-fastseedtype 144 4 166 7316992] "AUSIS"] [cl-struct-plansys 53 157 5 6 6 36 14400 5685 [cl-struct-fastseedtype 112 821 58 100350464] "ANDIRI"] [cl-struct-plansys 199 254 6 7 8 46 16192 3783 [cl-struct-fastseedtype 56 9415 54 59979264] "BEEDBEON"] [cl-struct-plansys 159 179 3 5 10 49 24696 5791 [cl-struct-fastseedtype 40 107679 26 95099392] "MAISSO"] [cl-struct-plansys 240 71 7 0 0 8 768 4336 [cl-struct-fastseedtype 64 183792 102 104162816] "LADIBE"] [cl-struct-plansys 53 147 3 0 5 24 5376 4405 [cl-struct-fastseedtype 192 472373 26 70654464] "VERIAR"] [cl-struct-plansys 159 106 2 5 11 52 29952 5279 [cl-struct-fastseedtype 168 979871 54 50935296] "ESBETE"] [cl-struct-plansys 217 188 4 7 8 44 23232 5337 [cl-struct-fastseedtype 56 741337 58 -56018432] "ESRILEES"] [cl-struct-plansys 169 193 1 6 10 48 34560 5289 [cl-struct-fastseedtype 112 943529 166 -22436352] "ESRASOCE"] [cl-struct-plansys 37 103 7 2 2 18 2592 3109 [cl-struct-fastseedtype 144 385317 122 60914176] "LERELA"] [cl-struct-plansys 197 245 5 3 5 29 8120 5317 [cl-struct-fastseedtype 152 260293 182 -35015168] "ESZARA"] [cl-struct-plansys 226 84 6 1 4 24 3840 5858 [cl-struct-fastseedtype 200 490466 218 -103032320] "ANENAT"] [cl-struct-plansys 192 209 1 4 8 38 21888 4032 [cl-struct-fastseedtype 32 790464 102 94660096] "ZALAQURA"] [cl-struct-plansys 116 154 2 4 7 35 17920 4212 [cl-struct-fastseedtype 224 921972 90 -45786624] "CERARE"] [cl-struct-plansys 169 14 6 1 3 20 3200 6057 [cl-struct-fastseedtype 8 953001 182 -133384704] "INZAQUMA"] [cl-struct-plansys 75 122 2 3 10 46 20608 5451 [cl-struct-fastseedtype 216 154699 250 9107968] "ARATUSZA"] [cl-struct-plansys 4 40 0 2 8 35 16800 6148 [cl-struct-fastseedtype 80 48644 166 -75651584] "ISARIN"] [cl-struct-plansys 83 44 4 6 9 47 22560 5203 [cl-struct-fastseedtype 176 164435 186 -114705920] "ESESBI"] [cl-struct-plansys 249 38 6 7 6 38 13376 5625 [cl-struct-fastseedtype 248 109561 54 -20302336] "ARMAAZA"] [cl-struct-plansys 100 175 7 5 3 25 5400 6500 [cl-struct-fastseedtype 104 1027428 154 -67200512] "RIENLA"] [cl-struct-plansys 134 117 7 0 2 16 1536 6278 [cl-struct-fastseedtype 0 479622 102 118318592] "DIUSTE"] [cl-struct-plansys 178 156 6 0 3 19 2432 4530 [cl-struct-fastseedtype 0 36786 154 -128542208] "VEZADI"] [cl-struct-plansys 168 173 5 5 5 31 11160 5544 [cl-struct-fastseedtype 104 684456 54 -84265472] "QUAEN"] [cl-struct-plansys 60 242 2 7 9 46 32384 6460 [cl-struct-fastseedtype 120 852540 186 -109135360] "RIDIUSLA"] [cl-struct-plansys 149 104 0 6 11 51 40800 5781 [cl-struct-fastseedtype 48 254101 166 128689664] "MAESARON"] [cl-struct-plansys 63 234 2 2 9 41 15744 3647 [cl-struct-fastseedtype 208 402239 250 -19662336] "BERIEN"] [cl-struct-plansys 228 18 2 3 7 34 15232 4068 [cl-struct-fastseedtype 88 256228 182 49591808] "RAMAZA"] [cl-struct-plansys 164 196 6 1 2 16 2560 3748 [cl-struct-fastseedtype 8 889508 90 39016960] "BEANEN"] [cl-struct-plansys 193 178 2 4 8 39 19968 3009 [cl-struct-fastseedtype 224 982209 102 120612352] "ERCETIDI"] [cl-struct-plansys 109 151 7 4 3 24 4608 5229 [cl-struct-fastseedtype 32 828013 218 -39200256] "ESRECE"] [cl-struct-plansys 29 197 7 1 2 17 2040 3101 [cl-struct-fastseedtype 200 228637 182 -57559552] "ATRAZAMA"] [cl-struct-plansys 43 36 4 3 8 40 13440 3883 [cl-struct-fastseedtype 24 297259 122 96762368] "ZARAGETE"] [cl-struct-plansys 220 3 3 2 5 26 8736 3804 [cl-struct-fastseedtype 16 1046748 166 -67918336] "BEBEGE"] [cl-struct-plansys 105 163 3 6 8 42 23520 2921 [cl-struct-fastseedtype 240 646249 58 -52413952] "DITI"] [cl-struct-plansys 4 55 7 7 4 31 8184 5124 [cl-struct-fastseedtype 184 56836 54 -14076416] "ESCEBELE"] [cl-struct-plansys 33 147 3 5 8 41 20664 5409 [cl-struct-fastseedtype 168 708897 26 52042240] "QUREAR"] [cl-struct-plansys 243 10 2 0 8 35 8960 6387 [cl-struct-fastseedtype 192 339699 102 -87202304] "DIMADI"] [cl-struct-plansys 38 141 7 0 2 16 1536 6694 [cl-struct-fastseedtype 64 1046566 26 92215808] "ONENTI"] [cl-struct-plansys 137 215 7 5 4 29 6264 3721 [cl-struct-fastseedtype 40 288137 54 93533696] "BERAER"] [cl-struct-plansys 151 16 0 7 14 64 56320 6039 [cl-struct-fastseedtype 184 353431 58 60570112] "TEZAEDED"] [cl-struct-plansys 88 120 0 6 10 47 37600 4184 [cl-struct-fastseedtype 240 83544 166 -116021760] "LABILAEN"] [cl-struct-plansys 82 85 5 2 5 28 6720 6482 [cl-struct-fastseedtype 16 877138 122 -74548736] "REVEVE"] [cl-struct-plansys 219 22 6 3 6 34 7616 4827 [cl-struct-fastseedtype 24 982491 182 2602496] "SOORTE"] [cl-struct-plansys 93 28 6 1 3 20 3200 3421 [cl-struct-fastseedtype 72 596573 218 76732928] "ENINTE"] [cl-struct-plansys 155 252 4 4 8 41 15744 3995 [cl-struct-fastseedtype 160 817563 102 -22780416] "ZATETEIS"] [cl-struct-plansys 93 124 4 4 6 33 12672 4445 [cl-struct-fastseedtype 96 375645 90 -132752896] "VEERGE"] [cl-struct-plansys 106 99 3 1 7 33 9240 6506 [cl-struct-fastseedtype 136 427882 182 113161728] "RIDIVEXE"] [cl-struct-plansys 2 182 6 3 5 30 6720 4098 [cl-struct-fastseedtype 88 62466 250 21363200] "CERISOMA"] [cl-struct-plansys 139 71 7 2 4 26 3744 3211 [cl-struct-fastseedtype 208 56459 166 131180032] "ATZAXE"] [cl-struct-plansys 120 2 2 6 8 41 26240 6520 [cl-struct-fastseedtype 48 312696 186 52345344] "RIEDA"] [cl-struct-plansys 231 47 7 7 7 43 11352 3047 [cl-struct-fastseedtype 120 638695 54 -89115136] "ERSOONVE"] [cl-struct-plansys 214 95 7 5 5 33 7128 6358 [cl-struct-fastseedtype 232 256982 154 -50488832] "ISBEUS"] [cl-struct-plansys 57 8 2 0 6 27 6912 4153 [cl-struct-fastseedtype 128 41529 102 125134336] "LATIBI"] [cl-struct-plansys 146 102 6 0 3 19 2432 6802 [cl-struct-fastseedtype 128 283282 154 -38823424] "AUSAR"] [cl-struct-plansys 65 234 2 5 9 44 25344 3905 [cl-struct-fastseedtype 232 435009 54 -120310272] "RAVE"] [cl-struct-plansys 234 22 6 7 7 42 14784 3306 [cl-struct-fastseedtype 248 1000170 186 -50218496] "LEGEARA"] [cl-struct-plansys 244 239 7 6 3 26 6240 4852 [cl-struct-fastseedtype 176 877300 166 -119036416] "SOINUSTE"] [cl-struct-plansys 92 168 0 2 8 35 16800 2908 [cl-struct-fastseedtype 80 406108 250 -70190592] "ERLAGE"] [cl-struct-plansys 169 3 3 3 7 35 13720 3497 [cl-struct-fastseedtype 216 416681 182 -75319808] "XEATE"] [cl-struct-plansys 14 92 6 1 4 24 3840 5390 [cl-struct-fastseedtype 136 151310 90 43670016] "QUCEDI"] [cl-struct-plansys 77 173 5 4 5 30 9600 2893 [cl-struct-fastseedtype 96 1008205 102 33580544] "ANESCE"] [cl-struct-plansys 69 73 1 4 9 42 24192 5445 [cl-struct-fastseedtype 160 729157 218 -24454656] "ARORAR"] [cl-struct-plansys 143 234 2 1 9 40 12800 3727 [cl-struct-fastseedtype 72 630159 182 -57428480] "BEDIERAT"] [cl-struct-plansys 209 48 0 3 10 44 24640 6865 [cl-struct-fastseedtype 152 51409 122 84900352] "AATENBE"] [cl-struct-plansys 19 242 2 2 9 41 15744 4627 [cl-struct-fastseedtype 144 251155 166 85435904] "TIISES"] [cl-struct-plansys 126 73 1 6 11 52 37440 4222 [cl-struct-fastseedtype 112 504190 58 -35309056] "CEINER"] [cl-struct-plansys 162 16 0 7 13 60 52800 6818 [cl-struct-fastseedtype 56 561826 54 123680256] "ONATBEZA"] [cl-struct-plansys 132 19 3 5 7 37 18648 5252 [cl-struct-fastseedtype 40 563588 26 -72803840] "ESDI"] [cl-struct-plansys 87 109 7 0 3 20 1920 4183 [cl-struct-fastseedtype 64 75607 102 50685440] "CEARSO"] [cl-struct-plansys 246 39 7 0 2 16 1536 5110 [cl-struct-fastseedtype 192 17142 26 48765440] "USCEZA"] [cl-struct-plansys 210 228 4 5 8 42 18144 6354 [cl-struct-fastseedtype 168 81618 54 -88263168] "ISRAZA"] [cl-struct-plansys 54 4 4 7 9 48 25344 6710 [cl-struct-fastseedtype 56 10550 58 128924160] "AESAUS"] [cl-struct-plansys 104 207 7 6 3 26 6240 3176 [cl-struct-fastseedtype 112 541288 166 -48126464] "LEORGERI"] [cl-struct-plansys 94 227 3 2 7 34 11424 5726 [cl-struct-fastseedtype 144 845662 122 26966528] "ANISTI"] [cl-struct-plansys 80 215 7 3 2 19 3192 4176 [cl-struct-fastseedtype 152 484944 182 -83511808] "CEDIZA"] [cl-struct-plansys 183 132 6 1 5 28 4480 5303 [cl-struct-fastseedtype 200 666807 218 -26617344] "ESCESO"] [cl-struct-plansys 215 199 7 4 5 32 6144 4055 [cl-struct-fastseedtype 32 119511 102 121923072] "ZAXERICE"] [cl-struct-plansys 37 254 6 4 4 27 6912 4645 [cl-struct-fastseedtype 224 939301 90 50813440] "SOMAED"] [cl-struct-plansys 140 88 2 1 6 28 8960 2956 [cl-struct-fastseedtype 8 62348 182 68204032] "ERLAENED"] [cl-struct-plansys 152 146 2 3 7 34 15232 2968 [cl-struct-fastseedtype 216 258968 250 52492800] "INBIBE"] [cl-struct-plansys 115 6 6 2 5 29 5568 4211 [cl-struct-fastseedtype 80 953971 166 -104487424] "CEONED"] [cl-struct-plansys 124 120 0 6 10 47 37600 3708 [cl-struct-fastseedtype 176 316540 186 -13387264] "BEUSED"] [cl-struct-plansys 52 216 0 7 11 52 45760 4404 [cl-struct-fastseedtype 248 122164 54 -80333312] "VEZAAES"] [cl-struct-plansys 41 175 7 5 4 29 6264 5929 [cl-struct-fastseedtype 104 734761 154 18651648] "TELAAN"] [cl-struct-plansys 77 59 3 0 5 24 5376 6221 [cl-struct-fastseedtype 0 621133 102 58549760] "ISCEER"] [cl-struct-plansys 83 208 2 0 8 35 8960 4947 [cl-struct-fastseedtype 0 142675 154 120101376] "USMASO"] [cl-struct-plansys 59 199 7 5 6 37 7992 6459 [cl-struct-fastseedtype 104 166971 54 21902848] "REERQU"] [cl-struct-plansys 121 218 2 7 10 50 35200 3961 [cl-struct-fastseedtype 120 25465 186 94681600] "ZAEDVERA"] [cl-struct-plansys 180 22 6 6 4 29 9280 3764 [cl-struct-fastseedtype 48 209076 166 -71064064] "GEREBIED"] [cl-struct-plansys 88 6 6 2 2 17 3264 6232 [cl-struct-fastseedtype 208 496984 250 -17958400] "DIDIRA"] [cl-struct-plansys 207 148 4 3 8 40 13440 3023 [cl-struct-fastseedtype 88 246223 182 78689792] "ERRARA"] [cl-struct-plansys 89 148 6 1 3 20 3200 3161 [cl-struct-fastseedtype 8 159577 90 -100574720] "LEREUS"] [cl-struct-plansys 56 72 0 4 9 41 26240 2872 [cl-struct-fastseedtype 224 337720 102 74475008] "ERENANRI"] [cl-struct-plansys 254 155 3 4 8 40 17920 5886 [cl-struct-fastseedtype 32 564734 218 126605824] "MACEA"] [cl-struct-plansys 96 175 7 1 1 13 1560 4192 [cl-struct-fastseedtype 200 720224 182 53851648] "LACETEED"] [cl-struct-plansys 88 220 4 3 5 28 9408 5464 [cl-struct-fastseedtype 24 598104 122 -42305024] "QUALEMA"] [cl-struct-plansys 171 129 1 2 10 44 19008 5803 [cl-struct-fastseedtype 16 259243 166 -69491200] "ANUSA"] [cl-struct-plansys 114 143 7 6 5 34 8160 5490 [cl-struct-fastseedtype 240 270962 58 -116770304] "ARINES"] [cl-struct-plansys 159 137 1 7 13 61 48312 4255 [cl-struct-fastseedtype 184 680607 54 -63621632] "LARIBEBI"] [cl-struct-plansys 198 51 3 5 9 45 22680 5062 [cl-struct-fastseedtype 168 712134 26 -11003392] "EDATER"] [cl-struct-plansys 26 112 2 0 7 31 7936 6170 [cl-struct-fastseedtype 192 1021722 102 -19044864] "ISUSLE"] [cl-struct-plansys 167 97 3 0 7 32 7168 3239 [cl-struct-fastseedtype 64 800167 26 -59696640] "ATORAT"] [cl-struct-plansys 124 145 1 5 9 43 27864 4732 [cl-struct-fastseedtype 40 991100 54 42415616] "SOLAED"] [cl-struct-plansys 180 152 0 7 11 52 45760 3508 [cl-struct-fastseedtype 184 196020 58 -119391744] "XEABITI"] [cl-struct-plansys 215 198 6 6 7 41 13120 6359 [cl-struct-fastseedtype 240 571863 166 -87185920] "DIMAATMA"] [cl-struct-plansys 75 17 1 2 10 44 19008 4939 [cl-struct-fastseedtype 16 921675 122 97024512] "USCEED"] [cl-struct-plansys 38 56 0 3 11 48 26880 3622 [cl-struct-fastseedtype 24 610854 182 -24922624] "GEXEIN"] [cl-struct-plansys 242 140 6 1 4 24 3840 3058 [cl-struct-fastseedtype 72 365298 218 123787776] "ONEN"] [cl-struct-plansys 114 50 2 4 9 43 22016 3954 [cl-struct-fastseedtype 160 654194 102 -8100352] "ZAESRE"] [cl-struct-plansys 206 32 0 4 11 49 31360 5070 [cl-struct-fastseedtype 96 196302 90 -31958528] "EDSODI"] [cl-struct-plansys 13 237 7 1 2 17 2040 3341 [cl-struct-fastseedtype 136 552717 182 177664] "XERIREA"] [cl-struct-plansys 15 14 6 3 6 34 7616 5647 [cl-struct-fastseedtype 88 375567 250 102496768] "ANORCEQU"] [cl-struct-plansys 186 101 5 2 5 28 6720 5306 [cl-struct-fastseedtype 208 799674 166 22652416] "ORORRE"] [cl-struct-plansys 97 142 6 6 5 33 10560 4961 [cl-struct-fastseedtype 48 741217 186 -43468288] "USTILE"] [cl-struct-plansys 226 33 1 7 12 57 45144 6114 [cl-struct-fastseedtype 120 992994 54 6043136] "TEONAN"] [cl-struct-plansys 91 159 7 5 6 37 7992 5723 [cl-struct-fastseedtype 232 748635 154 -128214528] "ANVERE"] [cl-struct-plansys 192 14 6 0 1 11 1408 4288 [cl-struct-fastseedtype 128 309696 102 -81435136] "CERAQU"] [cl-struct-plansys 243 218 2 0 8 35 8960 3315 [cl-struct-fastseedtype 128 802803 154 79796736] "LEAZA"] [cl-struct-plansys 148 68 4 5 6 34 14688 5012 [cl-struct-fastseedtype 232 642196 54 73938432] "USLERI"] [cl-struct-plansys 231 62 6 7 8 46 16192 4839 [cl-struct-fastseedtype 248 902119 186 57129472] "SOREISBE"] [cl-struct-plansys 211 221 5 6 8 44 17600 6867 [cl-struct-fastseedtype 176 305619 166 4171264] "ONATZALA"] [cl-struct-plansys 53 4 4 2 5 27 7776 5429 [cl-struct-fastseedtype 80 126005 250 -131401216] "ARZACE"] [cl-struct-plansys 84 197 5 3 4 25 7000 6484 [cl-struct-fastseedtype 216 670548 182 -25250304] "RIEDIN"] [cl-struct-plansys 131 108 6 1 5 28 4480 4995 [cl-struct-fastseedtype 136 971651 90 -125281792] "USEDGE"] [cl-struct-plansys 132 131 3 4 6 32 14336 2948 [cl-struct-fastseedtype 96 535428 102 -25139712] "USDIVE"] [cl-struct-plansys 150 141 5 4 6 34 10880 6038 [cl-struct-fastseedtype 160 932758 218 -122889728] "INERRA"] [cl-struct-plansys 146 20 6 1 4 24 3840 4754 [cl-struct-fastseedtype 72 277650 182 7845376] "TIRIUSRI"] [cl-struct-plansys 190 40 0 3 11 48 26880 4286 [cl-struct-fastseedtype 152 913342 122 -16418304] "CEINERXE"] [cl-struct-plansys 162 176 0 2 10 43 20640 6818 [cl-struct-fastseedtype 144 833442 166 4171264] "ONENLA"] [cl-struct-plansys 71 117 5 6 8 44 17600 6727 [cl-struct-fastseedtype 112 380743 58 -28362240] "AMAXE"] [cl-struct-plansys 253 162 2 7 10 50 35200 5885 [cl-struct-fastseedtype 56 880125 54 -39111168] "MAARBEES"] [cl-struct-plansys 233 243 3 5 8 41 20664 4841 [cl-struct-fastseedtype 40 884201 26 -30991872] "SOGEBE"] [cl-struct-plansys 62 19 3 0 6 28 6272 4158 [cl-struct-fastseedtype 64 876094 102 -27957760] "LASOAN"] [cl-struct-plansys 55 59 3 0 7 32 7168 5431 [cl-struct-fastseedtype 192 258103 26 35265024] "QUINRI"] [cl-struct-plansys 133 222 6 5 5 32 9216 3205 [cl-struct-fastseedtype 168 763781 54 -51300864] "ATLAIN"] [cl-struct-plansys 19 204 4 7 10 52 27456 4115 [cl-struct-fastseedtype 56 82451 58 120928768] "LARAISSO"] [cl-struct-plansys 167 93 5 6 8 44 17600 5287 [cl-struct-fastseedtype 112 789671 166 35235328] "ORRIONTI"] [cl-struct-plansys 23 223 7 2 4 26 3744 4119 [cl-struct-fastseedtype 144 425239 122 -132810240] "LAINOR"] [cl-struct-plansys 91 57 1 3 11 49 24696 3163 [cl-struct-fastseedtype 152 319835 182 -90065408] "LEVERA"] [cl-struct-plansys 12 52 6 1 2 16 2560 4620 [cl-struct-fastseedtype 200 142604 218 -8922624] "TIEDIS"] [cl-struct-plansys 110 61 5 4 6 34 10880 3950 [cl-struct-fastseedtype 32 447342 102 124020224] "ZAAXEVE"] [cl-struct-plansys 86 226 2 4 9 43 22016 5206 [cl-struct-fastseedtype 224 710742 90 -112633344] "ESXEXE"] [cl-struct-plansys 239 34 2 1 9 40 12800 4079 [cl-struct-fastseedtype 8 760303 182 -90917376] "RABIARCE"] [cl-struct-plansys 101 42 2 3 8 38 17024 4453 [cl-struct-fastseedtype 216 830053 250 -97060352] "VESOZAXE"] [cl-struct-plansys 98 100 4 2 6 31 8928 6242 [cl-struct-fastseedtype 80 11362 166 -24271360] "DIRAZA"] [cl-struct-plansys 37 68 4 6 7 39 18720 6181 [cl-struct-fastseedtype 176 841253 186 -37897728] "ISSOAR"] [cl-struct-plansys 239 10 2 7 12 58 40832 3567 [cl-struct-fastseedtype 248 703471 54 -98421248] "XEISARE"] [cl-struct-plansys 110 47 7 5 5 33 7128 5486 [cl-struct-fastseedtype 104 421486 154 45783552] "QUEDLE"] [cl-struct-plansys 148 129 3 0 4 20 4480 6292 [cl-struct-fastseedtype 0 606356 102 -26384896] "DIXEZA"] [cl-struct-plansys 116 132 6 0 1 11 1408 5492 [cl-struct-fastseedtype 0 43636 154 108698112] "QUENLE"] [cl-struct-plansys 78 97 1 5 11 51 33048 3406 [cl-struct-fastseedtype 104 787534 54 35796480] "XEATXE"] [cl-struct-plansys 54 66 2 7 11 54 38016 5430 [cl-struct-fastseedtype 120 50230 186 105560576] "ARGEZABE"] [cl-struct-plansys 83 68 4 6 9 47 22560 5715 [cl-struct-fastseedtype 48 339539 166 106669568] "ANBEXEAT"] [cl-struct-plansys 241 162 2 2 7 33 12672 4849 [cl-struct-fastseedtype 208 579313 250 126351872] "SOTEVE"] [cl-struct-plansys 58 150 6 3 5 30 6720 5946 [cl-struct-fastseedtype 88 780346 182 -118704640] "INISZA"] [cl-struct-plansys 142 228 6 1 4 24 3840 6798 [cl-struct-fastseedtype 8 285582 90 -30451200] "ALERI"] [cl-struct-plansys 47 94 6 4 6 35 8960 2863 [cl-struct-fastseedtype 224 282415 102 3171840] "ERONONA"] [cl-struct-plansys 15 31 7 4 5 32 6144 6159 [cl-struct-fastseedtype 32 71951 218 32365056] "DITEOR"] [cl-struct-plansys 35 25 3 1 8 37 10360 5155 [cl-struct-fastseedtype 200 391971 182 72988160] "ORVERACE"] [cl-struct-plansys 5 20 4 3 6 32 10752 2821 [cl-struct-fastseedtype 24 759557 122 -105874944] "ERARONQU"] [cl-struct-plansys 250 127 7 2 3 22 3168 3834 [cl-struct-fastseedtype 16 949754 166 37987840] "GEISAN"] [cl-struct-plansys 251 251 3 6 10 50 28000 4091 [cl-struct-fastseedtype 240 1005563 58 -38520320] "RAMAAN"] [cl-struct-plansys 186 91 3 7 10 51 31416 3258 [cl-struct-fastseedtype 184 840890 54 -71223808] "LETIBEMA"] [cl-struct-plansys 235 83 3 5 10 49 24696 4587 [cl-struct-fastseedtype 168 547307 26 -132769280] "VERAVE"] [cl-struct-plansys 193 86 6 0 2 15 1920 6337 [cl-struct-fastseedtype 192 744641 102 23946752] "DICELA"] [cl-struct-plansys 168 181 7 0 0 8 768 3752 [cl-struct-fastseedtype 64 234152 26 65214976] "GEMA"] [cl-struct-plansys 239 203 3 5 10 49 24696 5871 [cl-struct-fastseedtype 40 554735 54 -100977152] "ANVE"] [cl-struct-plansys 81 160 0 7 12 56 49280 4945 [cl-struct-fastseedtype 184 677457 58 44579328] "USQURAVE"] [cl-struct-plansys 214 148 4 6 8 43 20640 4310 [cl-struct-fastseedtype 240 1022678 166 50701824] "CEERDIZA"] [cl-struct-plansys 196 77 5 2 3 20 4800 3524 [cl-struct-fastseedtype 16 511428 122 -125666816] "XERAQU"] [cl-struct-plansys 241 218 2 3 8 38 17024 6897 [cl-struct-fastseedtype 24 930801 182 -10504704] "ONMATE"] [cl-struct-plansys 7 124 6 1 5 28 4480 6407 [cl-struct-fastseedtype 72 187143 218 112122368] "REENUS"] [cl-struct-plansys 201 232 0 4 10 45 28800 4041 [cl-struct-fastseedtype 160 932553 102 -18586112] "ZAVEZAON"] [cl-struct-plansys 191 68 4 4 8 41 15744 5567 [cl-struct-fastseedtype 96 590271 90 77224448] "QURITI"] [cl-struct-plansys 48 247 7 1 1 13 1560 4400 [cl-struct-fastseedtype 136 857136 182 63354368] "BIABITE"] [cl-struct-plansys 156 230 6 3 3 22 4928 3228 [cl-struct-fastseedtype 88 729500 250 -9307648] "ATRAGEES"] [cl-struct-plansys 105 3 3 2 6 30 10080 3177 [cl-struct-fastseedtype 208 317545 166 23176704] "LEREQU"] [cl-struct-plansys 202 154 2 6 10 49 31360 3530 [cl-struct-fastseedtype 48 657610 186 3324416] "ENVEBE"] [cl-struct-plansys 93 147 3 7 9 47 28952 4957 [cl-struct-fastseedtype 120 113757 54 -125291008] "USORON"] [cl-struct-plansys 96 95 7 5 3 25 5400 5216 [cl-struct-fastseedtype 232 662624 154 3774976] "ORORRA"] [cl-struct-plansys 199 148 6 0 4 23 2944 4295 [cl-struct-fastseedtype 128 126663 102 -44734976] "LAATRE"] [cl-struct-plansys 212 206 6 0 1 11 1408 3796 [cl-struct-fastseedtype 128 625876 154 -61629952] "BEVERI"] [cl-struct-plansys 103 30 6 5 7 40 11520 5991 [cl-struct-fastseedtype 232 840551 54 -92523008] "TEXEBI"] [cl-struct-plansys 100 230 6 7 5 34 11968 6244 [cl-struct-fastseedtype 248 967780 186 -28460544] "DIORMAEN"] [cl-struct-plansys 50 75 3 6 9 46 25760 4658 [cl-struct-fastseedtype 176 794162 166 -32004608] "TIVERE"] [cl-struct-plansys 142 224 0 2 10 43 20640 3982 [cl-struct-fastseedtype 80 783758 250 -50005504] "ZABESO"] [cl-struct-plansys 127 7 7 3 5 31 5208 5503 [cl-struct-fastseedtype 216 977023 182 66762240] "QULETE"] [cl-struct-plansys 120 252 6 1 2 16 2560 4472 [cl-struct-fastseedtype 136 780152 90 -84518400] "VEMAOR"] [cl-struct-plansys 59 217 1 4 11 50 28800 2875 [cl-struct-fastseedtype 96 619067 102 -109025792] "LAATSO"] [cl-struct-plansys 103 81 1 4 11 50 28800 6503 [cl-struct-fastseedtype 160 153191 218 55499264] "RESORI"] [cl-struct-plansys 21 190 6 1 3 20 3200 5653 [cl-struct-fastseedtype 72 317717 182 -19155456] "ANAMA"] [cl-struct-plansys 43 160 0 3 12 52 29120 5675 [cl-struct-fastseedtype 152 685611 122 -42239488] "ANSOREAT"] [cl-struct-plansys 177 238 6 2 3 21 4032 4785 [cl-struct-fastseedtype 144 894897 166 31958528] "SOSOLE"] [cl-struct-plansys 144 33 1 6 9 44 31680 5264 [cl-struct-fastseedtype 112 1006736 58 121190912] "ORARRA"] [cl-struct-plansys 216 180 4 7 7 40 21120 4824 [cl-struct-fastseedtype 56 505560 54 108475904] "TIGEBERE"] [cl-struct-plansys 206 83 3 5 9 45 22680 4302 [cl-struct-fastseedtype 40 1003982 26 -47900160] "CEBIOR"] [cl-struct-plansys 165 57 3 0 5 24 5376 4261 [cl-struct-fastseedtype 64 946853 102 -131766784] "CEZAA"] [cl-struct-plansys 248 207 7 0 0 8 768 6136 [cl-struct-fastseedtype 192 212216 26 30153216] "INBEED"] [cl-struct-plansys 184 88 0 5 10 46 33120 4280 [cl-struct-fastseedtype 168 732600 54 -106613248] "CEVERA"] [cl-struct-plansys 112 20 4 7 7 40 21120 5744 [cl-struct-fastseedtype 56 629360 58 -80004608] "ANONMABI"] [cl-struct-plansys 102 107 3 6 9 46 25760 3174 [cl-struct-fastseedtype 112 312422 166 -40786432] "ATGEANER"] [cl-struct-plansys 80 91 3 2 5 26 8736 6736 [cl-struct-fastseedtype 144 1024592 122 118454784] "AANAN"] [cl-struct-plansys 230 27 3 3 8 39 15288 6374 [cl-struct-fastseedtype 152 879078 182 -54675968] "ISONZA"] [cl-struct-plansys 225 100 6 1 3 20 3200 4321 [cl-struct-fastseedtype 200 425185 218 -49948160] "CEMABE"] [cl-struct-plansys 133 51 3 4 7 36 16128 3973 [cl-struct-fastseedtype 32 659845 102 100951552] "ZATEBISO"] [cl-struct-plansys 7 70 6 4 6 35 8960 5639 [cl-struct-fastseedtype 224 826119 90 743936] "MAORIN"] [cl-struct-plansys 210 108 6 1 4 24 3840 5074 [cl-struct-fastseedtype 8 228818 182 -73878016] "EDTIXEEN"] [cl-struct-plansys 178 66 2 3 9 42 18816 6066 [cl-struct-fastseedtype 216 1015986 250 97319424] "INXEXEAT"] [cl-struct-plansys 209 66 2 2 7 33 12672 4305 [cl-struct-fastseedtype 80 563153 166 -103438848] "LAESER"] [cl-struct-plansys 78 144 0 6 12 55 44000 4686 [cl-struct-fastseedtype 176 1017678 186 80198144] "SOBITE"] [cl-struct-plansys 42 188 4 7 9 48 25344 6442 [cl-struct-fastseedtype 248 346154 54 -74566144] "REVEABE"] [cl-struct-plansys 51 47 7 5 6 37 7992 4915 [cl-struct-fastseedtype 104 22067 154 14195200] "EDANSO"] [cl-struct-plansys 91 71 7 0 3 20 1920 6235 [cl-struct-fastseedtype 0 894043 102 131950080] "ISONED"] [cl-struct-plansys 21 184 2 0 6 27 6912 5909 [cl-struct-fastseedtype 0 853781 154 105683456] "INORAN"] [cl-struct-plansys 225 123 3 5 8 41 20664 4577 [cl-struct-fastseedtype 104 252385 54 -42584576] "VEENAR"] [cl-struct-plansys 115 42 2 7 12 58 40832 2931 [cl-struct-fastseedtype 120 599155 186 -76498432] "ERREENEN"] [cl-struct-plansys 114 242 2 6 10 49 31360 3698 [cl-struct-fastseedtype 48 317810 166 125019648] "BEEDRIAR"] [cl-struct-plansys 10 190 6 2 4 25 4800 3082 [cl-struct-fastseedtype 208 452618 250 -123602432] "LEMAED"] [cl-struct-plansys 37 24 0 3 10 44 24640 4901 [cl-struct-fastseedtype 88 875557 182 -5720576] "USBIRA"] [cl-struct-plansys 67 180 6 1 5 28 4480 6211 [cl-struct-fastseedtype 8 677699 90 -19047936] "ISRARA"] [cl-struct-plansys 166 244 4 4 7 37 14208 2982 [cl-struct-fastseedtype 224 750758 102 -93297152] "ERINGE"] [cl-struct-plansys 160 35 3 4 6 32 14336 6816 [cl-struct-fastseedtype 32 988064 218 -53487104] "ABEGE"] [cl-struct-plansys 102 3 3 1 7 33 9240 6246 [cl-struct-fastseedtype 200 620134 182 -150016] "ISSOINEN"] [cl-struct-plansys 50 204 4 3 7 36 12096 4402 [cl-struct-fastseedtype 24 978226 122 -93947392] "BICEISES"] [cl-struct-plansys 201 253 5 2 4 24 5760 5833 [cl-struct-fastseedtype 16 169161 166 -13916672] "MAENSO"] [cl-struct-plansys 4 231 7 6 3 26 6240 6404 [cl-struct-fastseedtype 240 32004 58 -86099456] "RIARDI"] [cl-struct-plansys 85 173 5 7 7 41 18040 6229 [cl-struct-fastseedtype 184 78933 54 -36882944] "DIERBEER"] [cl-struct-plansys 144 243 3 5 7 37 18648 3984 [cl-struct-fastseedtype 168 148880 26 -44819968] "RATITE"] [cl-struct-plansys 232 188 6 0 1 11 1408 6376 [cl-struct-fastseedtype 192 1015784 102 41772544] "ISXEES"] [cl-struct-plansys 41 137 3 0 5 24 5376 4137 [cl-struct-fastseedtype 64 462633 26 -69920256] "LASOCE"] [cl-struct-plansys 226 133 5 5 7 39 14040 6882 [cl-struct-fastseedtype 40 879586 54 -68209152] "ATIUS"] [cl-struct-plansys 110 40 0 7 13 60 52800 6510 [cl-struct-fastseedtype 184 421486 58 15612416] "RECEXELA"] [cl-struct-plansys 85 226 2 6 9 45 28800 6229 [cl-struct-fastseedtype 240 59733 166 29206016] "ISLAESIS"] [cl-struct-plansys 189 9 1 2 8 36 15552 6077 [cl-struct-fastseedtype 16 498365 122 62683648] "TEGETE"] [cl-struct-plansys 60 252 4 3 5 28 9408 5692 [cl-struct-fastseedtype 24 959292 182 45856256] "ANRAIN"] [cl-struct-plansys 156 236 6 1 2 16 2560 6044 [cl-struct-fastseedtype 72 520860 218 41736704] "TECERI"] [cl-struct-plansys 160 30 6 4 3 23 5888 4000 [cl-struct-fastseedtype 160 538528 102 -54237696] "ZAGEUSER"] [cl-struct-plansys 48 232 0 4 9 41 26240 5936 [cl-struct-fastseedtype 96 50224 90 -73639424] "TELALE"] [cl-struct-plansys 211 129 3 1 8 37 10360 5587 [cl-struct-fastseedtype 136 620243 182 34256384] "ARRIES"] [cl-struct-plansys 169 62 6 3 4 26 5824 4777 [cl-struct-fastseedtype 88 272297 250 -45614592] "SOALEED"] [cl-struct-plansys 152 33 1 2 7 32 13824 5272 [cl-struct-fastseedtype 208 903832 166 132752896] "ESGEBI"] [cl-struct-plansys 179 38 6 6 7 41 13120 6067 [cl-struct-fastseedtype 48 389555 186 -75712000] "TELACE"] [cl-struct-plansys 88 133 5 7 6 37 16280 3928 [cl-struct-fastseedtype 120 687960 54 53753344] "RAENONCE"] [cl-struct-plansys 229 159 7 5 4 29 6264 4837 [cl-struct-fastseedtype 232 981989 154 77044224] "TITEQU"] [cl-struct-plansys 78 154 2 0 7 31 7936 4174 [cl-struct-fastseedtype 128 999758 102 -33200640] "CEREXE"] [cl-struct-plansys 53 66 2 0 6 27 6912 4149 [cl-struct-fastseedtype 128 866613 154 73767424] "CEISED"] [cl-struct-plansys 186 120 0 5 12 54 38880 3002 [cl-struct-fastseedtype 232 833466 54 -82823680] "ERGERE"] [cl-struct-plansys 97 14 6 7 6 38 13376 3681 [cl-struct-fastseedtype 248 869473 186 -38553088] "BEZAORAT"] [cl-struct-plansys 17 57 1 6 10 48 34560 6673 [cl-struct-fastseedtype 176 966673 166 40871424] "AANTESO"] [cl-struct-plansys 103 60 4 2 7 35 10080 6503 [cl-struct-fastseedtype 80 85607 250 -94438912] "RIXEES"] [cl-struct-plansys 42 201 1 3 10 45 22680 4394 [cl-struct-fastseedtype 216 353066 182 -67717632] "VEARIN"] [cl-struct-plansys 237 12 6 1 3 20 3200 4077 [cl-struct-fastseedtype 136 35565 90 -102475264] "ZARIA"] [cl-struct-plansys 114 175 7 4 4 28 5376 2930 [cl-struct-fastseedtype 96 145010 102 50357760] "XELAED"] [cl-struct-plansys 184 149 5 4 4 26 8320 3000 [cl-struct-fastseedtype 160 28856 218 -26158592] "ERRIUS"] [cl-struct-plansys 24 232 2 1 6 28 8960 6680 [cl-struct-fastseedtype 72 29464 182 130004480] "ONEDED"] [cl-struct-plansys 24 152 0 3 9 40 22400 3096 [cl-struct-fastseedtype 152 613400 122 7436800] "ATXEIN"]] [[cl-struct-plansys 8 105 1 4 8 38 21888 6408 [cl-struct-fastseedtype 33 8 77 14568704] "RIAVE"] [cl-struct-plansys 99 54 6 5 7 40 11520 5219 [cl-struct-fastseedtype 233 1123 133 132744448] "ESGEER"] [cl-struct-plansys 61 208 0 3 10 44 24640 3389 [cl-struct-fastseedtype 217 12605 45 -91083520] "ENERZA"] [cl-struct-plansys 164 112 2 0 5 23 5888 4260 [cl-struct-fastseedtype 1 144292 213 -55192320] "LAARZACE"] [cl-struct-plansys 165 36 4 6 7 39 18720 4005 [cl-struct-fastseedtype 49 602789 141 -124482304] "RARIED"] [cl-struct-plansys 138 152 0 7 13 60 52800 3210 [cl-struct-fastseedtype 249 24714 101 -125737728] "LEZAER"] [cl-struct-plansys 214 176 0 5 12 54 38880 5846 [cl-struct-fastseedtype 169 284374 237 86764800] "MABELALA"] [cl-struct-plansys 149 181 5 2 4 24 5760 6549 [cl-struct-fastseedtype 81 708757 181 -67193600] "RIARRIBI"] [cl-struct-plansys 38 222 6 0 3 19 2432 6438 [cl-struct-fastseedtype 193 854310 205 105827584] "REBEES"] [cl-struct-plansys 107 201 3 1 8 37 10360 4971 [cl-struct-fastseedtype 137 642667 69 109593856] "USTEER"] [cl-struct-plansys 245 176 0 7 12 56 49280 3829 [cl-struct-fastseedtype 249 515317 173 56864000] "GEARZAEN"] [cl-struct-plansys 210 100 4 4 7 37 14208 3026 [cl-struct-fastseedtype 33 298962 149 -62876416] "VEES"] [cl-struct-plansys 64 137 1 2 7 32 13824 3136 [cl-struct-fastseedtype 209 216384 13 -29291264] "LEMADIOR"] [cl-struct-plansys 217 141 5 3 5 29 8120 3545 [cl-struct-fastseedtype 153 196057 37 -42851072] "ENEDZA"] [cl-struct-plansys 111 36 6 1 5 28 4480 6255 [cl-struct-fastseedtype 201 391791 109 124611840] "DILEON"] [cl-struct-plansys 78 223 7 6 5 34 8160 6734 [cl-struct-fastseedtype 113 263502 117 53441792] "AISQU"] [cl-struct-plansys 103 218 2 4 10 47 24064 6759 [cl-struct-fastseedtype 97 859239 77 94326016] "ONLEUSES"] [cl-struct-plansys 105 232 0 5 11 50 36000 3689 [cl-struct-fastseedtype 41 675177 5 87229696] "BEZAED"] [cl-struct-plansys 216 32 0 3 9 40 22400 6360 [cl-struct-fastseedtype 25 452312 45 -126014208] "ISLAMA"] [cl-struct-plansys 190 203 3 0 6 28 6272 6846 [cl-struct-fastseedtype 65 821950 85 -50375424] "ONUSBI"] [cl-struct-plansys 206 70 6 6 6 37 11840 6350 [cl-struct-fastseedtype 113 443854 141 -23229184] "ISENRIRE"] [cl-struct-plansys 110 30 6 7 7 42 14784 6510 [cl-struct-fastseedtype 57 7278 229 -96541440] "RIMAEDXE"] [cl-struct-plansys 130 120 0 5 12 54 38880 4482 [cl-struct-fastseedtype 233 1024130 237 113700096] "BIXEIN"] [cl-struct-plansys 149 12 4 2 5 27 7776 3989 [cl-struct-fastseedtype 145 211349 53 -60541696] "ZABION"] [cl-struct-plansys 106 255 7 0 2 16 1536 6762 [cl-struct-fastseedtype 1 112746 205 74435840] "AORBETE"] [cl-struct-plansys 252 179 3 1 5 25 7000 5372 [cl-struct-fastseedtype 201 175356 197 92914944] "ESORZA"] [cl-struct-plansys 132 192 0 7 11 52 45760 6532 [cl-struct-fastseedtype 57 606852 173 -8475392] "RIGEBI"] [cl-struct-plansys 8 198 6 4 3 23 5888 3336 [cl-struct-fastseedtype 97 324872 21 -91089664] "ENANRE"] [cl-struct-plansys 238 251 3 2 7 34 11424 5614 [cl-struct-fastseedtype 17 491758 13 122293504] "ARBEMA"] [cl-struct-plansys 232 107 3 3 6 31 12152 4840 [cl-struct-fastseedtype 217 300520 165 75998464] "SOANINER"] [cl-struct-plansys 176 76 6 1 2 16 2560 5040 [cl-struct-fastseedtype 9 846512 109 14183680] "EDRAISAR"] [cl-struct-plansys 10 93 5 6 7 40 16000 5898 [cl-struct-fastseedtype 177 820234 245 121435392] "TECEINRE"] [cl-struct-plansys 206 236 4 4 7 37 14208 3022 [cl-struct-fastseedtype 161 972750 77 -127906560] "ANAR"] [cl-struct-plansys 198 74 2 5 10 48 27648 6086 [cl-struct-fastseedtype 105 967878 133 19694848] "INISER"] [cl-struct-plansys 154 48 0 3 11 48 26880 5018 [cl-struct-fastseedtype 89 602010 45 -33018624] "USENLAER"] [cl-struct-plansys 80 117 7 0 0 8 768 4944 [cl-struct-fastseedtype 129 899920 213 -124201728] "EDRIUSON"] [cl-struct-plansys 63 72 0 6 13 59 47200 4415 [cl-struct-fastseedtype 177 245567 141 98995456] "BIRERA"] [cl-struct-plansys 233 148 4 7 8 44 23232 6121 [cl-struct-fastseedtype 121 462825 101 -101948160] "INAR"] [cl-struct-plansys 151 64 0 5 13 58 41760 3223 [cl-struct-fastseedtype 41 927383 237 54652160] "LEORENDI"] [cl-struct-plansys 77 242 2 2 7 33 12672 5197 [cl-struct-fastseedtype 209 177997 181 -78007040] "ORQULELA"] [cl-struct-plansys 53 65 3 0 5 24 5376 2869 [cl-struct-fastseedtype 65 766261 205 118541568] "ERSODI"] [cl-struct-plansys 102 205 7 1 3 21 2520 5734 [cl-struct-fastseedtype 9 809062 69 -105167616] "ANREER"] [cl-struct-plansys 186 16 0 7 13 60 52800 5306 [cl-struct-fastseedtype 121 326074 173 -105272064] "ORZAEDVE"] [cl-struct-plansys 54 248 0 4 11 49 31360 3638 [cl-struct-fastseedtype 161 9782 149 45323520] "BEXEIN"] [cl-struct-plansys 99 204 4 2 7 35 10080 3683 [cl-struct-fastseedtype 81 449891 13 -132969216] "BEGEORER"] [cl-struct-plansys 16 185 1 3 8 37 18648 6160 [cl-struct-fastseedtype 25 80912 37 861440] "DIVERA"] [cl-struct-plansys 216 244 6 1 2 16 2560 3800 [cl-struct-fastseedtype 73 3544 109 -73175808] "GEAMA"] [cl-struct-plansys 254 235 3 6 9 46 25760 5630 [cl-struct-fastseedtype 241 893438 117 -128289536] "QUCERI"] [cl-struct-plansys 61 158 6 4 4 27 6912 3133 [cl-struct-fastseedtype 225 489277 77 102845696] "LEISTEAN"] [cl-struct-plansys 123 92 4 5 9 46 19872 4475 [cl-struct-fastseedtype 169 415611 5 -120191744] "VEREZA"] [cl-struct-plansys 132 0 0 3 9 40 22400 3716 [cl-struct-fastseedtype 153 571524 45 -130863872] "BETIA"] [cl-struct-plansys 90 111 7 0 2 16 1536 3418 [cl-struct-fastseedtype 193 465498 85 -58567424] "XEINES"] [cl-struct-plansys 248 41 1 6 9 44 31680 6904 [cl-struct-fastseedtype 241 5112 141 -76575488] "AENQUTE"] [cl-struct-plansys 252 250 2 7 9 46 32384 5372 [cl-struct-fastseedtype 185 858108 229 76145920] "ESLEUSBE"] [cl-struct-plansys 19 8 0 5 13 58 41760 5907 [cl-struct-fastseedtype 105 493075 237 127724800] "TEEDUS"] [cl-struct-plansys 190 104 0 2 10 43 20640 6846 [cl-struct-fastseedtype 17 282302 53 98514176] "ONBIGE"] [cl-struct-plansys 136 163 3 0 4 20 4480 3208 [cl-struct-fastseedtype 129 137352 205 -80622336] "ATISTISO"] [cl-struct-plansys 167 23 7 1 4 25 3000 6055 [cl-struct-fastseedtype 73 269735 197 1885440] "TEANED"] [cl-struct-plansys 152 160 0 7 11 52 45760 3992 [cl-struct-fastseedtype 185 790424 173 -15422208] "RADIQU"] [cl-struct-plansys 92 250 2 4 7 35 17920 4188 [cl-struct-fastseedtype 225 743516 21 27596032] "CETERI"] [cl-struct-plansys 160 254 6 2 2 17 3264 6048 [cl-struct-fastseedtype 145 866208 13 -40104704] "TEANTI"] [cl-struct-plansys 79 119 7 3 5 31 5208 3407 [cl-struct-fastseedtype 89 404815 165 -50158336] "XEESANUS"] [cl-struct-plansys 232 27 3 1 5 25 7000 6632 [cl-struct-fastseedtype 137 90344 109 80637184] "REENESMA"] [cl-struct-plansys 43 137 1 6 12 56 40320 4651 [cl-struct-fastseedtype 49 738347 245 59241728] "SOISERLA"] [cl-struct-plansys 181 240 0 4 10 45 28800 3509 [cl-struct-fastseedtype 33 589749 77 -69055232] "XESOON"] [cl-struct-plansys 136 31 7 5 3 25 5400 6792 [cl-struct-fastseedtype 233 832136 133 -114326272] "ATIA"] [cl-struct-plansys 150 143 7 3 4 27 4536 6550 [cl-struct-fastseedtype 217 257686 45 66989312] "RIZAORIS"] [cl-struct-plansys 221 185 3 0 5 24 5376 5853 [cl-struct-fastseedtype 1 244957 213 96195840] "ANENMAQU"] [cl-struct-plansys 250 235 3 6 9 46 25760 5114 [cl-struct-fastseedtype 49 620794 141 -63402752] "EDRIAT"] [cl-struct-plansys 167 81 1 7 13 61 48312 4775 [cl-struct-fastseedtype 249 971175 101 118973696] "TIERA"] [cl-struct-plansys 247 207 7 5 6 37 7992 4855 [cl-struct-fastseedtype 169 400375 237 14150912] "TIONREBI"] [cl-struct-plansys 230 110 6 2 4 25 4800 4070 [cl-struct-fastseedtype 81 443622 181 -118180608] "RAARCEGE"] [cl-struct-plansys 99 37 7 0 3 20 1920 3427 [cl-struct-fastseedtype 193 512867 205 -36516608] "ENANEN"] [cl-struct-plansys 192 146 2 1 6 28 8960 6592 [cl-struct-fastseedtype 137 920000 69 95307008] "REA"] [cl-struct-plansys 30 111 7 7 6 39 10296 6686 [cl-struct-fastseedtype 249 545054 173 -57692928] "ARIDIAN"] [cl-struct-plansys 123 205 5 4 7 38 12160 4475 [cl-struct-fastseedtype 33 622715 149 73831680] "BIREER"] [cl-struct-plansys 165 144 0 2 9 39 18720 4261 [cl-struct-fastseedtype 209 9381 13 82119936] "CEANBIBI"] [cl-struct-plansys 166 166 6 3 5 30 6720 5030 [cl-struct-fastseedtype 153 616102 37 -127392512] "USRAGE"] [cl-struct-plansys 224 195 3 1 5 25 7000 5344 [cl-struct-fastseedtype 201 106720 109 -111579904] "ORISED"] [cl-struct-plansys 143 56 0 6 13 59 47200 4239 [cl-struct-fastseedtype 113 69519 117 96826624] "CEDILE"] [cl-struct-plansys 52 225 1 4 8 38 21888 3636 [cl-struct-fastseedtype 97 865844 77 111365376] "GEORATRE"] [cl-struct-plansys 238 145 1 5 11 51 33048 5358 [cl-struct-fastseedtype 41 541422 5 -13040384] "OREDONAT"] [cl-struct-plansys 209 223 7 3 3 23 3864 5329 [cl-struct-fastseedtype 25 917201 45 -26661632] "ESORRA"] [cl-struct-plansys 215 84 6 0 4 23 2944 4311 [cl-struct-fastseedtype 65 30679 85 21320960] "CEERDI"] [cl-struct-plansys 67 141 5 6 8 44 17600 3139 [cl-struct-fastseedtype 113 222019 141 88182016] "LEENTIMA"] [cl-struct-plansys 235 151 7 7 7 43 11352 4075 [cl-struct-fastseedtype 57 367083 229 -23796480] "RATITIGE"] [cl-struct-plansys 67 151 7 5 6 37 7992 3395 [cl-struct-fastseedtype 233 984387 237 -67965696] "ENRECE"] [cl-struct-plansys 198 5 5 2 5 28 6720 5574 [cl-struct-fastseedtype 145 302790 53 26883328] "QUBIBI"] [cl-struct-plansys 199 198 6 0 4 23 2944 3783 [cl-struct-fastseedtype 1 231111 205 -67908352] "BELETEAT"] [cl-struct-plansys 177 60 6 1 3 20 3200 6833 [cl-struct-fastseedtype 201 846257 197 124765440] "AISONDI"] [cl-struct-plansys 77 127 7 7 5 35 9240 5453 [cl-struct-fastseedtype 57 281421 173 -13980416] "ARTIA"] [cl-struct-plansys 145 111 7 4 3 24 4608 5009 [cl-struct-fastseedtype 97 218001 21 133698816] "EDEDXEBE"] [cl-struct-plansys 115 130 2 2 9 41 15744 6515 [cl-struct-fastseedtype 17 457075 13 -85062400] "REGEZA"] [cl-struct-plansys 21 68 4 3 6 32 10752 6165 [cl-struct-fastseedtype 217 107797 165 -12737280] "ISTIMALE"] [cl-struct-plansys 193 235 3 1 6 29 8120 4033 [cl-struct-fastseedtype 9 543425 109 105147648] "ZAERVEMA"] [cl-struct-plansys 43 246 6 6 7 41 13120 3371 [cl-struct-fastseedtype 177 682283 245 -65866496] "ENLABEAN"] [cl-struct-plansys 187 115 3 4 9 44 19712 4027 [cl-struct-fastseedtype 161 892859 77 56904960] "ZABEBE"] [cl-struct-plansys 171 179 3 5 10 49 24696 3499 [cl-struct-fastseedtype 105 144811 133 133334272] "ENATA"] [cl-struct-plansys 51 239 7 3 5 31 5208 3891 [cl-struct-fastseedtype 89 448051 45 74722560] "RAVERIES"] [cl-struct-plansys 73 62 6 0 2 15 1920 6473 [cl-struct-fastseedtype 129 254025 213 -65088256] "RIBIARA"] [cl-struct-plansys 212 15 7 6 3 26 6240 5588 [cl-struct-fastseedtype 177 985044 141 59411712] "ARREDI"] [cl-struct-plansys 198 205 5 7 8 45 19800 3526 [cl-struct-fastseedtype 121 1019334 101 -134060800] "XEVEON"] [cl-struct-plansys 248 95 7 5 3 25 5400 6392 [cl-struct-fastseedtype 41 663288 237 99478784] "DICEMARI"] [cl-struct-plansys 94 43 3 2 7 34 11424 6750 [cl-struct-fastseedtype 209 794974 181 -53496576] "AQUUSEN"] [cl-struct-plansys 178 136 2 0 7 31 7936 4018 [cl-struct-fastseedtype 65 497586 205 43306240] "RAAVE"] [cl-struct-plansys 123 22 6 1 5 28 4480 3195 [cl-struct-fastseedtype 9 674427 69 39929088] "LEENA"] [cl-struct-plansys 35 207 7 7 7 43 11352 4131 [cl-struct-fastseedtype 121 215843 173 65383680] "CEEDLEON"] [cl-struct-plansys 159 225 1 4 11 50 28800 5279 [cl-struct-fastseedtype 161 1001119 149 -111569664] "ORQUBE"] [cl-struct-plansys 8 211 3 2 5 26 8736 4616 [cl-struct-fastseedtype 81 183048 13 -55112448] "TIBEENIS"] [cl-struct-plansys 157 82 2 3 8 38 17024 3741 [cl-struct-fastseedtype 25 943517 37 -24959744] "GEENBE"] [cl-struct-plansys 137 147 3 1 6 29 8120 6793 [cl-struct-fastseedtype 73 760713 109 -124818176] "AMAZA"] [cl-struct-plansys 255 196 4 6 9 47 22560 3071 [cl-struct-fastseedtype 241 685567 117 57701632] "ERLACE"] [cl-struct-plansys 74 165 5 4 6 34 10880 4170 [cl-struct-fastseedtype 225 753994 77 -14332672] "CELACE"] [cl-struct-plansys 192 133 5 5 5 31 11160 6080 [cl-struct-fastseedtype 169 948160 5 6030592] "TEXEONIS"] [cl-struct-plansys 189 191 7 3 3 23 3864 6845 [cl-struct-fastseedtype 153 205245 45 52374784] "ONANED"] [cl-struct-plansys 51 120 2 0 8 35 8960 4915 [cl-struct-fastseedtype 193 412467 85 55072000] "USRAER"] [cl-struct-plansys 173 112 0 6 11 51 40800 3757 [cl-struct-fastseedtype 241 220077 141 68390144] "BEENBEOR"] [cl-struct-plansys 57 243 3 7 9 47 28952 6713 [cl-struct-fastseedtype 185 494137 229 6284544] "ONDISORA"] [cl-struct-plansys 20 39 7 5 3 25 5400 4884 [cl-struct-fastseedtype 105 656916 237 -70718208] "USZALE"] [cl-struct-plansys 175 225 1 2 10 44 19008 4271 [cl-struct-fastseedtype 17 479663 53 127218944] "LABIAR"] [cl-struct-plansys 37 106 2 0 6 27 6912 4133 [cl-struct-fastseedtype 129 666405 205 -21639936] "LACETE"] [cl-struct-plansys 28 32 2 1 6 28 8960 3356 [cl-struct-fastseedtype 73 948508 197 58901760] "XEONONLE"] [cl-struct-plansys 161 95 7 7 5 35 9240 2977 [cl-struct-fastseedtype 185 613793 173 130067712] "LEGE"] [cl-struct-plansys 165 35 3 4 7 36 16128 5797 [cl-struct-fastseedtype 225 626341 21 93000960] "MARACECE"] [cl-struct-plansys 101 133 5 2 4 24 5760 2917 [cl-struct-fastseedtype 145 421477 13 121638144] "MAER"] [cl-struct-plansys 60 208 0 3 9 40 22400 4924 [cl-struct-fastseedtype 89 1041724 165 54043904] "EDCEQUOR"] [cl-struct-plansys 57 186 2 1 7 32 10240 5433 [cl-struct-fastseedtype 137 561209 109 -46502656] "QUREXEIN"] [cl-struct-plansys 12 162 2 6 8 41 26240 6156 [cl-struct-fastseedtype 49 269068 245 -119671552] "ISDITIXE"] [cl-struct-plansys 226 119 7 4 4 28 5376 4578 [cl-struct-fastseedtype 33 516066 77 115756288] "BIONUS"] [cl-struct-plansys 45 8 0 5 11 50 36000 4141 [cl-struct-fastseedtype 233 243245 133 91587840] "LAMARE"] [cl-struct-plansys 111 78 6 3 6 34 7616 5487 [cl-struct-fastseedtype 217 282223 45 124398848] "ARUSXEVE"] [cl-struct-plansys 150 2 2 0 7 31 7936 3222 [cl-struct-fastseedtype 1 642454 213 63034624] "LEQUENA"] [cl-struct-plansys 207 178 2 6 11 53 33920 6095 [cl-struct-fastseedtype 49 332751 141 64785664] "TERIAR"] [cl-struct-plansys 68 10 2 7 9 46 32384 6212 [cl-struct-fastseedtype 249 863300 101 78472448] "DITERE"] [cl-struct-plansys 152 238 6 5 4 28 8064 3736 [cl-struct-fastseedtype 169 268184 237 -92017408] "GEMASOTI"] [cl-struct-plansys 183 39 7 2 4 26 3744 5559 [cl-struct-fastseedtype 81 259255 181 -18172672] "ARARIN"] [cl-struct-plansys 32 108 6 0 1 11 1408 4384 [cl-struct-fastseedtype 193 861728 205 -44643072] "VEGEAN"] [cl-struct-plansys 149 91 3 1 6 29 8120 3989 [cl-struct-fastseedtype 137 557717 69 131351808] "RAZARE"] [cl-struct-plansys 199 46 6 7 8 46 16192 5831 [cl-struct-fastseedtype 249 217031 173 129740032] "ANENVEZA"] [cl-struct-plansys 164 54 6 4 3 23 5888 6052 [cl-struct-fastseedtype 33 794788 149 -108227328] "INBITI"] [cl-struct-plansys 138 151 7 2 3 22 3168 5258 [cl-struct-fastseedtype 209 948362 13 126422272] "ESMAONBE"] [cl-struct-plansys 243 191 7 3 5 31 5208 6643 [cl-struct-fastseedtype 153 991475 37 -94493440] "RIERXE"] [cl-struct-plansys 209 98 2 1 7 32 10240 4305 [cl-struct-fastseedtype 201 714193 109 21327104] "CEORAT"] [cl-struct-plansys 80 145 1 6 9 44 31680 5712 [cl-struct-fastseedtype 113 130384 117 -111446784] "ANISUS"] [cl-struct-plansys 129 232 0 4 10 45 28800 4737 [cl-struct-fastseedtype 97 753793 77 128404736] "SOATQUBE"] [cl-struct-plansys 243 58 2 5 11 52 29952 6899 [cl-struct-fastseedtype 41 220659 5 71238912] "ONINRIAR"] [cl-struct-plansys 74 158 6 3 5 30 6720 4170 [cl-struct-fastseedtype 25 35146 45 -27972352] "LAISIS"] [cl-struct-plansys 112 221 7 0 0 8 768 5744 [cl-struct-fastseedtype 65 146544 85 -91532032] "MAEDRA"] [cl-struct-plansys 56 212 4 6 6 35 16800 4152 [cl-struct-fastseedtype 113 959800 141 -1733376] "CEENERUS"] [cl-struct-plansys 232 16 0 7 11 52 45760 5608 [cl-struct-fastseedtype 57 839912 229 32171264] "ARGEVEZA"] [cl-struct-plansys 132 182 6 5 4 28 8064 6532 [cl-struct-fastseedtype 233 553092 237 -14750464] "RIQURI"] [cl-struct-plansys 119 254 6 2 5 29 5568 2935 [cl-struct-fastseedtype 145 757623 53 -3132160] "ERBIDI"] [cl-struct-plansys 164 141 7 0 0 8 768 4772 [cl-struct-fastseedtype 1 404900 205 -76034816] "TIESCEBI"] [cl-struct-plansys 230 197 7 1 3 21 2520 4326 [cl-struct-fastseedtype 201 406502 197 -61487872] "LALERIVE"] [cl-struct-plansys 150 62 6 7 7 42 14784 4502 [cl-struct-fastseedtype 57 962198 173 14068992] "VEMAED"] [cl-struct-plansys 154 24 0 4 11 49 31360 6554 [cl-struct-fastseedtype 97 438682 21 39720192] "RIERESED"] [cl-struct-plansys 120 9 1 2 7 32 13824 3448 [cl-struct-fastseedtype 17 605816 13 -91091712] "ENBEIS"] [cl-struct-plansys 194 29 5 3 6 33 9240 3778 [cl-struct-fastseedtype 217 382402 165 15967488] "BEBEAREN"] [cl-struct-plansys 82 138 2 1 8 36 11520 2898 [cl-struct-fastseedtype 9 334162 109 28339456] "ERINAIN"] [cl-struct-plansys 204 143 7 6 3 26 6240 5068 [cl-struct-fastseedtype 177 950732 245 32044288] "USCEQUUS"] [cl-struct-plansys 40 250 2 4 7 35 17920 4904 [cl-struct-fastseedtype 161 976936 77 -26718976] "USMATE"] [cl-struct-plansys 16 28 4 5 6 34 14688 4880 [cl-struct-fastseedtype 105 105488 133 -105347840] "EDCERE"] [cl-struct-plansys 76 174 6 3 3 22 4928 2892 [cl-struct-fastseedtype 89 704332 45 81800448] "QUSOXE"] [cl-struct-plansys 194 7 7 0 2 16 1536 4034 [cl-struct-fastseedtype 129 863426 213 77911296] "ZAREVEES"] [cl-struct-plansys 233 214 6 6 5 33 10560 6633 [cl-struct-fastseedtype 177 541929 141 86936832] "REREBI"] [cl-struct-plansys 35 6 6 7 8 46 16192 4899 [cl-struct-fastseedtype 121 496931 101 85484800] "EDXERI"] [cl-struct-plansys 217 126 6 5 5 32 9216 5337 [cl-struct-fastseedtype 41 650713 237 110750976] "ORATZAA"] [cl-struct-plansys 239 100 4 2 7 35 10080 4335 [cl-struct-fastseedtype 209 747247 181 122008832] "CEQUAA"] [cl-struct-plansys 175 207 7 0 3 20 1920 5039 [cl-struct-fastseedtype 65 435887 205 102288640] "EDTION"] [cl-struct-plansys 16 95 7 1 1 13 1560 4624 [cl-struct-fastseedtype 9 793104 69 -33078016] "SOVERE"] [cl-struct-plansys 12 142 6 7 5 34 11968 3084 [cl-struct-fastseedtype 121 116492 173 1158400] "ATINARUS"] [cl-struct-plansys 136 202 2 4 7 35 17920 6792 [cl-struct-fastseedtype 161 439944 149 -50359040] "ONENQU"] [cl-struct-plansys 45 218 2 2 7 33 12672 5677 [cl-struct-fastseedtype 81 972077 13 -44364544] "ANGEMAAR"] [cl-struct-plansys 170 235 3 3 8 39 15288 5290 [cl-struct-fastseedtype 25 426154 37 66659584] "ORREEN"] [cl-struct-plansys 186 50 2 1 8 36 11520 5818 [cl-struct-fastseedtype 73 550842 109 -75797248] "ANSOIS"] [cl-struct-plansys 128 157 5 6 5 32 12800 4480 [cl-struct-fastseedtype 241 773504 117 -7965440] "BICEIN"] [cl-struct-plansys 215 172 4 4 8 41 15744 5335 [cl-struct-fastseedtype 225 154583 77 -131511040] "ESDIRECE"] [cl-struct-plansys 133 174 6 5 5 32 9216 3461 [cl-struct-fastseedtype 169 875909 5 48366848] "XEVERIVE"] [cl-struct-plansys 118 126 6 3 5 30 6720 5750 [cl-struct-fastseedtype 153 695670 45 -133485312] "MAONLE"] [cl-struct-plansys 140 129 3 0 4 20 4480 6540 [cl-struct-fastseedtype 193 652172 85 -15837952] "RETETI"] [cl-struct-plansys 226 183 7 6 5 34 8160 4834 [cl-struct-fastseedtype 241 1042402 141 12029184] "TIENINVE"] [cl-struct-plansys 246 236 4 7 9 48 25344 4342 [cl-struct-fastseedtype 185 742902 229 -80354048] "LAORBILA"] [cl-struct-plansys 149 70 6 5 5 32 9216 3989 [cl-struct-fastseedtype 105 404629 237 -34280192] "RAERQU"] [cl-struct-plansys 32 90 2 2 6 29 11136 5664 [cl-struct-fastseedtype 17 819232 53 38483200] "MABIAT"] [cl-struct-plansys 66 49 3 0 6 28 6272 5186 [cl-struct-fastseedtype 129 243266 205 -96875264] "ORDIESAT"] [cl-struct-plansys 17 41 3 1 6 29 8120 4881 [cl-struct-fastseedtype 73 885265 197 -102185728] "USGERIAR"] [cl-struct-plansys 42 30 6 7 7 42 14784 5930 [cl-struct-fastseedtype 185 239146 173 40676608] "INLAIN"] [cl-struct-plansys 110 76 4 4 7 37 14208 3182 [cl-struct-fastseedtype 225 1008750 21 108074240] "ATININAR"] [cl-struct-plansys 170 12 4 2 6 31 8928 4010 [cl-struct-fastseedtype 145 594346 13 -52163328] "ZAANES"] [cl-struct-plansys 169 41 1 3 9 41 20664 6569 [cl-struct-fastseedtype 89 286377 165 7251200] "RELEORAR"] [cl-struct-plansys 10 89 3 1 7 33 9240 4362 [cl-struct-fastseedtype 137 839178 109 -72979200] "BIARANDI"] [cl-struct-plansys 109 187 3 6 8 42 23520 3693 [cl-struct-fastseedtype 49 771437 245 -13372160] "BEISRIA"] [cl-struct-plansys 143 254 6 4 6 35 8960 5519 [cl-struct-fastseedtype 33 385167 77 32132352] "ARTIAT"] [cl-struct-plansys 82 241 1 5 11 51 33048 5714 [cl-struct-fastseedtype 233 544594 133 -54819584] "ANONDI"] [cl-struct-plansys 200 13 5 3 4 25 7000 4552 [cl-struct-fastseedtype 217 299208 45 81145088] "VEINMAA"] [cl-struct-plansys 207 75 3 0 7 32 7168 4815 [cl-struct-fastseedtype 1 107983 213 113759488] "SOXEORZA"] [cl-struct-plansys 36 121 1 6 9 44 31680 2852 [cl-struct-fastseedtype 49 82724 141 -8352512] "RIGE"] [cl-struct-plansys 97 195 3 7 9 47 28952 3681 [cl-struct-fastseedtype 249 700513 101 21193984] "GEUSDI"] [cl-struct-plansys 185 13 5 5 6 35 12600 6841 [cl-struct-fastseedtype 169 887225 237 36695296] "ATIUS"] [cl-struct-plansys 8 224 0 2 8 35 16800 2824 [cl-struct-fastseedtype 81 761864 181 -35605248] "ARBEIS"] [cl-struct-plansys 93 179 3 0 5 24 5376 5469 [cl-struct-fastseedtype 193 934237 205 81448192] "QUMAZA"] [cl-struct-plansys 234 36 6 1 4 24 3840 5610 [cl-struct-fastseedtype 137 293098 69 -50707200] "QUUSDI"] [cl-struct-plansys 240 237 5 7 6 37 16280 4848 [cl-struct-fastseedtype 249 268528 173 82291968] "SOBIONDI"] [cl-struct-plansys 77 159 7 4 3 24 4608 3405 [cl-struct-fastseedtype 33 110669 149 -72182528] "ENRIRI"] [cl-struct-plansys 239 158 6 2 5 29 5568 6383 [cl-struct-fastseedtype 209 755951 13 103615744] "DIANED"] [cl-struct-plansys 192 216 0 3 9 40 22400 4032 [cl-struct-fastseedtype 153 748736 37 55846144] "RAINLE"] [cl-struct-plansys 66 1 3 1 7 33 9240 3138 [cl-struct-fastseedtype 201 592194 109 -13538048] "ATLAAR"] [cl-struct-plansys 145 234 2 6 9 45 28800 3217 [cl-struct-fastseedtype 113 528017 117 -34507520] "ATDIA"] [cl-struct-plansys 78 239 7 4 4 28 5376 5710 [cl-struct-fastseedtype 97 80718 77 -122991360] "MAESGEED"] [cl-struct-plansys 120 227 3 5 7 37 18648 4216 [cl-struct-fastseedtype 41 974456 5 71632128] "CEISGE"] [cl-struct-plansys 67 93 5 3 7 37 10360 3139 [cl-struct-fastseedtype 25 116291 45 -129946368] "LELEBI"] [cl-struct-plansys 137 102 6 0 2 15 1920 3209 [cl-struct-fastseedtype 65 989321 85 -120498944] "ATAN"] [cl-struct-plansys 173 27 3 6 8 42 23520 5293 [cl-struct-fastseedtype 113 904109 141 -24539904] "ESENESCE"] [cl-struct-plansys 101 137 1 7 11 53 41976 2917 [cl-struct-fastseedtype 57 328037 229 71361792] "ALACE"] [cl-struct-plansys 69 213 5 5 6 35 12600 5445 [cl-struct-fastseedtype 233 729669 237 4910336] "ARBITI"] [cl-struct-plansys 168 247 7 2 1 14 2016 4520 [cl-struct-fastseedtype 145 84904 53 117847296] "BIBIRA"] [cl-struct-plansys 1 84 6 0 2 15 1920 5633 [cl-struct-fastseedtype 1 716033 205 50056448] "ANATREAN"] [cl-struct-plansys 155 78 6 1 5 28 4480 5787 [cl-struct-fastseedtype 201 641947 197 71025920] "ANCEISON"] [cl-struct-plansys 95 253 5 7 9 49 21560 3423 [cl-struct-fastseedtype 57 240735 173 75672832] "XEONLE"] [cl-struct-plansys 35 193 1 4 11 50 28800 3875 [cl-struct-fastseedtype 97 282403 21 -104590080] "ZAUSERIS"] [cl-struct-plansys 253 144 0 2 9 39 18720 4605 [cl-struct-fastseedtype 17 757757 13 104205568] "VEGEVE"] [cl-struct-plansys 239 246 6 3 6 34 7616 5359 [cl-struct-fastseedtype 217 550895 165 -106322688] "ESAESGE"] [cl-struct-plansys 99 41 3 1 8 37 10360 5987 [cl-struct-fastseedtype 9 693859 109 52194560] "TEUSUSDI"] [cl-struct-plansys 237 40 0 6 11 51 40800 6637 [cl-struct-fastseedtype 177 658925 245 -121703168] "RILALELA"] [cl-struct-plansys 21 129 1 4 9 42 24192 5909 [cl-struct-fastseedtype 161 782613 77 -110342912] "INGECE"] [cl-struct-plansys 245 133 5 5 6 35 12600 6645 [cl-struct-fastseedtype 105 14325 133 108954880] "RIORDI"] [cl-struct-plansys 229 109 5 3 5 29 8120 6117 [cl-struct-fastseedtype 89 535269 45 -11784960] "INRIERAN"] [cl-struct-plansys 187 208 2 0 8 35 8960 5563 [cl-struct-fastseedtype 129 450747 213 36361472] "ARVEISRI"] [cl-struct-plansys 126 157 5 6 7 40 16000 3454 [cl-struct-fastseedtype 177 308862 141 -86864640] "ENREON"] [cl-struct-plansys 0 63 7 7 4 31 8184 6400 [cl-struct-fastseedtype 121 943616 101 19817728] "REREIS"] [cl-struct-plansys 58 157 5 5 7 39 14040 4154 [cl-struct-fastseedtype 41 840506 237 88468736] "CEISIS"] [cl-struct-plansys 0 157 5 2 3 20 4800 5632 [cl-struct-fastseedtype 209 641024 181 -88361728] "ANQUVEIN"] [cl-struct-plansys 44 22 6 0 1 11 1408 5932 [cl-struct-fastseedtype 65 663084 205 27053312] "TEONUS"] [cl-struct-plansys 37 168 2 1 7 32 10240 6181 [cl-struct-fastseedtype 9 853797 69 -55753472] "DIQUDI"] [cl-struct-plansys 117 77 5 7 7 41 18040 6261 [cl-struct-fastseedtype 121 765301 173 -29512448] "ISBEAT"] [cl-struct-plansys 241 179 3 4 7 36 16128 4337 [cl-struct-fastseedtype 161 767473 149 -39480064] "CEARLE"] [cl-struct-plansys 210 225 1 2 9 40 17280 6866 [cl-struct-fastseedtype 81 539602 13 -100725504] "ONBEZATI"] [cl-struct-plansys 55 132 4 3 8 40 13440 6711 [cl-struct-fastseedtype 25 52535 37 7283968] "AARAT"] [cl-struct-plansys 107 209 3 1 8 37 10360 4715 [cl-struct-fastseedtype 73 897643 109 73886976] "SOGEVE"] [cl-struct-plansys 129 118 6 6 5 33 10560 6017 [cl-struct-fastseedtype 241 190593 117 -56855296] "TELABE"] [cl-struct-plansys 228 179 3 4 6 32 14336 6372 [cl-struct-fastseedtype 225 345828 77 19746048] "DICETIAR"] [cl-struct-plansys 202 215 7 5 5 33 7128 5066 [cl-struct-fastseedtype 169 411850 5 6817024] "USARISA"] [cl-struct-plansys 175 61 5 3 7 37 10360 4783 [cl-struct-fastseedtype 153 158639 45 116862208] "TIGEAR"] [cl-struct-plansys 101 138 2 0 6 27 6912 3941 [cl-struct-fastseedtype 193 1004389 85 -2861824] "RAZARI"] [cl-struct-plansys 151 254 6 6 7 41 13120 5783 [cl-struct-fastseedtype 241 718999 141 22777088] "ANENCEBE"] [cl-struct-plansys 51 229 5 7 9 49 21560 5683 [cl-struct-fastseedtype 185 506675 229 84665600] "MACECEVE"] [cl-struct-plansys 150 101 5 5 7 39 14040 2966 [cl-struct-fastseedtype 105 735638 237 -31396608] "TEBE"] [cl-struct-plansys 17 211 3 2 6 30 10080 3089 [cl-struct-fastseedtype 17 858641 53 100742400] "LEBIED"] [cl-struct-plansys 223 248 2 0 8 35 8960 6367 [cl-struct-fastseedtype 129 1047007 205 -37892864] "ISLAENBI"] [cl-struct-plansys 134 50 2 1 8 36 11520 6534 [cl-struct-fastseedtype 73 817286 197 55493888] "RESOISBE"] [cl-struct-plansys 51 221 5 7 9 49 21560 4915 [cl-struct-fastseedtype 185 403763 173 -15160064] "EDESLA"] [cl-struct-plansys 183 117 5 4 7 38 12160 4791 [cl-struct-fastseedtype 225 137655 21 72815872] "TIZABEA"] [cl-struct-plansys 111 147 3 2 8 38 12768 4975 [cl-struct-fastseedtype 145 156015 13 -24638208] "USMAXE"] [cl-struct-plansys 150 130 2 3 9 42 18816 3990 [cl-struct-fastseedtype 89 711062 165 77899008] "ZAISEDAN"] [cl-struct-plansys 91 248 2 1 9 40 12800 3419 [cl-struct-fastseedtype 137 350811 109 1207552] "ENBIRARE"] [cl-struct-plansys 78 212 4 6 8 43 20640 5198 [cl-struct-fastseedtype 49 230222 245 109704448] "ESDICETE"]] [[cl-struct-plansys 16 210 2 0 5 23 5888 6160 [cl-struct-fastseedtype 66 16 154 12425728] "ISREMA"] [cl-struct-plansys 203 110 6 2 5 29 5568 5579 [cl-struct-fastseedtype 210 1227 10 -119928320] "QUBEOR"] [cl-struct-plansys 167 185 1 6 12 56 40320 4263 [cl-struct-fastseedtype 178 13991 90 74799616] "LAVEBE"] [cl-struct-plansys 64 243 3 0 4 20 4480 5440 [cl-struct-fastseedtype 2 160064 170 -32855552] "ARRIESEN"] [cl-struct-plansys 210 137 1 4 10 46 26496 5586 [cl-struct-fastseedtype 98 783314 26 -107341312] "QULAXE"] [cl-struct-plansys 241 98 2 6 9 45 28800 5361 [cl-struct-fastseedtype 242 1042161 202 71944704] "ESISOR"] [cl-struct-plansys 193 217 1 2 8 36 15552 5057 [cl-struct-fastseedtype 82 860353 218 -46605824] "EDBEDI"] [cl-struct-plansys 218 205 5 4 6 34 10880 6106 [cl-struct-fastseedtype 162 777946 106 8153600] "TECETEIS"] [cl-struct-plansys 29 124 6 0 2 15 1920 6429 [cl-struct-fastseedtype 130 269853 154 -71394816] "RIEDRA"] [cl-struct-plansys 75 52 4 2 7 35 10080 4683 [cl-struct-fastseedtype 18 378443 138 14125568] "TIVEORSO"] [cl-struct-plansys 167 121 1 6 12 56 40320 5031 [cl-struct-fastseedtype 242 1047207 90 74996224] "EDORQU"] [cl-struct-plansys 204 186 2 0 5 23 5888 3020 [cl-struct-fastseedtype 66 49868 42 18885120] "BIEN"] [cl-struct-plansys 89 146 2 4 8 39 19968 3673 [cl-struct-fastseedtype 162 920153 26 59972096] "BEONINON"] [cl-struct-plansys 127 108 4 6 9 47 22560 5759 [cl-struct-fastseedtype 50 932479 74 23808512] "MAVELEGE"] [cl-struct-plansys 3 65 1 2 10 44 19008 5635 [cl-struct-fastseedtype 146 227843 218 43768320] "ANTE"] [cl-struct-plansys 252 128 0 4 9 41 26240 6396 [cl-struct-fastseedtype 226 748796 234 123595264] "ISANLA"] [cl-struct-plansys 110 53 7 0 2 16 1536 6766 [cl-struct-fastseedtype 194 871278 154 -8414720] "ONZAENVE"] [cl-struct-plansys 182 18 2 2 8 37 14208 6326 [cl-struct-fastseedtype 82 972982 10 32311808] "DILAOR"] [cl-struct-plansys 252 89 1 6 9 44 31680 5884 [cl-struct-fastseedtype 50 79356 90 -99919360] "MAUSRA"] [cl-struct-plansys 212 104 2 0 5 23 5888 6356 [cl-struct-fastseedtype 130 317652 170 127773184] "ISQUINZA"] [cl-struct-plansys 196 76 4 4 5 29 11136 6084 [cl-struct-fastseedtype 226 669636 26 132913664] "INISRE"] [cl-struct-plansys 152 174 6 6 4 29 9280 3992 [cl-struct-fastseedtype 114 645016 202 121948672] "ZAMAES"] [cl-struct-plansys 57 105 1 2 8 36 15552 6457 [cl-struct-fastseedtype 210 275257 218 -13706752] "REATQU"] [cl-struct-plansys 59 58 2 4 10 47 24064 4667 [cl-struct-fastseedtype 34 631099 106 55011840] "SOISONZA"] [cl-struct-plansys 68 63 7 0 0 8 768 2884 [cl-struct-fastseedtype 2 574788 154 121674240] "ZAUS"] [cl-struct-plansys 77 72 0 2 9 39 18720 5453 [cl-struct-fastseedtype 146 316237 138 -10843648] "QUERORZA"] [cl-struct-plansys 228 153 1 6 9 44 31680 6628 [cl-struct-fastseedtype 114 692196 90 7232000] "REMARI"] [cl-struct-plansys 152 62 6 0 1 11 1408 3736 [cl-struct-fastseedtype 194 332952 42 -121427456] "GEQUVE"] [cl-struct-plansys 84 246 6 4 3 23 5888 4180 [cl-struct-fastseedtype 34 99668 26 31791616] "CEAUSIS"] [cl-struct-plansys 125 104 0 6 11 51 40800 4477 [cl-struct-fastseedtype 178 307581 74 18237952] "VETEERZA"] [cl-struct-plansys 164 144 0 2 8 35 16800 3236 [cl-struct-fastseedtype 18 20388 218 -30287360] "ATBITELA"] [cl-struct-plansys 213 60 4 4 6 33 12672 5077 [cl-struct-fastseedtype 98 813269 234 58255872] "EDMAOR"] [cl-struct-plansys 221 217 3 0 5 24 5376 3293 [cl-struct-fastseedtype 66 966877 154 -29255168] "LEEDTIER"] [cl-struct-plansys 80 23 7 2 1 14 2016 2896 [cl-struct-fastseedtype 210 42320 10 -60814848] "SOED"] [cl-struct-plansys 160 120 0 6 10 47 37600 3232 [cl-struct-fastseedtype 178 870304 90 48323072] "LEQUTEOR"] [cl-struct-plansys 89 124 6 0 2 15 1920 2905 [cl-struct-fastseedtype 2 266073 170 -70211072] "ERBIERSO"] [cl-struct-plansys 71 208 0 4 12 53 33920 6471 [cl-struct-fastseedtype 98 1029191 26 -54650368] "RILAAN"] [cl-struct-plansys 110 219 3 6 9 46 25760 6766 [cl-struct-fastseedtype 242 938862 202 -98579968] "ONESED"] [cl-struct-plansys 130 248 0 2 10 43 20640 3970 [cl-struct-fastseedtype 82 10882 218 -85665280] "ZAONBI"] [cl-struct-plansys 11 198 6 4 6 35 8960 3339 [cl-struct-fastseedtype 162 600331 106 120744448] "ENCEGEQU"] [cl-struct-plansys 122 67 3 0 6 28 6272 3450 [cl-struct-fastseedtype 130 256890 154 -4023808] "XEIS"] [cl-struct-plansys 0 189 5 2 3 20 4800 6144 [cl-struct-fastseedtype 18 595456 138 -63075840] "ISQUEDER"] [cl-struct-plansys 112 56 0 6 10 47 37600 3952 [cl-struct-fastseedtype 242 46192 90 -56337920] "ZADIGE"] [cl-struct-plansys 85 99 3 0 5 24 5376 4437 [cl-struct-fastseedtype 66 596565 42 -133813760] "BIRIOR"] [cl-struct-plansys 222 25 1 4 10 46 26496 4830 [cl-struct-fastseedtype 162 48606 26 62331392] "TIACEIN"] [cl-struct-plansys 172 69 5 6 5 32 12800 3244 [cl-struct-fastseedtype 50 417964 74 -39761408] "LEENRA"] [cl-struct-plansys 20 224 0 2 8 35 16800 4628 [cl-struct-fastseedtype 146 194324 218 8903168] "SOTEORIS"] [cl-struct-plansys 29 25 1 4 9 42 24192 3613 [cl-struct-fastseedtype 226 81693 234 -38540800] "BEMATE"] [cl-struct-plansys 91 188 6 0 4 23 2944 3675 [cl-struct-fastseedtype 194 191067 154 117676544] "GETEANAN"] [cl-struct-plansys 155 123 3 2 8 38 12768 3739 [cl-struct-fastseedtype 82 607387 10 36899328] "BEESED"] [cl-struct-plansys 149 24 0 6 11 51 40800 4757 [cl-struct-fastseedtype 50 378261 90 -118007296] "TIZAATDI"] [cl-struct-plansys 205 49 3 0 5 24 5376 3789 [cl-struct-fastseedtype 130 48845 170 77834752] "GEXEBEOR"] [cl-struct-plansys 89 19 3 4 7 36 16128 2905 [cl-struct-fastseedtype 226 938841 26 34609664] "ERISSO"] [cl-struct-plansys 117 231 7 6 4 30 7200 5493 [cl-struct-fastseedtype 114 463989 202 115001856] "QUTIUS"] [cl-struct-plansys 154 136 0 2 10 43 20640 5530 [cl-struct-fastseedtype 210 409754 218 -94709248] "QUISBE"] [cl-struct-plansys 76 115 3 4 6 32 14336 6220 [cl-struct-fastseedtype 34 426060 106 104688128] "ISISBILE"] [cl-struct-plansys 193 134 6 0 2 15 1920 4033 [cl-struct-fastseedtype 2 907969 154 -12281344] "ZAINAT"] [cl-struct-plansys 98 145 1 2 9 40 17280 2914 [cl-struct-fastseedtype 146 993378 138 25201152] "RAEDDI"] [cl-struct-plansys 77 88 0 6 11 51 40800 5453 [cl-struct-fastseedtype 114 164429 90 52058624] "QUONSO"] [cl-struct-plansys 1 39 7 0 1 12 1152 5121 [cl-struct-fastseedtype 194 343553 42 -118937088] "ESENIS"] [cl-struct-plansys 249 253 5 4 5 30 9600 5369 [cl-struct-fastseedtype 34 351737 26 50928128] "ESONLEAR"] [cl-struct-plansys 10 1 1 6 11 52 37440 5898 [cl-struct-fastseedtype 178 508426 74 17582592] "INEDALA"] [cl-struct-plansys 85 47 7 2 2 18 2592 6229 [cl-struct-fastseedtype 18 354901 218 60676608] "ISXELAVE"] [cl-struct-plansys 214 21 5 4 6 34 10880 6614 [cl-struct-fastseedtype 98 506326 234 977408] "REAN"] [cl-struct-plansys 234 224 2 0 7 31 7936 4330 [cl-struct-fastseedtype 66 512490 154 63281664] "CEERLA"] [cl-struct-plansys 149 64 0 2 9 39 18720 4501 [cl-struct-fastseedtype 210 135317 10 -43644416] "BIANTI"] [cl-struct-plansys 217 55 7 6 4 30 7200 6361 [cl-struct-fastseedtype 178 362969 90 105732608] "DIRICEEN"] [cl-struct-plansys 50 133 7 0 2 16 1536 4402 [cl-struct-fastseedtype 2 987442 170 -65623552] "VERETITE"] [cl-struct-plansys 252 23 7 4 2 20 3840 3580 [cl-struct-fastseedtype 98 229116 26 31595008] "XELARA"] [cl-struct-plansys 171 212 4 6 9 47 22560 4267 [cl-struct-fastseedtype 242 480427 202 125159936] "LALATI"] [cl-struct-plansys 131 23 7 2 4 26 3744 2947 [cl-struct-fastseedtype 82 77699 218 126933504] "ERMAON"] [cl-struct-plansys 252 63 7 4 2 20 3840 5116 [cl-struct-fastseedtype 162 340220 106 -93820416] "USCEARTI"] [cl-struct-plansys 23 10 2 0 8 35 8960 4375 [cl-struct-fastseedtype 130 417047 154 -3761664] "BIUSBI"] [cl-struct-plansys 117 198 6 2 3 21 4032 3701 [cl-struct-fastseedtype 18 74869 138 -115111424] "GERITIOR"] [cl-struct-plansys 121 247 7 6 4 30 7200 2937 [cl-struct-fastseedtype 242 103289 90 -36677120] "ERLEIN"] [cl-struct-plansys 158 140 6 0 3 19 2432 6046 [cl-struct-fastseedtype 66 879006 42 90974720] "INVE"] [cl-struct-plansys 163 160 0 4 12 53 33920 5795 [cl-struct-fastseedtype 162 823203 26 -103081472] "ANONRIOR"] [cl-struct-plansys 153 158 6 6 5 33 10560 4761 [cl-struct-fastseedtype 50 970649 74 89606656] "TIREONCE"] [cl-struct-plansys 101 127 7 2 2 18 2592 3685 [cl-struct-fastseedtype 146 992101 218 24369664] "BEEDENRI"] [cl-struct-plansys 254 50 2 4 9 43 22016 5374 [cl-struct-fastseedtype 226 860926 234 76147200] "ESANGE"] [cl-struct-plansys 136 67 3 0 4 20 4480 4744 [cl-struct-fastseedtype 194 721288 154 -24667648] "SORAZA"] [cl-struct-plansys 64 100 4 2 4 23 6624 5184 [cl-struct-fastseedtype 82 648000 10 133761536] "ORISTI"] [cl-struct-plansys 110 215 7 6 5 34 8160 3694 [cl-struct-fastseedtype 50 61038 90 82008576] "GEUSQUBI"] [cl-struct-plansys 134 122 2 0 7 31 7936 5254 [cl-struct-fastseedtype 130 438406 170 -64378368] "ESARQURE"] [cl-struct-plansys 46 218 2 4 9 43 22016 3886 [cl-struct-fastseedtype 226 532782 26 104077824] "RAIS"] [cl-struct-plansys 18 160 0 6 12 55 44000 2834 [cl-struct-fastseedtype 114 773650 202 99666432] "ERGESO"] [cl-struct-plansys 59 167 7 2 4 26 3744 4411 [cl-struct-fastseedtype 210 78139 218 -58271232] "BIESIN"] [cl-struct-plansys 29 44 4 4 6 33 12672 3613 [cl-struct-fastseedtype 34 17693 106 -38573568] "BEISDIRI"] [cl-struct-plansys 126 205 7 0 2 16 1536 4990 [cl-struct-fastseedtype 2 310398 154 -79128064] "USRAQU"] [cl-struct-plansys 55 90 2 2 9 41 15744 4407 [cl-struct-fastseedtype 146 435255 138 -47805952] "BIEDTIVE"] [cl-struct-plansys 246 23 7 6 5 34 8160 4598 [cl-struct-fastseedtype 114 66038 90 113662464] "BIBEER"] [cl-struct-plansys 42 144 2 0 7 31 7936 6698 [cl-struct-fastseedtype 194 67370 42 126822912] "AARZA"] [cl-struct-plansys 222 4 4 4 7 37 14208 6366 [cl-struct-fastseedtype 34 457950 26 36510208] "DIAQUTI"] [cl-struct-plansys 87 26 2 6 11 53 33920 3415 [cl-struct-fastseedtype 178 197463 74 75647488] "XERAREBI"] [cl-struct-plansys 70 206 6 2 4 25 4800 5190 [cl-struct-fastseedtype 18 334918 218 67754496] "ESRIRETI"] [cl-struct-plansys 151 110 6 4 6 35 8960 3991 [cl-struct-fastseedtype 98 935063 234 86305280] "ZAMASO"] [cl-struct-plansys 55 231 7 0 3 20 1920 5175 [cl-struct-fastseedtype 66 623415 154 21600768] "ESUSESQU"] [cl-struct-plansys 154 233 1 2 9 40 17280 6042 [cl-struct-fastseedtype 210 333466 10 -68417024] "INAVE"] [cl-struct-plansys 82 246 6 6 6 37 11840 5202 [cl-struct-fastseedtype 178 380242 90 -21407232] "ORXEREMA"] [cl-struct-plansys 203 14 6 0 4 23 2944 6091 [cl-struct-fastseedtype 2 181963 170 -19092992] "TEVERIAT"] [cl-struct-plansys 241 94 6 4 4 27 6912 4593 [cl-struct-fastseedtype 98 41969 26 -117040640] "BILADI"] [cl-struct-plansys 168 77 5 6 5 32 12800 5800 [cl-struct-fastseedtype 242 703144 202 -62141952] "MALEVE"] [cl-struct-plansys 196 54 6 2 2 17 3264 6084 [cl-struct-fastseedtype 82 786372 218 54319616] "TETIED"] [cl-struct-plansys 173 56 0 4 10 45 28800 6573 [cl-struct-fastseedtype 162 673453 106 -98670080] "RICEATRA"] [cl-struct-plansys 244 209 3 0 4 20 4480 5620 [cl-struct-fastseedtype 130 508660 154 -70608384] "ARERA"] [cl-struct-plansys 170 79 7 2 3 22 3168 5290 [cl-struct-fastseedtype 18 311722 138 126454272] "ESXEVEXE"] [cl-struct-plansys 194 182 6 6 6 37 11840 6082 [cl-struct-fastseedtype 242 354242 90 133978624] "TELALA"] [cl-struct-plansys 167 53 7 0 3 20 1920 3495 [cl-struct-fastseedtype 66 721063 42 -112055808] "ENRESO"] [cl-struct-plansys 168 39 7 4 2 20 3840 6824 [cl-struct-fastseedtype 162 577448 26 100604416] "ONATIBI"] [cl-struct-plansys 70 119 7 6 5 34 8160 6214 [cl-struct-fastseedtype 50 874310 74 -124958208] "DIARRIVE"] [cl-struct-plansys 246 30 6 2 4 25 4800 6902 [cl-struct-fastseedtype 146 642806 218 90167808] "ONRAMAON"] [cl-struct-plansys 159 203 3 4 9 44 19712 6815 [cl-struct-fastseedtype 226 485535 234 -69211648] "ONMAAR"] [cl-struct-plansys 245 202 2 0 6 27 6912 5877 [cl-struct-fastseedtype 194 1040629 154 101423616] "MAINDICE"] [cl-struct-plansys 165 205 5 2 4 24 5760 6821 [cl-struct-fastseedtype 82 885925 10 54462976] "ONATVE"] [cl-struct-plansys 135 150 6 6 7 41 13120 6791 [cl-struct-fastseedtype 50 753799 90 -36742656] "AINGEON"] [cl-struct-plansys 255 67 3 0 7 32 7168 6911 [cl-struct-fastseedtype 130 130559 170 -30430720] "AENLEGE"] [cl-struct-plansys 67 161 1 4 11 50 28800 4931 [cl-struct-fastseedtype 226 848195 26 72882688] "EDISOR"] [cl-struct-plansys 111 217 1 6 12 56 40320 4463 [cl-struct-fastseedtype 114 250991 202 75942400] "BIABI"] [cl-struct-plansys 28 198 6 2 2 17 3264 3356 [cl-struct-fastseedtype 210 840988 218 95607296] "ENLACE"] [cl-struct-plansys 174 101 5 4 6 34 10880 5294 [cl-struct-fastseedtype 34 868270 106 -106337792] "ESISRAAN"] [cl-struct-plansys 123 20 6 0 4 23 2944 6011 [cl-struct-fastseedtype 2 375419 154 -78865920] "INTEGE"] [cl-struct-plansys 204 163 3 2 5 26 8736 6092 [cl-struct-fastseedtype 146 923340 138 38570496] "INTEVEON"] [cl-struct-plansys 223 214 6 6 7 41 13120 3551 [cl-struct-fastseedtype 114 319199 90 -76391936] "ENSOOR"] [cl-struct-plansys 19 121 3 0 7 32 7168 4115 [cl-struct-fastseedtype 194 114707 42 78981632] "LAXEMA"] [cl-struct-plansys 3 11 3 4 9 44 19712 3075 [cl-struct-fastseedtype 34 635395 26 -11462144] "ATONBEZA"] [cl-struct-plansys 100 179 3 6 7 38 21280 4964 [cl-struct-fastseedtype 178 542052 74 -76002816] "EDERDITI"] [cl-struct-plansys 119 109 5 2 6 32 7680 4215 [cl-struct-fastseedtype 18 865655 218 -9053696] "LAQUSOED"] [cl-struct-plansys 24 71 7 4 2 20 3840 5400 [cl-struct-fastseedtype 98 284952 234 45804032] "QUANRE"] [cl-struct-plansys 196 238 6 0 1 11 1408 6340 [cl-struct-fastseedtype 66 664772 154 114137600] "DIENON"] [cl-struct-plansys 95 18 2 2 9 41 15744 3423 [cl-struct-fastseedtype 210 165727 10 133302784] "ENGELA"] [cl-struct-plansys 11 181 5 6 8 44 17600 4107 [cl-struct-fastseedtype 178 188939 90 -64660992] "CEBITIZA"] [cl-struct-plansys 36 23 7 0 0 8 768 3364 [cl-struct-fastseedtype 2 426020 170 69380608] "XERICEBI"] [cl-struct-plansys 38 165 5 4 6 34 10880 5414 [cl-struct-fastseedtype 98 553766 26 36313600] "ARLABI"] [cl-struct-plansys 101 70 6 6 5 33 10560 3173 [cl-struct-fastseedtype 242 21861 202 -123614720] "LEDILA"] [cl-struct-plansys 69 85 5 2 4 24 5760 4933 [cl-struct-fastseedtype 82 289605 218 -35071488] "USGEAT"] [cl-struct-plansys 30 177 1 4 10 46 26496 3870 [cl-struct-fastseedtype 162 703006 106 106195456] "RACEEDAT"] [cl-struct-plansys 17 152 2 0 6 27 6912 6417 [cl-struct-fastseedtype 130 814353 154 63871488] "REEDED"] [cl-struct-plansys 159 88 0 2 11 47 22560 6815 [cl-struct-fastseedtype 18 179615 138 124750336] "ABILAMA"] [cl-struct-plansys 75 117 5 6 8 44 17600 4939 [cl-struct-fastseedtype 242 459083 90 -81241600] "USESRI"] [cl-struct-plansys 112 94 6 0 1 11 1408 4976 [cl-struct-fastseedtype 66 470896 42 62401024] "EDBIRE"] [cl-struct-plansys 237 174 6 4 4 27 6912 3821 [cl-struct-fastseedtype 162 314861 26 -131917312] "GEONERBE"] [cl-struct-plansys 179 208 0 6 13 59 47200 3763 [cl-struct-fastseedtype 50 1034163 74 121850368] "GEBIISSO"] [cl-struct-plansys 199 189 5 2 6 32 7680 5831 [cl-struct-fastseedtype 146 838087 218 -62137856] "MAERZA"] [cl-struct-plansys 0 228 4 4 5 29 11136 4096 [cl-struct-fastseedtype 226 24576 234 62253568] "LAANAT"] [cl-struct-plansys 162 81 3 0 6 28 6272 6818 [cl-struct-fastseedtype 194 252066 154 -40920576] "AZAVEAR"] [cl-struct-plansys 202 182 6 2 4 25 4800 4298 [cl-struct-fastseedtype 82 587978 10 67439104] "CECELA"] [cl-struct-plansys 224 85 5 6 5 32 12800 5856 [cl-struct-fastseedtype 50 412640 90 62609920] "ANERINED"] [cl-struct-plansys 56 140 6 0 1 11 1408 4152 [cl-struct-fastseedtype 130 390968 170 -88757760] "LAQUUSED"] [cl-struct-plansys 152 104 0 4 9 41 26240 6040 [cl-struct-fastseedtype 226 660376 26 -58975744] "TEISEN"] [cl-struct-plansys 140 146 2 6 8 41 26240 6028 [cl-struct-fastseedtype 114 194444 202 43829760] "TEANCE"] [cl-struct-plansys 61 229 5 2 4 24 5760 6461 [cl-struct-fastseedtype 210 588861 218 98490880] "RILERI"] [cl-struct-plansys 255 30 6 4 6 35 8960 6911 [cl-struct-fastseedtype 34 770047 106 -98604544] "ONISANED"] [cl-struct-plansys 184 91 3 0 4 20 4480 3000 [cl-struct-fastseedtype 2 74936 154 -11494912] "ERZAIN"] [cl-struct-plansys 33 108 4 2 5 27 7776 3361 [cl-struct-fastseedtype 146 20513 138 15895040] "ENLAUS"] [cl-struct-plansys 8 149 5 6 5 32 12800 6408 [cl-struct-fastseedtype 114 321800 90 18766336] "RIANXE"] [cl-struct-plansys 188 226 2 0 5 23 5888 5820 [cl-struct-fastseedtype 194 571580 42 5974528] "ANQUEN"] [cl-struct-plansys 104 18 2 4 7 35 17920 4200 [cl-struct-fastseedtype 34 576872 26 -92988928] "LAAINAT"] [cl-struct-plansys 49 204 4 6 7 39 18720 6449 [cl-struct-fastseedtype 178 88113 74 99502592] "REININUS"] [cl-struct-plansys 232 12 4 2 4 23 6624 3304 [cl-struct-fastseedtype 18 230888 218 98687488] "LEVEOR"] [cl-struct-plansys 89 160 0 4 10 45 28800 2905 [cl-struct-fastseedtype 98 411481 234 -120526336] "ERMALA"] [cl-struct-plansys 145 245 7 0 1 12 1152 3217 [cl-struct-fastseedtype 66 525969 154 72456704] "ATEDANZA"] [cl-struct-plansys 228 187 3 2 5 26 8736 5092 [cl-struct-fastseedtype 210 733924 10 24644096] "EDTIRA"] [cl-struct-plansys 4 116 4 6 6 35 16800 3076 [cl-struct-fastseedtype 178 628740 90 -24028672] "ATARIS"] [cl-struct-plansys 61 160 2 0 6 27 6912 4925 [cl-struct-fastseedtype 2 625981 170 -68638208] "USBIINAN"] [cl-struct-plansys 155 236 4 4 8 41 15744 6555 [cl-struct-fastseedtype 98 277659 26 -45213184] "RELAON"] [cl-struct-plansys 226 191 7 6 5 34 8160 4834 [cl-struct-fastseedtype 242 521442 202 -59258368] "TIORRA"] [cl-struct-plansys 6 116 4 2 6 31 8928 3846 [cl-struct-fastseedtype 82 410118 218 127195648] "RAAAR"] [cl-struct-plansys 79 170 2 4 10 47 24064 5455 [cl-struct-fastseedtype 162 56143 106 -16094720] "ARCEONRE"] [cl-struct-plansys 110 95 7 0 2 16 1536 3438 [cl-struct-fastseedtype 130 43886 154 131242496] "ENLE"] [cl-struct-plansys 84 225 1 2 7 32 13824 4180 [cl-struct-fastseedtype 18 125012 138 -120223232] "LAARRARA"] [cl-struct-plansys 20 52 4 6 6 35 16800 3860 [cl-struct-fastseedtype 242 602132 90 122968576] "RAISSO"] [cl-struct-plansys 249 7 7 0 1 12 1152 6649 [cl-struct-fastseedtype 66 1000953 42 77474304] "RIRILA"] [cl-struct-plansys 114 53 5 4 6 34 10880 4722 [cl-struct-fastseedtype 162 514674 26 4659712] "SOAES"] [cl-struct-plansys 224 169 1 6 9 44 31680 5344 [cl-struct-fastseedtype 50 782560 74 24726016] "ORXETEED"] [cl-struct-plansys 216 92 4 2 4 23 6624 4824 [cl-struct-fastseedtype 146 648152 218 104323584] "TIINISLE"] [cl-struct-plansys 33 125 5 4 5 30 9600 5665 [cl-struct-fastseedtype 226 22817 234 -66328064] "MAMAED"] [cl-struct-plansys 143 216 2 0 8 35 8960 3727 [cl-struct-fastseedtype 194 80015 154 85170688] "BETEONA"] [cl-struct-plansys 175 31 7 2 4 26 3744 5807 [cl-struct-fastseedtype 82 593839 10 -95745536] "MAORRA"] [cl-struct-plansys 121 20 4 6 7 39 18720 4729 [cl-struct-fastseedtype 50 663673 90 111630848] "SORALAAT"] [cl-struct-plansys 49 85 7 0 1 12 1152 5681 [cl-struct-fastseedtype 130 912433 170 29075968] "ANXEADI"] [cl-struct-plansys 45 47 7 4 3 24 4608 2861 [cl-struct-fastseedtype 226 317485 26 -23062016] "ISMA"] [cl-struct-plansys 105 203 3 6 8 42 23520 3433 [cl-struct-fastseedtype 114 329577 202 3328512] "ENSOZA"] [cl-struct-plansys 158 4 4 2 6 31 8928 5534 [cl-struct-fastseedtype 210 882334 218 -49620480] "ARDITI"] [cl-struct-plansys 16 87 7 4 2 20 3840 4112 [cl-struct-fastseedtype 34 136720 106 -15373824] "LAISXELA"] [cl-struct-plansys 53 162 2 0 6 27 6912 3893 [cl-struct-fastseedtype 2 1002293 154 122984960] "RAINLA"] [cl-struct-plansys 54 181 5 2 5 28 6720 4918 [cl-struct-fastseedtype 146 8246 138 -115832320] "EDZARAAT"] [cl-struct-plansys 113 84 4 6 7 39 18720 5489 [cl-struct-fastseedtype 114 1044593 90 130701824] "ARAMA"] [cl-struct-plansys 37 203 3 0 5 24 5376 3109 [cl-struct-fastseedtype 194 999717 42 -92198400] "LEENOR"] [cl-struct-plansys 13 25 1 4 9 42 24192 5133 [cl-struct-fastseedtype 34 499469 26 60365312] "ORONCERI"] [cl-struct-plansys 190 101 5 6 7 40 16000 4030 [cl-struct-fastseedtype 178 3006 74 65292800] "ZAUSMAOR"] [cl-struct-plansys 153 171 3 2 6 30 10080 6297 [cl-struct-fastseedtype 18 384409 218 122542592] "DIENORQU"] [cl-struct-plansys 90 121 1 4 10 46 26496 4442 [cl-struct-fastseedtype 98 548698 234 124185088] "BIANTE"] [cl-struct-plansys 158 252 6 0 3 19 2432 4254 [cl-struct-fastseedtype 66 620702 154 -103441920] "LAERZAES"] [cl-struct-plansys 41 228 4 2 5 27 7776 6441 [cl-struct-fastseedtype 210 518441 10 -125957632] "RIMABE"] [cl-struct-plansys 61 51 3 6 8 42 23520 6205 [cl-struct-fastseedtype 178 966461 90 100489728] "ISREESVE"] [cl-struct-plansys 22 169 3 0 6 28 6272 6422 [cl-struct-fastseedtype 2 212502 170 103721472] "REREBEER"] [cl-struct-plansys 80 51 3 4 6 32 14336 3408 [cl-struct-fastseedtype 98 348240 26 -93185536] "ENLAED"] [cl-struct-plansys 31 184 0 6 13 59 47200 6175 [cl-struct-fastseedtype 242 616735 202 130927104] "DICEBE"] [cl-struct-plansys 7 147 3 2 8 38 12768 2823 [cl-struct-fastseedtype 82 349191 218 4250112] "ANGE"] [cl-struct-plansys 64 35 3 4 6 32 14336 2880 [cl-struct-fastseedtype 162 981568 106 71330304] "CEBIMA"] [cl-struct-plansys 11 38 6 0 4 23 2944 4363 [cl-struct-fastseedtype 130 577035 154 131504640] "VEUSAR"] [cl-struct-plansys 201 234 2 2 7 33 12672 5833 [cl-struct-fastseedtype 18 70089 138 -71595520] "ANREBEIS"] [cl-struct-plansys 29 243 3 6 8 42 23520 2845 [cl-struct-fastseedtype 242 443421 90 -58697216] "ATER"] [cl-struct-plansys 66 48 2 0 7 31 7936 3906 [cl-struct-fastseedtype 66 562242 42 -66835968] "ZAVETE"] [cl-struct-plansys 55 188 4 4 8 41 15744 5687 [cl-struct-fastseedtype 162 83255 26 -26535424] "MAONXEDI"] [cl-struct-plansys 205 2 2 6 9 45 28800 6861 [cl-struct-fastseedtype 50 1024717 74 120539648] "ARIANES"] [cl-struct-plansys 41 251 3 2 6 30 10080 3625 [cl-struct-fastseedtype 146 716073 218 52681216] "GEUSVEXE"] [cl-struct-plansys 2 150 6 4 5 31 7936 3074 [cl-struct-fastseedtype 226 500738 234 81914368] "LEANON"] [cl-struct-plansys 188 95 7 0 0 8 768 4796 [cl-struct-fastseedtype 194 676028 154 -57173504] "TIRAUSRA"] [cl-struct-plansys 84 8 0 2 8 35 16800 3156 [cl-struct-fastseedtype 82 170324 10 101779968] "ATDIBE"] [cl-struct-plansys 82 211 3 6 9 46 25760 3666 [cl-struct-fastseedtype 50 511570 90 110320128] "BEEDRIAR"] [cl-struct-plansys 234 158 6 0 3 19 2432 3306 [cl-struct-fastseedtype 130 863466 170 54635008] "LEARVEXE"] [cl-struct-plansys 2 246 6 4 5 31 7936 3842 [cl-struct-fastseedtype 226 691970 26 -87811584] "ZAISZA"] [cl-struct-plansys 6 132 4 6 8 43 20640 4870 [cl-struct-fastseedtype 114 906246 202 -45561344] "USBEGE"] [cl-struct-plansys 63 35 3 2 8 38 12768 4415 [cl-struct-fastseedtype 210 660543 218 -80291328] "VEORER"] [cl-struct-plansys 225 16 0 4 10 45 28800 5857 [cl-struct-fastseedtype 34 954849 106 -125081088] "MAISESEN"] [cl-struct-plansys 242 233 3 0 6 28 6272 5106 [cl-struct-fastseedtype 2 32242 154 56138240] "EDRARI"] [cl-struct-plansys 11 126 6 2 5 29 5568 6411 [cl-struct-fastseedtype 146 546571 138 -88176128] "RIUSBEQU"] [cl-struct-plansys 26 19 3 6 9 46 25760 4378 [cl-struct-fastseedtype 114 836890 90 -9020928] "VEGERA"] [cl-struct-plansys 78 52 6 0 3 19 2432 4686 [cl-struct-fastseedtype 194 436558 42 52898304] "SOAR"] [cl-struct-plansys 242 32 0 4 11 49 31360 6386 [cl-struct-fastseedtype 34 95986 26 -88270336] "ISARIMA"] [cl-struct-plansys 11 126 6 6 7 41 13120 5387 [cl-struct-fastseedtype 178 929803 74 89803264] "QUZAARAR"] [cl-struct-plansys 138 74 2 2 8 37 14208 5258 [cl-struct-fastseedtype 18 658570 218 62511616] "ORREENAN"] [cl-struct-plansys 27 210 2 4 10 47 24064 5915 [cl-struct-fastseedtype 98 454939 234 -25368064] "TEMAGE"] [cl-struct-plansys 235 3 3 0 7 32 7168 5355 [cl-struct-fastseedtype 66 838379 154 123312640] "ORUSDIRE"] [cl-struct-plansys 46 141 5 2 5 28 6720 3886 [cl-struct-fastseedtype 210 621102 10 -50066944] "ZAONEN"] [cl-struct-plansys 182 242 2 6 10 49 31360 5302 [cl-struct-fastseedtype 178 993206 90 40458752] "ESENENA"] [cl-struct-plansys 175 50 2 0 8 35 8960 4015 [cl-struct-fastseedtype 2 189103 170 49588736] "RAVEQUCE"] [cl-struct-plansys 69 122 2 4 8 39 19968 4421 [cl-struct-fastseedtype 98 327237 26 -107603456] "VELAAT"] [cl-struct-plansys 28 49 1 6 9 44 31680 3612 [cl-struct-fastseedtype 242 295452 202 -89929216] "GEATEN"] [cl-struct-plansys 72 178 2 2 6 29 11136 5960 [cl-struct-fastseedtype 82 880968 218 132962816] "INSOTE"] [cl-struct-plansys 241 28 4 4 6 33 12672 4593 [cl-struct-fastseedtype 162 1009393 106 100035072] "VECEDIUS"] [cl-struct-plansys 232 237 7 0 0 8 768 5608 [cl-struct-fastseedtype 130 74984 154 64657920] "QUERBE"] [cl-struct-plansys 254 115 3 2 7 34 11424 3326 [cl-struct-fastseedtype 18 461310 138 2198016] "LEENENBI"] [cl-struct-plansys 102 178 2 6 10 49 31360 5990 [cl-struct-fastseedtype 242 167270 90 -89368064] "INCEOR"] [cl-struct-plansys 75 217 3 0 7 32 7168 5451 [cl-struct-fastseedtype 66 27211 42 -102094336] "ARREGE"] [cl-struct-plansys 60 67 3 4 6 32 14336 6716 [cl-struct-fastseedtype 162 548412 26 42932736] "AAANQU"] [cl-struct-plansys 122 219 3 6 9 46 25760 4218 [cl-struct-fastseedtype 50 44410 74 -127579648] "CEQUQUQU"] [cl-struct-plansys 186 154 2 2 8 37 14208 6842 [cl-struct-fastseedtype 146 112058 218 51370496] "AZAAGE"] [cl-struct-plansys 163 47 7 4 5 32 6144 4771 [cl-struct-fastseedtype 226 954531 234 -29890048] "TIMABI"] [cl-struct-plansys 41 230 6 0 2 15 1920 5673 [cl-struct-fastseedtype 194 618793 154 68917760] "ANINATOR"] [cl-struct-plansys 185 113 1 2 8 36 15552 4793 [cl-struct-fastseedtype 82 157113 10 123144704] "TILEEN"] [cl-struct-plansys 107 146 2 6 11 53 33920 6763 [cl-struct-fastseedtype 50 533867 90 58677760] "ONTESOGE"] [cl-struct-plansys 99 103 7 0 3 20 1920 4707 [cl-struct-fastseedtype 130 985443 170 -12080640] "SOENISTI"] [cl-struct-plansys 23 189 5 4 7 38 12160 4887 [cl-struct-fastseedtype 226 34839 26 15211008] "USISIS"] [cl-struct-plansys 99 189 5 6 8 44 17600 6499 [cl-struct-fastseedtype 114 601443 202 -102839808] "RIONXE"] [cl-struct-plansys 32 66 2 2 6 29 11136 3360 [cl-struct-fastseedtype 210 435488 218 6478336] "XECEES"] [cl-struct-plansys 114 73 1 4 10 46 26496 3186 [cl-struct-fastseedtype 34 492402 106 109144576] "LEISERA"] [cl-struct-plansys 239 48 2 0 8 35 8960 6127 [cl-struct-fastseedtype 2 855279 154 56400384] "TETESO"] [cl-struct-plansys 160 199 7 2 1 14 2016 4000 [cl-struct-fastseedtype 146 771232 138 98863616] "ZAINENGE"] [cl-struct-plansys 3 210 2 6 11 53 33920 3331 [cl-struct-fastseedtype 114 669443 90 -131966464] "XETIIS"] [cl-struct-plansys 55 29 7 0 3 20 1920 6199 [cl-struct-fastseedtype 194 540983 42 -95606272] "DIXESO"] [cl-struct-plansys 23 39 7 4 5 32 6144 3095 [cl-struct-fastseedtype 34 632087 26 -2024960] "LEONTIED"] [cl-struct-plansys 24 23 7 6 3 26 6240 2840 [cl-struct-fastseedtype 178 890136 74 -95401472] "ERESAN"] [cl-struct-plansys 187 233 1 2 10 44 19008 4283 [cl-struct-fastseedtype 18 910011 218 -81405440] "CEARMATE"] [cl-struct-plansys 156 171 3 4 6 32 14336 3484 [cl-struct-fastseedtype 98 412828 234 -32314880] "ENANAR"]] [[cl-struct-plansys 32 165 7 0 0 8 768 5664 [cl-struct-fastseedtype 132 32 53 8074496] "ANLEIS"] [cl-struct-plansys 153 221 5 5 6 35 12600 5017 [cl-struct-fastseedtype 168 921 27 112728832] "EDRE"] [cl-struct-plansys 103 128 0 2 11 47 22560 4711 [cl-struct-fastseedtype 144 10599 5 -65600256] "TIONIS"] [cl-struct-plansys 147 125 5 7 9 49 21560 2963 [cl-struct-fastseedtype 252 121235 243 118551296] "ERXESOAN"] [cl-struct-plansys 251 199 7 1 4 25 3000 4347 [cl-struct-fastseedtype 76 338939 165 15049984] "CEUSES"] [cl-struct-plansys 23 137 3 0 7 32 7168 5143 [cl-struct-fastseedtype 192 150807 219 -112600320] "ESMAIN"] [cl-struct-plansys 129 76 4 7 8 44 23232 5249 [cl-struct-fastseedtype 184 329089 149 28939520] "ORUSGE"] [cl-struct-plansys 4 195 3 6 7 38 21280 2820 [cl-struct-fastseedtype 244 518660 83 38818560] "EREDDIVE"] [cl-struct-plansys 214 109 5 2 5 28 6720 6358 [cl-struct-fastseedtype 212 161494 85 -77769472] "ISXEVELA"] [cl-struct-plansys 213 214 6 3 4 26 5824 6357 [cl-struct-fastseedtype 152 504533 219 -95560960] "DIORIS"] [cl-struct-plansys 100 29 5 4 4 26 8320 5732 [cl-struct-fastseedtype 160 584548 101 -59022080] "ANISIS"] [cl-struct-plansys 85 221 5 5 6 35 12600 6741 [cl-struct-fastseedtype 172 725589 243 -131075328] "AXEUS"] [cl-struct-plansys 123 232 0 3 12 52 29120 4475 [cl-struct-fastseedtype 28 923003 69 46548224] "BIESMAAN"] [cl-struct-plansys 91 107 3 6 10 50 28000 2907 [cl-struct-fastseedtype 48 734043 27 66067200] "ERVELE"] [cl-struct-plansys 168 1 3 1 5 25 7000 2984 [cl-struct-fastseedtype 72 832168 117 23098624] "ARBE"] [cl-struct-plansys 126 19 3 4 8 40 17920 5758 [cl-struct-fastseedtype 36 115582 211 94098176] "ANDISO"] [cl-struct-plansys 16 71 7 4 2 20 3840 3856 [cl-struct-fastseedtype 36 923408 117 -125537024] "ZAANER"] [cl-struct-plansys 208 112 2 1 6 28 8960 6096 [cl-struct-fastseedtype 136 33232 155 -82011392] "TEISARZA"] [cl-struct-plansys 196 74 2 6 8 41 26240 6084 [cl-struct-fastseedtype 176 903876 197 -93534976] "INTEDI"] [cl-struct-plansys 150 173 5 3 6 33 9240 6806 [cl-struct-fastseedtype 92 546454 243 46134016] "ONGEQU"] [cl-struct-plansys 29 90 2 5 9 44 25344 5661 [cl-struct-fastseedtype 236 77853 229 -42212096] "ANBEDI"] [cl-struct-plansys 253 141 5 4 5 30 9600 6909 [cl-struct-fastseedtype 160 298237 91 -58762496] "ONARSOAT"] [cl-struct-plansys 17 135 7 3 3 23 3864 3857 [cl-struct-fastseedtype 216 22033 85 -6007552] "ZAISRA"] [cl-struct-plansys 214 244 4 2 6 31 8928 5078 [cl-struct-fastseedtype 84 762838 83 -133672192] "USENAT"] [cl-struct-plansys 140 177 1 6 9 44 31680 2956 [cl-struct-fastseedtype 116 411020 149 51418368] "ERREMAAR"] [cl-struct-plansys 74 235 3 7 10 51 31416 3914 [cl-struct-fastseedtype 120 1017418 91 -108766464] "ZAQUESSO"] [cl-struct-plansys 199 137 3 0 7 32 7168 5831 [cl-struct-fastseedtype 192 378055 37 730368] "MATERE"] [cl-struct-plansys 150 46 6 1 4 24 3840 2966 [cl-struct-fastseedtype 12 219542 243 52491008] "CETEGE"] [cl-struct-plansys 163 156 4 7 10 52 27456 4515 [cl-struct-fastseedtype 188 79779 133 -64584448] "BISOATON"] [cl-struct-plansys 191 49 1 2 10 44 19008 4799 [cl-struct-fastseedtype 16 256191 155 89627392] "TIUSRIRI"] [cl-struct-plansys 254 94 6 5 6 36 10368 4350 [cl-struct-fastseedtype 104 290814 53 -89836288] "CEXECE"] [cl-struct-plansys 77 165 7 0 1 12 1152 4173 [cl-struct-fastseedtype 132 365389 211 -67775744] "LAESINMA"] [cl-struct-plansys 11 44 6 0 4 23 2944 3083 [cl-struct-fastseedtype 196 486667 181 -31345408] "LEQUSO"] [cl-struct-plansys 3 135 7 5 6 37 7992 4099 [cl-struct-fastseedtype 104 131075 27 31791872] "CEERED"] [cl-struct-plansys 173 88 0 2 9 39 18720 4525 [cl-struct-fastseedtype 208 46253 133 125207808] "VETELE"] [cl-struct-plansys 148 161 1 7 10 49 38808 3476 [cl-struct-fastseedtype 188 602260 243 -105712896] "ENUSERIN"] [cl-struct-plansys 204 48 2 1 6 28 8960 4556 [cl-struct-fastseedtype 140 695756 37 31859968] "BIGEVE"] [cl-struct-plansys 95 150 6 0 4 23 2944 4959 [cl-struct-fastseedtype 128 225119 219 -52897024] "EDREBI"] [cl-struct-plansys 173 6 6 7 6 38 13376 3757 [cl-struct-fastseedtype 248 265901 21 8590592] "GETIUS"] [cl-struct-plansys 35 104 0 6 13 59 47200 3875 [cl-struct-fastseedtype 180 551971 83 130306816] "ZAEREDRE"] [cl-struct-plansys 78 56 0 2 10 43 20640 4686 [cl-struct-fastseedtype 20 286286 213 81253632] "TIRIZAAN"] [cl-struct-plansys 187 132 4 3 8 40 13440 6587 [cl-struct-fastseedtype 88 932027 219 -56698112] "RIRIOR"] [cl-struct-plansys 182 57 1 4 10 46 26496 6582 [cl-struct-fastseedtype 224 701366 229 -87104256] "RERIZA"] [cl-struct-plansys 210 68 4 5 8 42 18144 4306 [cl-struct-fastseedtype 108 78546 243 -86641920] "LADILA"] [cl-struct-plansys 88 149 5 3 4 25 7000 5464 [cl-struct-fastseedtype 92 59992 197 -103103232] "QUUSANRI"] [cl-struct-plansys 158 251 3 6 9 46 25760 3742 [cl-struct-fastseedtype 240 705438 27 -43836672] "GEISON"] [cl-struct-plansys 96 255 7 1 1 13 1560 6240 [cl-struct-fastseedtype 136 798304 245 -10619648] "ISRITE"] [cl-struct-plansys 152 124 4 4 5 29 11136 3736 [cl-struct-fastseedtype 228 834200 211 97768192] "BEESVE"] [cl-struct-plansys 19 86 6 4 6 35 8960 3347 [cl-struct-fastseedtype 100 241683 245 -95226624] "ENTEXE"] [cl-struct-plansys 50 34 2 1 8 36 11520 3122 [cl-struct-fastseedtype 72 287794 155 -32400640] "ATBIARXE"] [cl-struct-plansys 34 170 2 6 10 49 31360 3874 [cl-struct-fastseedtype 240 1014050 69 70534400] "RALEOR"] [cl-struct-plansys 143 89 1 3 11 49 24696 5263 [cl-struct-fastseedtype 28 252303 243 -18222336] "ESENMA"] [cl-struct-plansys 7 75 3 5 10 49 24696 3847 [cl-struct-fastseedtype 44 793351 101 119825664] "ZAVEXE"] [cl-struct-plansys 61 162 2 4 8 39 19968 4413 [cl-struct-fastseedtype 96 516669 91 -44672256] "VEVEESVE"] [cl-struct-plansys 86 201 1 3 10 45 22680 4182 [cl-struct-fastseedtype 24 465238 213 89511168] "LALALE"] [cl-struct-plansys 237 33 1 2 8 36 15552 4077 [cl-struct-fastseedtype 20 105709 83 75780864] "ZAENZA"] [cl-struct-plansys 27 4 4 6 9 47 22560 3611 [cl-struct-fastseedtype 180 859931 21 -105704192] "BEBELEUS"] [cl-struct-plansys 40 161 1 7 10 49 38808 6184 [cl-struct-fastseedtype 56 1015848 91 110975744] "ISSODIEN"] [cl-struct-plansys 50 45 7 0 2 16 1536 4402 [cl-struct-fastseedtype 0 899634 165 -37313280] "BICERI"] [cl-struct-plansys 10 30 6 1 4 24 3840 6410 [cl-struct-fastseedtype 204 106506 243 38728448] "REEDATED"] [cl-struct-plansys 152 209 1 7 10 49 38808 3736 [cl-struct-fastseedtype 252 394136 5 81986816] "GEDIESQU"] [cl-struct-plansys 250 201 1 2 9 40 17280 3578 [cl-struct-fastseedtype 208 524794 155 -15557888] "ENTIZARE"] [cl-struct-plansys 206 228 4 5 8 42 18144 5582 [cl-struct-fastseedtype 168 509902 181 9090304] "ARRITI"] [cl-struct-plansys 96 151 7 0 0 8 768 4192 [cl-struct-fastseedtype 68 238432 211 104190720] "LADIGESO"] [cl-struct-plansys 39 195 3 0 7 32 7168 4903 [cl-struct-fastseedtype 4 454183 53 102249728] "EDXEXE"] [cl-struct-plansys 93 66 2 5 9 44 25344 3421 [cl-struct-fastseedtype 40 406621 27 44178176] "XELE"] [cl-struct-plansys 36 64 0 2 8 35 16800 4388 [cl-struct-fastseedtype 16 690724 5 27657472] "BIARRA"] [cl-struct-plansys 133 212 4 7 8 44 23232 3973 [cl-struct-fastseedtype 124 648069 243 90501888] "ZAONESDI"] [cl-struct-plansys 205 169 3 1 6 29 8120 4557 [cl-struct-fastseedtype 204 503245 165 104244480] "VEREEN"] [cl-struct-plansys 151 178 2 0 8 35 8960 4759 [cl-struct-fastseedtype 64 29591 219 16243456] "TILEER"] [cl-struct-plansys 10 208 0 7 13 60 52800 5898 [cl-struct-fastseedtype 56 344074 149 -14904064] "TETIRI"] [cl-struct-plansys 50 30 6 6 6 37 11840 4914 [cl-struct-fastseedtype 116 241714 83 21517056] "USORBELA"] [cl-struct-plansys 245 19 3 2 6 30 10080 3573 [cl-struct-fastseedtype 84 214517 85 -90024704] "XEMAGEAT"] [cl-struct-plansys 145 67 3 3 7 35 13720 6801 [cl-struct-fastseedtype 24 766609 219 -92284160] "ONRACE"] [cl-struct-plansys 57 101 5 4 5 30 9600 3385 [cl-struct-fastseedtype 32 309817 101 -101554944] "ENERTE"] [cl-struct-plansys 63 188 4 5 9 46 19872 5695 [cl-struct-fastseedtype 44 115519 243 -57937152] "MASOEN"] [cl-struct-plansys 101 82 2 3 8 38 17024 6757 [cl-struct-fastseedtype 156 440677 69 104809728] "ONTITEEN"] [cl-struct-plansys 210 156 4 6 8 43 20640 4562 [cl-struct-fastseedtype 176 491986 27 -43640064] "BIRADI"] [cl-struct-plansys 72 13 7 1 1 13 1560 5704 [cl-struct-fastseedtype 200 390728 117 -13929216] "MALEVE"] [cl-struct-plansys 163 246 6 4 6 35 8960 5795 [cl-struct-fastseedtype 164 907171 211 1823488] "ANLALA"] [cl-struct-plansys 70 117 5 4 6 34 10880 3142 [cl-struct-fastseedtype 164 890182 117 -93227776] "ATDICE"] [cl-struct-plansys 132 229 7 1 1 13 1560 4484 [cl-struct-fastseedtype 8 38532 155 43424512] "VEONQUAT"] [cl-struct-plansys 177 26 2 6 9 45 28800 5809 [cl-struct-fastseedtype 48 539057 197 13354240] "MATIRA"] [cl-struct-plansys 119 20 4 3 8 40 13440 3703 [cl-struct-fastseedtype 220 721015 243 2355968] "GEERIN"] [cl-struct-plansys 32 76 4 5 6 34 14688 5920 [cl-struct-fastseedtype 108 179232 229 -132324096] "TEESBI"] [cl-struct-plansys 109 198 6 4 4 27 6912 6253 [cl-struct-fastseedtype 32 872813 91 -88253696] "ISATANAR"] [cl-struct-plansys 202 27 3 3 8 39 15288 4810 [cl-struct-fastseedtype 88 732362 85 -19442432] "TIISON"] [cl-struct-plansys 243 95 7 2 4 26 3744 3059 [cl-struct-fastseedtype 212 16371 83 17847040] "ERGESO"] [cl-struct-plansys 218 103 7 6 5 34 8160 4314 [cl-struct-fastseedtype 244 520410 149 10851584] "CESOUSLA"] [cl-struct-plansys 245 104 0 7 12 56 49280 4597 [cl-struct-fastseedtype 248 247285 91 -79275264] "BIZALEIN"] [cl-struct-plansys 204 225 3 0 4 20 4480 3532 [cl-struct-fastseedtype 64 95692 37 5383424] "ENONIS"] [cl-struct-plansys 111 29 7 1 4 25 3000 5999 [cl-struct-fastseedtype 140 712303 243 -57871616] "INQUVERI"] [cl-struct-plansys 190 22 6 7 7 42 14784 6846 [cl-struct-fastseedtype 60 172478 133 116360448] "AZAENBI"] [cl-struct-plansys 38 114 2 2 8 37 14208 6182 [cl-struct-fastseedtype 144 311590 155 -77751552] "ISVEQURE"] [cl-struct-plansys 206 122 2 5 10 48 27648 3022 [cl-struct-fastseedtype 232 807886 53 -62900992] "ESED"] [cl-struct-plansys 99 152 2 0 8 35 8960 4195 [cl-struct-fastseedtype 4 131427 211 109433600] "CELEAREN"] [cl-struct-plansys 114 106 2 0 7 31 7936 6514 [cl-struct-fastseedtype 68 553842 181 6206720] "RIANIN"] [cl-struct-plansys 166 12 4 5 8 42 18144 6822 [cl-struct-fastseedtype 232 217254 27 15670016] "AXEED"] [cl-struct-plansys 202 56 0 2 10 43 20640 4298 [cl-struct-fastseedtype 80 47562 133 44401920] "CEUSED"] [cl-struct-plansys 102 24 0 7 13 60 52800 4454 [cl-struct-fastseedtype 60 66150 243 36107008] "BICEENON"] [cl-struct-plansys 255 50 2 1 9 40 12800 4863 [cl-struct-fastseedtype 12 134143 37 97985792] "TIUSON"] [cl-struct-plansys 191 223 7 0 3 20 1920 4543 [cl-struct-fastseedtype 0 805311 219 -39396608] "BIZAAR"] [cl-struct-plansys 150 170 2 7 11 54 38016 4502 [cl-struct-fastseedtype 120 158102 21 92673280] "BISOGE"] [cl-struct-plansys 49 227 3 6 8 42 23520 5937 [cl-struct-fastseedtype 52 656945 83 115102464] "TEATRIIN"] [cl-struct-plansys 204 254 6 2 2 17 3264 6092 [cl-struct-fastseedtype 148 433612 213 79484160] "TEUSATVE"] [cl-struct-plansys 86 17 1 3 10 45 22680 2902 [cl-struct-fastseedtype 216 872534 219 -68101376] "ERORLE"] [cl-struct-plansys 235 161 1 4 11 50 28800 4331 [cl-struct-fastseedtype 96 888555 229 31843584] "CEENGE"] [cl-struct-plansys 155 67 3 5 10 49 24696 3227 [cl-struct-fastseedtype 236 938907 243 89256704] "ATATON"] [cl-struct-plansys 162 31 7 3 4 27 4536 3746 [cl-struct-fastseedtype 220 963234 197 -801536] "BEVEINVE"] [cl-struct-plansys 246 76 4 6 8 43 20640 5366 [cl-struct-fastseedtype 112 450038 27 -67560704] "ORTEMA"] [cl-struct-plansys 97 43 3 1 6 29 8120 4961 [cl-struct-fastseedtype 8 219745 245 -121047808] "USLAON"] [cl-struct-plansys 158 127 7 4 4 28 5376 3742 [cl-struct-fastseedtype 100 387742 211 -59518208] "BEATZA"] [cl-struct-plansys 169 164 4 4 6 33 12672 6825 [cl-struct-fastseedtype 228 571049 245 14677248] "ONDITI"] [cl-struct-plansys 197 183 7 1 2 17 2040 5829 [cl-struct-fastseedtype 200 51397 155 11246336] "MAESQUA"] [cl-struct-plansys 111 154 2 6 11 53 33920 3695 [cl-struct-fastseedtype 112 662639 69 -130857728] "BEIS"] [cl-struct-plansys 80 224 0 3 9 40 22400 6224 [cl-struct-fastseedtype 156 777040 243 -26348800] "DIRIIS"] [cl-struct-plansys 105 93 5 5 6 35 12600 4201 [cl-struct-fastseedtype 172 377705 101 -127572736] "CEINAN"] [cl-struct-plansys 140 251 3 4 6 32 14336 3980 [cl-struct-fastseedtype 224 313996 91 -55289088] "RATEISRE"] [cl-struct-plansys 110 125 5 3 6 33 9240 4974 [cl-struct-fastseedtype 152 876654 213 69784832] "USLAIN"] [cl-struct-plansys 234 172 4 2 6 31 8928 6122 [cl-struct-fastseedtype 148 56554 83 95179520] "INGEQU"] [cl-struct-plansys 202 218 2 6 10 49 31360 5066 [cl-struct-fastseedtype 52 76490 21 -1567488] "USINRIBE"] [cl-struct-plansys 179 62 6 7 8 46 16192 6835 [cl-struct-fastseedtype 184 952243 91 -8430848] "ONENCEVE"] [cl-struct-plansys 150 165 7 0 2 16 1536 6294 [cl-struct-fastseedtype 128 427926 165 -5397248] "DIESDI"] [cl-struct-plansys 196 45 7 1 1 13 1560 5572 [cl-struct-fastseedtype 76 107716 243 -103091456] "QUINMABE"] [cl-struct-plansys 19 107 3 7 11 55 33880 5907 [cl-struct-fastseedtype 124 82451 5 -95681280] "INMAARXE"] [cl-struct-plansys 66 42 2 2 8 37 14208 4930 [cl-struct-fastseedtype 80 824898 155 37264128] "EDCEON"] [cl-struct-plansys 255 32 0 5 13 58 41760 4351 [cl-struct-fastseedtype 40 156671 181 96843008] "CECEAR"] [cl-struct-plansys 85 170 2 0 6 27 6912 4181 [cl-struct-fastseedtype 196 687445 211 82170624] "CEBILEDI"] [cl-struct-plansys 237 33 3 0 5 24 5376 4333 [cl-struct-fastseedtype 132 781549 53 83178752] "LAZASO"] [cl-struct-plansys 224 231 7 5 3 25 5400 6112 [cl-struct-fastseedtype 168 656608 27 80485120] "INBE"] [cl-struct-plansys 160 64 0 2 8 35 16800 4256 [cl-struct-fastseedtype 144 283552 5 41223424] "LAVEMA"] [cl-struct-plansys 54 107 3 7 10 51 31416 4918 [cl-struct-fastseedtype 252 892214 243 133755648] "EDANMA"] [cl-struct-plansys 96 203 3 1 5 25 7000 4704 [cl-struct-fastseedtype 76 354400 165 -121133824] "SOBEAN"] [cl-struct-plansys 214 27 3 0 6 28 6272 4310 [cl-struct-fastseedtype 192 254422 219 -85599488] "CEEDRA"] [cl-struct-plansys 82 148 4 7 9 48 25344 6738 [cl-struct-fastseedtype 184 219986 149 -71330560] "ONSOOR"] [cl-struct-plansys 31 185 1 6 12 56 40320 2847 [cl-struct-fastseedtype 244 900639 83 8409856] "ORORBE"] [cl-struct-plansys 211 249 1 2 10 44 19008 4819 [cl-struct-fastseedtype 212 775635 85 -81308416] "SOLAERIN"] [cl-struct-plansys 12 240 0 3 9 40 22400 3084 [cl-struct-fastseedtype 152 672268 219 -118367488] "ATREDI"] [cl-struct-plansys 205 237 5 4 5 30 9600 5325 [cl-struct-fastseedtype 160 639437 101 -89561856] "ESZAAN"] [cl-struct-plansys 232 219 3 5 7 37 18648 4840 [cl-struct-fastseedtype 172 685032 243 -47713536] "SOMATE"] [cl-struct-plansys 16 252 4 3 5 28 9408 4880 [cl-struct-fastseedtype 28 919056 69 -17283840] "EDZADIAR"] [cl-struct-plansys 10 13 5 6 7 40 16000 5898 [cl-struct-fastseedtype 48 542730 27 18619136] "TEBEOR"] [cl-struct-plansys 169 89 3 1 6 29 8120 4521 [cl-struct-fastseedtype 72 764585 117 70677760] "VEOROR"] [cl-struct-plansys 137 25 1 4 9 42 24192 5769 [cl-struct-fastseedtype 36 508809 211 47960832] "ANRIGE"] [cl-struct-plansys 61 227 3 4 7 36 16128 6461 [cl-struct-fastseedtype 36 525373 117 94270720] "RIRIQU"] [cl-struct-plansys 247 154 2 1 9 40 12800 3063 [cl-struct-fastseedtype 136 699127 155 5282560] "ERXEARIS"] [cl-struct-plansys 93 42 2 6 9 45 28800 5469 [cl-struct-fastseedtype 176 340317 197 40551680] "ARBEAN"] [cl-struct-plansys 25 187 3 3 7 35 13720 4633 [cl-struct-fastseedtype 92 424473 243 29881088] "SOTERI"] [cl-struct-plansys 226 126 6 5 6 36 10368 6370 [cl-struct-fastseedtype 236 778466 229 -137984] "ISRION"] [cl-struct-plansys 156 63 7 4 2 20 3840 5788 [cl-struct-fastseedtype 160 540060 91 -79996160] "ANTIAXE"] [cl-struct-plansys 66 239 7 3 4 27 4536 5442 [cl-struct-fastseedtype 216 820290 85 -45460224] "ARTEAR"] [cl-struct-plansys 209 10 2 2 7 33 12672 5073 [cl-struct-fastseedtype 84 967633 83 -94874880] "EDBEIS"] [cl-struct-plansys 233 93 5 6 6 36 14400 5609 [cl-struct-fastseedtype 116 605417 149 -8743680] "QULECELE"] [cl-struct-plansys 97 37 5 7 7 41 18040 4961 [cl-struct-fastseedtype 120 783713 91 -79144192] "USAORER"] [cl-struct-plansys 144 121 3 0 4 20 4480 5264 [cl-struct-fastseedtype 192 32656 37 64562432] "ORGEIN"] [cl-struct-plansys 9 76 6 1 3 20 3200 4873 [cl-struct-fastseedtype 12 688905 243 37286656] "EDREERED"] [cl-struct-plansys 152 208 0 7 11 52 45760 5016 [cl-struct-fastseedtype 188 136344 133 116950272] "EDXEBERE"] [cl-struct-plansys 78 243 3 2 7 34 11424 3662 [cl-struct-fastseedtype 16 782670 155 -73164032] "GECEVEON"] [cl-struct-plansys 95 214 6 5 7 40 11520 5727 [cl-struct-fastseedtype 104 542815 53 85669120] "ANATMA"] [cl-struct-plansys 56 203 3 0 4 20 4480 4152 [cl-struct-fastseedtype 132 583480 211 -111815936] "LAQUUSED"] [cl-struct-plansys 152 232 2 0 5 23 5888 5784 [cl-struct-fastseedtype 196 477848 181 -69487360] "ANISAT"] [cl-struct-plansys 10 209 1 5 11 51 33048 5130 [cl-struct-fastseedtype 104 327946 27 104405760] "ORLAED"] [cl-struct-plansys 166 88 0 2 10 43 20640 4006 [cl-struct-fastseedtype 208 288678 133 -116095744] "RABEA"] [cl-struct-plansys 247 207 7 7 7 43 11352 5623 [cl-struct-fastseedtype 188 50167 243 -19205376] "QULERAAT"] [cl-struct-plansys 241 116 6 1 3 20 3200 5105 [cl-struct-fastseedtype 140 226033 37 117974272] "USREUS"] [cl-struct-plansys 222 104 2 0 7 31 7936 4062 [cl-struct-fastseedtype 128 928734 219 11852544] "RAANRE"] [cl-struct-plansys 62 142 6 7 7 42 14784 5182 [cl-struct-fastseedtype 248 910654 21 -104262400] "ESVERI"] [cl-struct-plansys 254 158 6 6 6 37 11840 4094 [cl-struct-fastseedtype 180 206846 83 104092416] "RAATZAMA"] [cl-struct-plansys 11 4 4 2 7 35 10080 3083 [cl-struct-fastseedtype 20 417291 213 98686208] "LEATRIEN"] [cl-struct-plansys 178 222 6 3 5 30 6720 3506 [cl-struct-fastseedtype 88 243634 219 -108864768] "XEBEES"] [cl-struct-plansys 223 73 1 4 11 50 28800 6111 [cl-struct-fastseedtype 224 778975 229 -63118080] "TECEXE"] [cl-struct-plansys 37 130 2 5 9 44 25344 6181 [cl-struct-fastseedtype 108 767013 243 -66194688] "DIVEES"] [cl-struct-plansys 173 233 1 3 9 41 20664 6061 [cl-struct-fastseedtype 92 1041325 197 -78854912] "INGEISDI"] [cl-struct-plansys 13 221 5 6 6 36 14400 6669 [cl-struct-fastseedtype 240 339981 27 80681728] "AQUTI"] [cl-struct-plansys 33 151 7 1 2 17 2040 3617 [cl-struct-fastseedtype 136 276257 245 -109841152] "BEDIXE"] [cl-struct-plansys 99 194 2 4 10 47 24064 3683 [cl-struct-fastseedtype 228 537187 211 -78392576] "BEQUEN"] [cl-struct-plansys 0 50 2 4 7 35 17920 5888 [cl-struct-fastseedtype 100 290304 245 11334912] "INONIN"] [cl-struct-plansys 25 140 6 1 3 20 3200 4121 [cl-struct-fastseedtype 72 912665 155 -108684544] "CEMAARAN"] [cl-struct-plansys 123 202 2 6 11 53 33920 3451 [cl-struct-fastseedtype 240 493691 69 124929280] "ENEDSO"] [cl-struct-plansys 210 167 7 3 4 27 4536 3282 [cl-struct-fastseedtype 28 847058 243 36827904] "ATMAA"] [cl-struct-plansys 140 175 7 5 3 25 5400 4492 [cl-struct-fastseedtype 44 115852 101 115762432] "BILERA"] [cl-struct-plansys 156 148 4 4 5 29 11136 3484 [cl-struct-fastseedtype 96 760476 91 -28157184] "ENGEATSO"] [cl-struct-plansys 71 113 1 3 11 49 24696 5703 [cl-struct-fastseedtype 24 354375 213 37475584] "ANRATI"] [cl-struct-plansys 168 119 7 2 1 14 2016 4008 [cl-struct-fastseedtype 20 476328 83 118772480] "RABEER"] [cl-struct-plansys 56 240 0 6 10 47 37600 6200 [cl-struct-fastseedtype 180 431928 21 123540736] "ISBIANON"] [cl-struct-plansys 255 27 3 7 11 55 33880 3327 [cl-struct-fastseedtype 56 147199 91 111237888] "LETEISAN"] [cl-struct-plansys 187 93 7 0 3 20 1920 4027 [cl-struct-fastseedtype 0 60859 165 81044736] "RAINTE"] [cl-struct-plansys 61 124 6 1 3 20 3200 4413 [cl-struct-fastseedtype 204 788797 243 -39390464] "BILECEDI"] [cl-struct-plansys 77 69 5 7 7 41 18040 4173 [cl-struct-fastseedtype 252 739661 5 83166464] "LAUSMAES"] [cl-struct-plansys 73 203 3 2 6 30 10080 6473 [cl-struct-fastseedtype 208 606793 155 -6382848] "RIRATEA"] [cl-struct-plansys 239 156 4 5 9 46 19872 3055 [cl-struct-fastseedtype 168 676079 181 37795072] "DIIS"] [cl-struct-plansys 11 253 7 0 3 20 1920 4107 [cl-struct-fastseedtype 68 724747 211 -69872896] "LARIONRA"] [cl-struct-plansys 116 191 7 0 0 8 768 3444 [cl-struct-fastseedtype 4 425076 53 -49138432] "ENCEIN"] [cl-struct-plansys 36 204 4 5 6 34 14688 4388 [cl-struct-fastseedtype 40 587044 27 -46785792] "VEBI"] [cl-struct-plansys 221 128 0 2 9 39 18720 4061 [cl-struct-fastseedtype 16 919005 5 -24902400] "ZALEXE"] [cl-struct-plansys 168 66 2 7 9 46 32384 6056 [cl-struct-fastseedtype 124 886440 243 -20122880] "INEDDIEN"] [cl-struct-plansys 178 45 7 1 3 21 2520 5042 [cl-struct-fastseedtype 204 252850 165 -124214016] "EDORZA"] [cl-struct-plansys 214 196 6 0 3 19 2432 3798 [cl-struct-fastseedtype 64 792534 219 118741760] "BEREED"] [cl-struct-plansys 91 152 0 7 14 64 56320 3419 [cl-struct-fastseedtype 56 382811 149 128095488] "XEVERA"] [cl-struct-plansys 205 148 4 6 7 39 18720 5069 [cl-struct-fastseedtype 116 37837 83 -503040] "EDQUONEN"] [cl-struct-plansys 114 31 7 2 3 22 3168 6002 [cl-struct-fastseedtype 84 1025650 85 -51620608] "INRIISUS"] [cl-struct-plansys 72 221 5 3 4 25 7000 3656 [cl-struct-fastseedtype 24 319816 219 94624512] "GEESLA"] [cl-struct-plansys 34 181 5 4 6 34 10880 2850 [cl-struct-fastseedtype 32 295458 101 -23042816] "TIQU"] [cl-struct-plansys 82 58 2 5 10 48 27648 3666 [cl-struct-fastseedtype 44 631890 243 -100404480] "GEERBI"] [cl-struct-plansys 122 230 6 3 5 30 6720 3194 [cl-struct-fastseedtype 156 359290 69 -51297024] "ATENRILE"] [cl-struct-plansys 1 190 6 6 5 33 10560 3329 [cl-struct-fastseedtype 176 67073 27 -15590656] "ENATCE"] [cl-struct-plansys 201 229 7 1 2 17 2040 3273 [cl-struct-fastseedtype 200 20425 117 8484096] "LEERTE"] [cl-struct-plansys 46 124 4 4 7 37 14208 5678 [cl-struct-fastseedtype 164 919342 211 -35925248] "ANBIAT"] [cl-struct-plansys 243 145 1 4 11 50 28800 5875 [cl-struct-fastseedtype 164 844787 117 -99912448] "MAERA"] [cl-struct-plansys 43 143 7 1 4 25 3000 5419 [cl-struct-fastseedtype 8 278315 155 71998208] "ARZAQUAR"] [cl-struct-plansys 202 122 2 6 10 49 31360 5322 [cl-struct-fastseedtype 48 864714 197 -11942656] "ESREXE"] [cl-struct-plansys 122 162 2 3 9 42 18816 5754 [cl-struct-fastseedtype 220 213882 243 128709376] "MAESER"] [cl-struct-plansys 101 240 0 5 11 50 36000 6501 [cl-struct-fastseedtype 108 663141 229 85910784] "RIRAED"] [cl-struct-plansys 140 248 0 4 9 41 26240 5260 [cl-struct-fastseedtype 32 840076 91 -33989888] "ORRIGEAN"] [cl-struct-plansys 123 3 3 3 9 43 16856 6267 [cl-struct-fastseedtype 88 187515 85 -84060928] "ISTELA"] [cl-struct-plansys 110 245 5 2 5 28 6720 2926 [cl-struct-fastseedtype 212 634734 83 65032960] "ZABE"] [cl-struct-plansys 183 147 3 6 10 50 28000 6839 [cl-struct-fastseedtype 244 371127 149 -7367424] "AQUXEIN"] [cl-struct-plansys 140 34 2 7 9 46 32384 5516 [cl-struct-fastseedtype 248 103564 91 -108373248] "ARORATLA"] [cl-struct-plansys 21 81 3 0 5 24 5376 2837 [cl-struct-fastseedtype 64 483861 37 -90168064] "BIAN"] [cl-struct-plansys 98 187 3 1 7 33 9240 3938 [cl-struct-fastseedtype 140 968546 243 69530368] "ZAGEARBE"] [cl-struct-plansys 51 202 2 7 12 58 40832 3123 [cl-struct-fastseedtype 60 593971 133 -62814976] "LEONRALA"] [cl-struct-plansys 53 180 4 2 5 27 7776 5173 [cl-struct-fastseedtype 144 325941 155 103389952] "ESBEENA"] [cl-struct-plansys 175 114 2 5 11 52 29952 4527 [cl-struct-fastseedtype 232 183727 53 87438592] "VEEDRI"] [cl-struct-plansys 206 62 6 0 3 19 2432 4302 [cl-struct-fastseedtype 4 50382 211 73782016] "CEENBION"] [cl-struct-plansys 127 166 6 0 4 23 2944 4991 [cl-struct-fastseedtype 68 750207 181 10007808] "EDRIVE"] [cl-struct-plansys 45 214 6 5 5 32 9216 3629 [cl-struct-fastseedtype 232 299309 27 29563648] "GESOED"] [cl-struct-plansys 67 184 0 2 11 47 22560 3651 [cl-struct-fastseedtype 80 802371 133 -87849728] "GEONBI"] [cl-struct-plansys 73 198 6 7 6 38 13376 6473 [cl-struct-fastseedtype 60 587081 243 -3214592] "RERIVEZA"] [cl-struct-plansys 164 246 6 1 2 16 2560 5284 [cl-struct-fastseedtype 12 283300 37 91825408] "ORBEAT"] [cl-struct-plansys 190 49 3 0 6 28 6272 3518 [cl-struct-fastseedtype 0 562622 219 100850432] "XEATEN"] [cl-struct-plansys 167 178 2 7 12 58 40832 6055 [cl-struct-fastseedtype 120 852391 21 -45345536] "INBIOR"] [cl-struct-plansys 140 153 1 6 9 44 31680 6028 [cl-struct-fastseedtype 52 938380 83 97276672] "INENARES"] [cl-struct-plansys 9 74 2 2 7 33 12672 4361 [cl-struct-fastseedtype 148 466697 213 -129575680] "BIANMADI"] [cl-struct-plansys 205 235 3 3 7 35 13720 4045 [cl-struct-fastseedtype 216 192205 219 89447168] "RAREAT"] [cl-struct-plansys 148 49 1 4 8 38 21888 3732 [cl-struct-fastseedtype 96 143252 229 -103553792] "BEORLE"] [cl-struct-plansys 110 1 1 5 11 51 33048 5230 [cl-struct-fastseedtype 236 906350 243 -16125184] "ESQUBE"] [cl-struct-plansys 119 243 3 3 9 43 16856 4215 [cl-struct-fastseedtype 220 392567 197 -68827904] "CEATRECE"] [cl-struct-plansys 229 174 6 6 5 33 10560 4325 [cl-struct-fastseedtype 112 604645 27 132455168] "CEORGE"] [cl-struct-plansys 162 67 3 1 7 33 9240 6562 [cl-struct-fastseedtype 8 83106 245 23000320] "RIZACE"] [cl-struct-plansys 233 69 5 4 5 30 9600 3817 [cl-struct-fastseedtype 100 135657 211 41145088] "BEXE"] [cl-struct-plansys 22 0 0 4 11 49 31360 5142 [cl-struct-fastseedtype 228 415254 245 -105253632] "ORERLE"] [cl-struct-plansys 44 161 3 1 5 25 7000 6700 [cl-struct-fastseedtype 200 86316 155 -123757824] "ONREQUUS"] [cl-struct-plansys 72 58 2 6 8 41 26240 3144 [cl-struct-fastseedtype 112 15688 69 32589056] "ATRARE"] [cl-struct-plansys 19 174 6 3 6 34 7616 4115 [cl-struct-fastseedtype 156 1019411 243 -97127680] "LATILE"] [cl-struct-plansys 110 65 1 5 11 51 33048 4718 [cl-struct-fastseedtype 172 892526 101 44524800] "SOTIDI"] [cl-struct-plansys 107 109 5 4 7 38 12160 2923 [cl-struct-fastseedtype 224 250475 91 36723456] "ERESCEON"] [cl-struct-plansys 223 165 5 3 7 37 10360 6623 [cl-struct-fastseedtype 152 897247 213 -7416576] "RERAXE"] [cl-struct-plansys 37 130 2 2 7 33 12672 5925 [cl-struct-fastseedtype 148 480293 83 -121875712] "TEZABI"] [cl-struct-plansys 103 70 6 6 7 41 13120 3431 [cl-struct-fastseedtype 52 582759 21 1185024] "ENONEDAR"] [cl-struct-plansys 10 56 0 7 13 60 52800 3594 [cl-struct-fastseedtype 184 271882 91 -66888960] "GESOLAON"] [cl-struct-plansys 159 85 7 0 3 20 1920 5791 [cl-struct-fastseedtype 128 93343 165 -46422784] "ANERMA"] [cl-struct-plansys 119 11 3 1 8 37 10360 3447 [cl-struct-fastseedtype 76 871799 243 -38604032] "ENLAONUS"] [cl-struct-plansys 72 95 7 7 4 31 8184 6472 [cl-struct-fastseedtype 124 891208 5 81659136] "RIBIINAT"] [cl-struct-plansys 17 172 4 2 5 27 7776 3857 [cl-struct-fastseedtype 80 624145 155 121936640] "ZAXEED"] [cl-struct-plansys 160 88 0 5 10 46 33120 5792 [cl-struct-fastseedtype 40 659104 181 100381952] "ANRAER"] [cl-struct-plansys 128 144 2 0 5 23 5888 4224 [cl-struct-fastseedtype 196 776320 211 -83504384] "CETIISQU"]] [[cl-struct-plansys 64 75 3 1 5 25 7000 4416 [cl-struct-fastseedtype 9 64 106 16148992] "VELEEDER"] [cl-struct-plansys 48 184 0 2 8 35 16800 5424 [cl-struct-fastseedtype 85 1328 64 -110477312] "ARENDI"] [cl-struct-plansys 170 237 5 3 6 33 9240 5546 [cl-struct-fastseedtype 93 15018 122 -68519424] "ARXETIGE"] [cl-struct-plansys 131 23 7 6 6 38 9120 6019 [cl-struct-fastseedtype 177 171907 232 52226048] "TETIED"] [cl-struct-plansys 44 88 2 0 5 23 5888 5932 [cl-struct-fastseedtype 193 918828 154 121412096] "TELEAR"] [cl-struct-plansys 41 42 2 3 8 38 17024 4137 [cl-struct-fastseedtype 29 495913 160 -82468864] "LAESUSSO"] [cl-struct-plansys 39 168 0 6 13 59 47200 5159 [cl-struct-fastseedtype 181 783911 202 20564480] "ORESMAA"] [cl-struct-plansys 175 107 3 3 9 43 16856 4015 [cl-struct-fastseedtype 25 487087 104 -64722944] "ZARIENLA"] [cl-struct-plansys 117 18 2 7 10 50 35200 4725 [cl-struct-fastseedtype 185 336245 10 113707520] "SOAMAXE"] [cl-struct-plansys 162 139 3 4 8 40 17920 6306 [cl-struct-fastseedtype 37 626594 64 -126009344] "ISMAARBE"] [cl-struct-plansys 243 202 2 1 9 40 12800 5363 [cl-struct-fastseedtype 77 672243 90 -76981760] "ESSOZA"] [cl-struct-plansys 20 132 6 0 1 11 1408 2836 [cl-struct-fastseedtype 193 378132 40 -20961280] "EDDI"] [cl-struct-plansys 70 45 5 6 7 40 16000 6214 [cl-struct-fastseedtype 241 807238 186 63814144] "DIXETISO"] [cl-struct-plansys 103 87 7 5 6 37 7992 3175 [cl-struct-fastseedtype 109 956775 32 -16703488] "LEONUS"] [cl-struct-plansys 233 40 0 4 10 45 28800 3305 [cl-struct-fastseedtype 37 258793 42 114371072] "ATXETEER"] [cl-struct-plansys 80 156 4 5 6 34 14688 2896 [cl-struct-fastseedtype 169 49232 40 -103798784] "ERISRIIN"] [cl-struct-plansys 108 222 6 5 4 28 8064 4972 [cl-struct-fastseedtype 105 695148 170 -49763840] "USBEUS"] [cl-struct-plansys 36 200 0 6 10 47 37600 3108 [cl-struct-fastseedtype 245 811556 64 121716736] "LERELA"] [cl-struct-plansys 5 149 5 7 7 41 18040 5125 [cl-struct-fastseedtype 61 917765 58 -87475712] "ESGEEN"] [cl-struct-plansys 94 50 2 2 8 37 14208 3934 [cl-struct-fastseedtype 209 168286 104 133457920] "RACEED"] [cl-struct-plansys 82 216 0 4 11 49 31360 6738 [cl-struct-fastseedtype 33 960082 218 78633472] "AQUTEBI"] [cl-struct-plansys 102 220 4 7 9 48 25344 6246 [cl-struct-fastseedtype 189 785766 160 102604800] "ISCEGE"] [cl-struct-plansys 99 229 5 2 6 32 7680 5219 [cl-struct-fastseedtype 149 1029219 138 44665344] "ESENON"] [cl-struct-plansys 155 255 7 7 7 43 11352 6043 [cl-struct-fastseedtype 57 481691 232 9234432] "INSOAZA"] [cl-struct-plansys 4 79 7 3 2 19 3192 5636 [cl-struct-fastseedtype 25 744708 74 -109360640] "ANARE"] [cl-struct-plansys 152 78 6 0 1 11 1408 4504 [cl-struct-fastseedtype 197 95128 64 -38387712] "VEISIN"] [cl-struct-plansys 64 236 4 5 6 34 14688 5440 [cl-struct-fastseedtype 45 8768 26 113908224] "ARVELELE"] [cl-struct-plansys 193 1 1 4 9 42 24192 5313 [cl-struct-fastseedtype 225 268225 168 -122050560] "ORTEED"] [cl-struct-plansys 46 248 0 2 10 43 20640 3374 [cl-struct-fastseedtype 81 992302 250 -6096384] "XEESQU"] [cl-struct-plansys 7 154 2 1 9 40 12800 5639 [cl-struct-fastseedtype 13 730887 32 -26533888] "MAINON"] [cl-struct-plansys 247 127 7 0 3 20 1920 3575 [cl-struct-fastseedtype 5 686583 234 92465664] "XEEDEN"] [cl-struct-plansys 238 114 2 1 8 36 11520 5614 [cl-struct-fastseedtype 201 664814 168 73050112] "QUTECETE"] [cl-struct-plansys 28 5 7 1 1 13 1560 6428 [cl-struct-fastseedtype 201 991004 234 -102831616] "RILEISIS"] [cl-struct-plansys 221 253 5 2 4 24 5760 6109 [cl-struct-fastseedtype 149 231645 64 131874816] "TETIER"] [cl-struct-plansys 4 112 0 3 9 40 22400 5636 [cl-struct-fastseedtype 29 827908 250 -64226816] "MAATIS"] [cl-struct-plansys 157 209 1 6 10 48 34560 6813 [cl-struct-fastseedtype 241 770461 232 118482944] "ARIIN"] [cl-struct-plansys 187 44 6 0 4 23 2944 4795 [cl-struct-fastseedtype 129 263355 26 40311296] "SOAAT"] [cl-struct-plansys 40 113 1 3 8 37 18648 5160 [cl-struct-fastseedtype 93 237096 160 -102129664] "ESGELAGE"] [cl-struct-plansys 3 149 5 6 8 44 17600 6147 [cl-struct-fastseedtype 117 500995 74 1919488] "ISVETIMA"] [cl-struct-plansys 171 215 7 3 5 31 5208 5291 [cl-struct-fastseedtype 89 668331 104 87648256] "ORTEVE"] [cl-struct-plansys 150 160 0 7 13 60 52800 3734 [cl-struct-fastseedtype 121 656534 138 66292224] "BEARRABE"] [cl-struct-plansys 211 180 4 4 8 41 15744 3795 [cl-struct-fastseedtype 101 578771 64 95633408] "BEANXEAT"] [cl-struct-plansys 177 194 2 1 7 32 10240 6577 [cl-struct-fastseedtype 13 880305 218 128899584] "REXEXE"] [cl-struct-plansys 83 130 2 0 8 35 8960 4691 [cl-struct-fastseedtype 1 650835 40 83306496] "TIINVE"] [cl-struct-plansys 217 22 6 6 5 33 10560 6105 [cl-struct-fastseedtype 177 605145 58 45890048] "TEINXEAR"] [cl-struct-plansys 170 66 2 5 10 48 27648 5290 [cl-struct-fastseedtype 173 305322 32 -23519232] "ORCEES"] [cl-struct-plansys 232 201 1 4 8 38 21888 5096 [cl-struct-fastseedtype 229 743656 170 54045184] "EDMAINER"] [cl-struct-plansys 48 12 4 5 6 34 14688 5168 [cl-struct-fastseedtype 233 874800 40 -14080000] "ESBILEAT"] [cl-struct-plansys 81 193 1 5 10 47 30456 5201 [cl-struct-fastseedtype 41 14929 42 91826688] "ORMALA"] [cl-struct-plansys 90 85 5 6 7 40 16000 5722 [cl-struct-fastseedtype 53 39002 64 -80003072] "ANMA"] [cl-struct-plansys 166 128 0 7 13 60 52800 3494 [cl-struct-fastseedtype 253 329894 186 101890560] "ENQURA"] [cl-struct-plansys 65 244 4 2 5 27 7776 6721 [cl-struct-fastseedtype 17 693057 104 7301120] "AZARA"] [cl-struct-plansys 104 84 4 4 5 29 11136 3432 [cl-struct-fastseedtype 225 923496 90 -27108864] "XEMADI"] [cl-struct-plansys 109 235 3 7 9 47 28952 5229 [cl-struct-fastseedtype 253 322157 160 108634112] "ORBEQUSO"] [cl-struct-plansys 7 186 2 2 9 41 15744 4103 [cl-struct-fastseedtype 85 465671 10 -7009792] "LATIBE"] [cl-struct-plansys 223 243 3 7 11 55 33880 5343 [cl-struct-fastseedtype 121 316639 232 -97916928] "ESTEBIIN"] [cl-struct-plansys 44 6 6 3 3 22 4928 6700 [cl-struct-fastseedtype 217 890668 202 70240768] "AXEON"] [cl-struct-plansys 82 191 7 0 2 16 1536 3922 [cl-struct-fastseedtype 5 311890 64 7618560] "RACEMACE"] [cl-struct-plansys 69 75 3 5 8 41 20664 4677 [cl-struct-fastseedtype 237 860741 154 68655616] "TIESSOUS"] [cl-struct-plansys 200 7 7 4 2 20 3840 5064 [cl-struct-fastseedtype 33 383944 168 58238976] "EDSOUS"] [cl-struct-plansys 73 136 0 2 9 39 18720 5193 [cl-struct-fastseedtype 17 450377 122 -82216448] "ORMADI"] [cl-struct-plansys 82 77 7 1 3 21 2520 5714 [cl-struct-fastseedtype 77 394578 32 -7659520] "MAMAUS"] [cl-struct-plansys 190 8 2 0 7 31 7936 3518 [cl-struct-fastseedtype 197 684734 106 99772928] "ENORAR"] [cl-struct-plansys 23 106 2 1 9 40 12800 5655 [cl-struct-fastseedtype 9 518167 168 -96753664] "ANISERES"] [cl-struct-plansys 9 16 2 1 7 32 10240 4617 [cl-struct-fastseedtype 137 80905 106 -36214272] "TIATENQU"] [cl-struct-plansys 154 210 2 2 8 37 14208 6554 [cl-struct-fastseedtype 213 1019802 64 22953984] "RIMAZA"] [cl-struct-plansys 237 196 4 3 6 32 10752 6381 [cl-struct-fastseedtype 221 606189 122 -25331200] "ISAANUS"] [cl-struct-plansys 72 155 3 6 7 38 21280 3400 [cl-struct-fastseedtype 49 313672 232 68347904] "ENVEAT"] [cl-struct-plansys 90 81 3 0 6 28 6272 3162 [cl-struct-fastseedtype 65 161114 154 111254016] "LEDIUS"] [cl-struct-plansys 55 72 0 3 12 52 29120 6199 [cl-struct-fastseedtype 157 801079 160 -70410240] "DIREBEA"] [cl-struct-plansys 111 83 3 6 10 50 28000 2927 [cl-struct-fastseedtype 53 493935 202 118540800] "ERBEBETI"] [cl-struct-plansys 55 83 3 3 9 43 16856 6455 [cl-struct-fastseedtype 153 162615 104 -10590208] "RIESONSO"] [cl-struct-plansys 199 127 7 7 7 43 11352 3015 [cl-struct-fastseedtype 57 865223 10 -131069440] "ERVEDIRA"] [cl-struct-plansys 20 109 5 4 4 26 8320 5140 [cl-struct-fastseedtype 165 338708 64 -33996800] "ORANESRI"] [cl-struct-plansys 254 137 3 1 7 33 9240 4094 [cl-struct-fastseedtype 205 874494 90 33839616] "ZAINER"] [cl-struct-plansys 33 144 2 0 6 27 6912 6433 [cl-struct-fastseedtype 65 643873 40 71182336] "RIARE"] [cl-struct-plansys 124 78 6 6 4 29 9280 5500 [cl-struct-fastseedtype 113 259452 186 112900608] "QUBIISIS"] [cl-struct-plansys 253 189 5 5 6 35 12600 3325 [cl-struct-fastseedtype 237 656381 32 21045248] "LETEAN"] [cl-struct-plansys 120 59 3 4 6 32 14336 2936 [cl-struct-fastseedtype 165 772728 42 61876736] "ERZAINLE"] [cl-struct-plansys 161 140 4 5 7 38 16416 3489 [cl-struct-fastseedtype 41 507041 40 93464576] "ENBECE"] [cl-struct-plansys 69 243 3 5 8 41 20664 5189 [cl-struct-fastseedtype 233 660293 170 16361984] "ORBEEN"] [cl-struct-plansys 159 114 2 6 11 53 33920 4255 [cl-struct-fastseedtype 117 85407 64 -96124928] "CETITE"] [cl-struct-plansys 216 60 4 7 7 40 21120 6104 [cl-struct-fastseedtype 189 553688 58 -76793344] "INLEBI"] [cl-struct-plansys 179 198 6 2 5 29 5568 5555 [cl-struct-fastseedtype 81 886451 104 33187840] "QUBELE"] [cl-struct-plansys 143 33 1 4 11 50 28800 3983 [cl-struct-fastseedtype 161 21903 218 -115025408] "ZALAARCE"] [cl-struct-plansys 133 138 2 7 10 50 35200 4229 [cl-struct-fastseedtype 61 1032581 160 -102391808] "CELAAN"] [cl-struct-plansys 59 96 0 2 11 47 22560 2875 [cl-struct-fastseedtype 21 820027 138 -57636352] "ERMATI"] [cl-struct-plansys 179 247 7 7 7 43 11352 4531 [cl-struct-fastseedtype 185 573619 232 81192960] "VEXEINCE"] [cl-struct-plansys 101 12 4 3 6 32 10752 3941 [cl-struct-fastseedtype 153 956773 74 -34321920] "RABI"] [cl-struct-plansys 27 192 2 0 8 35 8960 3355 [cl-struct-fastseedtype 69 581147 64 -29212672] "XEISANAN"] [cl-struct-plansys 219 123 3 5 10 49 24696 4315 [cl-struct-fastseedtype 173 215771 26 125114880] "LAINISRI"] [cl-struct-plansys 94 29 5 4 6 34 10880 4702 [cl-struct-fastseedtype 97 993118 168 122136576] "SOGEES"] [cl-struct-plansys 115 105 1 2 10 44 19008 6771 [cl-struct-fastseedtype 209 1395 250 60815872] "ONTEER"] [cl-struct-plansys 173 144 2 1 7 32 10240 5805 [cl-struct-fastseedtype 141 1002413 32 62595072] "ANORXE"] [cl-struct-plansys 22 98 2 0 7 31 7936 3094 [cl-struct-fastseedtype 133 492310 234 41019904] "ATAREN"] [cl-struct-plansys 207 114 2 1 9 40 12800 6095 [cl-struct-fastseedtype 73 991695 168 19703808] "INREARBI"] [cl-struct-plansys 6 106 2 1 8 36 11520 6662 [cl-struct-fastseedtype 73 741126 234 -52434432] "ONERTIUS"] [cl-struct-plansys 104 55 7 2 1 14 2016 2920 [cl-struct-fastseedtype 21 1020264 64 99631104] "ERASO"] [cl-struct-plansys 103 231 7 3 5 31 5208 6503 [cl-struct-fastseedtype 157 191591 250 48167424] "RIRELAXE"] [cl-struct-plansys 130 117 5 6 7 40 16000 4226 [cl-struct-fastseedtype 113 609922 232 -98179072] "CEISCE"] [cl-struct-plansys 9 197 7 0 1 12 1152 5897 [cl-struct-fastseedtype 1 298761 26 65804800] "INQUA"] [cl-struct-plansys 86 175 7 3 4 27 4536 3158 [cl-struct-fastseedtype 221 236118 160 12689408] "LEUSAR"] [cl-struct-plansys 106 224 0 6 12 55 44000 3946 [cl-struct-fastseedtype 245 506730 74 101992960] "RAONBE"] [cl-struct-plansys 83 223 7 3 5 31 5208 3667 [cl-struct-fastseedtype 217 761939 104 -91002880] "BEBIDISO"] [cl-struct-plansys 7 173 5 7 9 49 21560 5895 [cl-struct-fastseedtype 249 665351 138 58493440] "TEENVECE"] [cl-struct-plansys 101 182 6 4 4 27 6912 6757 [cl-struct-fastseedtype 229 100965 64 21970944] "AINLETE"] [cl-struct-plansys 220 33 3 1 5 25 7000 5340 [cl-struct-fastseedtype 141 1005020 218 -93726208] "ESSORE"] [cl-struct-plansys 127 174 6 0 4 23 2944 4223 [cl-struct-fastseedtype 129 691071 40 -57333760] "LAXETI"] [cl-struct-plansys 47 215 7 6 6 38 9120 5167 [cl-struct-fastseedtype 49 144943 58 -3589632] "ESAUSLE"] [cl-struct-plansys 97 200 0 5 11 50 36000 5217 [cl-struct-fastseedtype 45 811873 32 116989952] "ORXETE"] [cl-struct-plansys 152 124 4 4 5 29 11136 4760 [cl-struct-fastseedtype 101 909208 170 -130569728] "TIINTELE"] [cl-struct-plansys 161 28 4 5 7 38 16416 5793 [cl-struct-fastseedtype 105 574113 40 -49600512] "MAESVEAR"] [cl-struct-plansys 74 118 6 5 6 36 10368 5450 [cl-struct-fastseedtype 169 138826 42 -7722496] "ARARON"] [cl-struct-plansys 244 31 7 6 3 26 6240 6900 [cl-struct-fastseedtype 181 63988 64 73351168] "ONBESO"] [cl-struct-plansys 154 199 7 7 6 39 10296 4250 [cl-struct-fastseedtype 125 923546 186 -86656512] "LATIUS"] [cl-struct-plansys 181 168 0 2 9 39 18720 4277 [cl-struct-fastseedtype 145 132021 104 -57317376] "LABEIS"] [cl-struct-plansys 198 61 5 4 6 34 10880 4806 [cl-struct-fastseedtype 97 891078 90 83319296] "TIANORIN"] [cl-struct-plansys 172 185 1 7 10 49 38808 3244 [cl-struct-fastseedtype 125 899756 160 6397952] "LESOLARI"] [cl-struct-plansys 254 213 5 2 5 28 6720 6142 [cl-struct-fastseedtype 213 853246 10 -107214336] "TEERMA"] [cl-struct-plansys 23 11 3 7 11 55 33880 3607 [cl-struct-fastseedtype 249 95511 232 9693184] "BETIGERE"] [cl-struct-plansys 174 99 3 3 8 39 15288 5038 [cl-struct-fastseedtype 89 973742 202 113822208] "USQUAT"] [cl-struct-plansys 244 81 3 0 4 20 4480 3060 [cl-struct-fastseedtype 133 507636 64 119554048] "BIQULE"] [cl-struct-plansys 1 122 2 5 9 44 25344 3329 [cl-struct-fastseedtype 109 62465 154 14850560] "XEONGEZA"] [cl-struct-plansys 132 67 3 4 6 32 14336 4484 [cl-struct-fastseedtype 161 4740 168 69642240] "BIREOR"] [cl-struct-plansys 174 153 1 2 9 40 17280 4526 [cl-struct-fastseedtype 145 872110 122 -113870336] "VERIGE"] [cl-struct-plansys 24 99 3 1 5 25 7000 5656 [cl-struct-fastseedtype 205 242200 32 -84205568] "ANTIMA"] [cl-struct-plansys 254 139 3 0 6 28 6272 3326 [cl-struct-fastseedtype 69 738046 106 -83793408] "LEMAAR"] [cl-struct-plansys 23 138 2 1 9 40 12800 6167 [cl-struct-fastseedtype 137 764439 168 -114448384] "DIERLABE"] [cl-struct-plansys 19 21 7 1 4 25 3000 4883 [cl-struct-fastseedtype 9 806931 106 116943360] "EDINCE"] [cl-struct-plansys 69 44 4 2 5 27 7776 3397 [cl-struct-fastseedtype 85 853573 64 93470720] "ENGEAN"] [cl-struct-plansys 113 219 3 3 7 35 13720 2929 [cl-struct-fastseedtype 93 556913 122 -112166400] "ERISONIN"] [cl-struct-plansys 76 95 7 6 3 26 6240 4940 [cl-struct-fastseedtype 177 715084 232 -112662528] "USRAAR"] [cl-struct-plansys 199 138 2 0 8 35 8960 4551 [cl-struct-fastseedtype 193 1018311 154 -96036352] "BIEDBI"] [cl-struct-plansys 134 166 6 3 5 30 6720 4230 [cl-struct-fastseedtype 29 653702 160 -121266176] "CEENRIVE"] [cl-struct-plansys 246 62 6 6 6 37 11840 4854 [cl-struct-fastseedtype 181 414454 202 -47724032] "SOTEAN"] [cl-struct-plansys 0 123 3 3 6 31 12152 4864 [cl-struct-fastseedtype 25 457216 104 114845696] "EDBEINED"] [cl-struct-plansys 88 44 4 7 7 40 21120 5208 [cl-struct-fastseedtype 185 415320 10 98109952] "ORRIASO"] [cl-struct-plansys 199 143 7 4 5 32 6144 4295 [cl-struct-fastseedtype 37 977607 64 -4898816] "LAINUSAR"] [cl-struct-plansys 74 136 2 1 8 36 11520 6730 [cl-struct-fastseedtype 77 704586 90 14637568] "ONENTE"] [cl-struct-plansys 109 220 6 0 2 15 1920 5997 [cl-struct-fastseedtype 193 470893 40 -33806336] "TECEA"] [cl-struct-plansys 241 175 7 6 4 30 7200 4849 [cl-struct-fastseedtype 241 243185 186 -35145216] "SOESGERA"] [cl-struct-plansys 212 99 3 5 7 37 18648 3284 [cl-struct-fastseedtype 109 491220 32 -4120576] "LEEDRE"] [cl-struct-plansys 72 142 6 4 3 23 5888 6728 [cl-struct-fastseedtype 37 798792 42 13576704] "ACETEAT"] [cl-struct-plansys 49 188 4 5 7 38 16416 3889 [cl-struct-fastseedtype 169 1000241 40 93595648] "RAXEUSON"] [cl-struct-plansys 95 72 0 5 13 58 41760 5471 [cl-struct-fastseedtype 105 807775 170 19573248] "ARENTE"] [cl-struct-plansys 89 92 4 6 7 39 18720 5209 [cl-struct-fastseedtype 245 5465 64 -108445696] "ESONGE"] [cl-struct-plansys 236 35 3 7 8 43 26488 6892 [cl-struct-fastseedtype 61 904940 58 72301056] "ARIQU"] [cl-struct-plansys 71 154 2 2 9 41 15744 2887 [cl-struct-fastseedtype 209 303687 104 4220928] "XEAR"] [cl-struct-plansys 13 170 2 4 8 39 19968 5133 [cl-struct-fastseedtype 33 530701 218 31054336] "ORATEDGE"] [cl-struct-plansys 227 120 0 7 14 64 56320 6371 [cl-struct-fastseedtype 189 921059 160 -101867520] "DIESANEN"] [cl-struct-plansys 82 27 3 2 7 34 11424 4690 [cl-struct-fastseedtype 149 505938 138 112691712] "TICEA"] [cl-struct-plansys 12 47 7 7 4 31 8184 2828 [cl-struct-fastseedtype 57 215564 232 -43980800] "TEESSO"] [cl-struct-plansys 7 9 1 3 11 49 24696 6151 [cl-struct-fastseedtype 25 579079 74 -22197760] "DIRIEN"] [cl-struct-plansys 221 114 2 0 6 27 6912 6621 [cl-struct-fastseedtype 197 613597 64 -82952192] "RERIARTI"] [cl-struct-plansys 183 74 2 5 11 52 29952 2999 [cl-struct-fastseedtype 45 423351 26 6298112] "LEORQU"] [cl-struct-plansys 58 121 1 4 10 46 26496 4154 [cl-struct-fastseedtype 225 963898 168 -99244032] "LAESQU"] [cl-struct-plansys 249 26 2 2 7 33 12672 6137 [cl-struct-fastseedtype 81 750329 250 -69404160] "TEERBI"] [cl-struct-plansys 148 198 6 1 2 16 2560 5780 [cl-struct-fastseedtype 13 913556 32 88809472] "MACECE"] [cl-struct-plansys 118 133 7 0 2 16 1536 2934 [cl-struct-fastseedtype 5 84598 234 -6231552] "ANEN"] [cl-struct-plansys 239 178 2 1 9 40 12800 6639 [cl-struct-fastseedtype 201 1005807 168 37660672] "RILEAA"] [cl-struct-plansys 47 15 7 1 4 25 3000 2863 [cl-struct-fastseedtype 201 866095 234 -64951808] "ATEN"] [cl-struct-plansys 50 177 1 2 9 40 17280 3890 [cl-struct-fastseedtype 149 1009202 64 4472832] "ZAUSRI"] [cl-struct-plansys 11 158 6 3 6 34 7616 3083 [cl-struct-fastseedtype 29 708875 250 30538240] "ATANORBI"] [cl-struct-plansys 166 89 1 6 11 52 37440 5798 [cl-struct-fastseedtype 241 78246 232 24897536] "ANANRI"] [cl-struct-plansys 150 158 6 0 3 19 2432 3222 [cl-struct-fastseedtype 129 171414 26 -105833984] "ATBIDI"] [cl-struct-plansys 197 45 5 3 5 29 8120 5317 [cl-struct-fastseedtype 93 888517 160 64593920] "ORINMAEN"] [cl-struct-plansys 18 107 3 6 9 46 25760 5650 [cl-struct-fastseedtype 117 223250 74 -62174720] "MAESSOTE"] [cl-struct-plansys 60 39 7 3 2 19 3192 6204 [cl-struct-fastseedtype 89 778300 104 70084608] "DIATQUOR"] [cl-struct-plansys 185 250 2 7 10 50 35200 4281 [cl-struct-fastseedtype 121 80313 138 -12219904] "CEOREDED"] [cl-struct-plansys 56 248 0 4 9 41 26240 5688 [cl-struct-fastseedtype 101 803896 64 -114606080] "MATEUS"] [cl-struct-plansys 72 192 2 1 6 28 8960 3912 [cl-struct-fastseedtype 13 585544 218 90495488] "ZADIQU"] [cl-struct-plansys 236 26 2 0 5 23 5888 3820 [cl-struct-fastseedtype 1 55020 40 -126670848] "BEORED"] [cl-struct-plansys 196 216 0 6 10 47 37600 4548 [cl-struct-fastseedtype 177 142532 58 18233856] "VEBERETI"] [cl-struct-plansys 87 142 6 5 7 40 11520 5207 [cl-struct-fastseedtype 173 331351 32 -73850880] "ORRIA"] [cl-struct-plansys 135 111 7 4 5 32 6144 4487 [cl-struct-fastseedtype 229 218247 170 -42554880] "VEREINAT"] [cl-struct-plansys 81 108 4 5 7 38 16416 6225 [cl-struct-fastseedtype 233 5713 40 -13817856] "DIMAMAZA"] [cl-struct-plansys 132 107 3 5 7 37 18648 5764 [cl-struct-fastseedtype 41 436868 42 98249216] "ANARES"] [cl-struct-plansys 207 41 1 6 12 56 40320 3791 [cl-struct-fastseedtype 53 858063 64 -104644608] "GETERE"] [cl-struct-plansys 205 78 6 7 6 38 13376 5069 [cl-struct-fastseedtype 253 94413 186 131643904] "EDLATE"] [cl-struct-plansys 106 156 4 2 6 31 8928 5738 [cl-struct-fastseedtype 17 522858 104 -50632704] "ANLEBI"] [cl-struct-plansys 99 102 6 4 6 35 8960 5987 [cl-struct-fastseedtype 225 790115 90 -3384832] "INTISOAR"] [cl-struct-plansys 42 199 7 7 6 39 10296 5162 [cl-struct-fastseedtype 253 914218 160 109682688] "ESTEERVE"] [cl-struct-plansys 54 48 0 2 10 43 20640 3638 [cl-struct-fastseedtype 85 898358 10 65210880] "GEARGE"] [cl-struct-plansys 144 99 3 7 8 43 26488 6288 [cl-struct-fastseedtype 121 563088 232 -79828992] "ISATA"] [cl-struct-plansys 111 0 0 3 12 52 29120 3183 [cl-struct-fastseedtype 217 65647 202 94489088] "LEATGE"] [cl-struct-plansys 215 35 3 0 7 32 7168 6103 [cl-struct-fastseedtype 5 241623 64 -99860480] "INBIESTE"] [cl-struct-plansys 252 233 1 5 9 43 27864 6396 [cl-struct-fastseedtype 237 403452 154 99457536] "DIRAONLE"] [cl-struct-plansys 129 191 7 4 3 24 4608 3969 [cl-struct-fastseedtype 33 468865 168 -116086784] "RARAAR"] [cl-struct-plansys 84 234 2 2 6 29 11136 3668 [cl-struct-fastseedtype 17 76372 122 -74221056] "BEENOR"] [cl-struct-plansys 31 185 3 1 8 37 10360 5663 [cl-struct-fastseedtype 77 442143 32 44769280] "MAZARE"] [cl-struct-plansys 125 78 6 0 2 15 1920 2941 [cl-struct-fastseedtype 197 471421 106 5270016] "ERTEAR"] [cl-struct-plansys 88 234 2 1 6 28 8960 6744 [cl-struct-fastseedtype 9 132696 168 -60839936] "ONXEQUTE"] [cl-struct-plansys 92 90 2 1 6 28 8960 5212 [cl-struct-fastseedtype 137 64604 106 -61249024] "ORERBIA"] [cl-struct-plansys 47 198 6 2 5 29 5568 4399 [cl-struct-fastseedtype 213 796975 64 101072896] "BITEEN"] [cl-struct-plansys 52 50 2 3 7 34 15232 3636 [cl-struct-fastseedtype 221 833844 122 -60589568] "GEARGEAT"] [cl-struct-plansys 145 99 3 6 8 42 23520 6545 [cl-struct-fastseedtype 49 638865 232 46065664] "RIBEGE"] [cl-struct-plansys 117 3 3 0 5 24 5376 5749 [cl-struct-fastseedtype 65 459381 154 36411904] "MAZAZA"] [cl-struct-plansys 20 68 4 3 5 28 9408 6164 [cl-struct-fastseedtype 157 692756 160 33398784] "ISTIESRI"] [cl-struct-plansys 190 105 1 6 11 52 37440 6590 [cl-struct-fastseedtype 53 70334 202 58640896] "RIBIGEUS"] [cl-struct-plansys 8 227 3 3 6 31 12152 3336 [cl-struct-fastseedtype 153 502536 104 43149312] "ENRIORAR"] [cl-struct-plansys 42 25 1 7 12 57 45144 3370 [cl-struct-fastseedtype 57 280874 10 -4060672] "XECEATOR"] [cl-struct-plansys 185 241 1 4 9 42 24192 3257 [cl-struct-fastseedtype 165 429753 64 -38715392] "ATTESOLA"] [cl-struct-plansys 213 199 7 1 2 17 2040 5589 [cl-struct-fastseedtype 205 342741 90 133847552] "QUTIUS"] [cl-struct-plansys 250 104 2 0 7 31 7936 5626 [cl-struct-fastseedtype 65 956922 40 -67491840] "QUTEER"] [cl-struct-plansys 167 80 0 6 13 59 47200 4007 [cl-struct-fastseedtype 113 86695 186 -111887872] "RADIESAR"] [cl-struct-plansys 234 73 1 5 11 51 33048 3306 [cl-struct-fastseedtype 237 838122 32 -92200960] "LELALE"] [cl-struct-plansys 87 33 1 4 11 50 28800 6487 [cl-struct-fastseedtype 165 123991 42 -30529024] "RESOINXE"] [cl-struct-plansys 2 44 4 5 8 42 18144 4354 [cl-struct-fastseedtype 41 398338 40 -103405568] "VECEISED"] [cl-struct-plansys 184 221 5 5 5 31 11160 5816 [cl-struct-fastseedtype 233 596920 170 -40130048] "ANENBI"] [cl-struct-plansys 84 134 6 6 4 29 9280 6228 [cl-struct-fastseedtype 117 293204 64 84754432] "DIUSAR"] [cl-struct-plansys 63 74 2 7 12 58 40832 3391 [cl-struct-fastseedtype 189 316735 58 91372032] "ENTERE"] [cl-struct-plansys 28 174 6 2 2 17 3264 4380 [cl-struct-fastseedtype 81 304156 104 46557184] "BIERBE"] [cl-struct-plansys 202 115 3 4 8 40 17920 6602 [cl-struct-fastseedtype 161 1028298 218 -19998208] "REINBIXE"] [cl-struct-plansys 130 166 6 7 7 42 14784 4226 [cl-struct-fastseedtype 61 565890 160 104177664] "LARIVEAR"] [cl-struct-plansys 170 22 6 2 4 25 4800 6570 [cl-struct-fastseedtype 21 136106 138 18778624] "RIRISO"] [cl-struct-plansys 164 167 7 7 4 31 8184 5540 [cl-struct-fastseedtype 185 112036 232 -97851392] "ARTIBIUS"] [cl-struct-plansys 232 70 6 3 3 22 4928 4584 [cl-struct-fastseedtype 153 381672 74 -72988160] "BILAZA"] [cl-struct-plansys 224 100 6 0 1 11 1408 5600 [cl-struct-fastseedtype 69 700384 64 68829184] "QURIOREN"] [cl-struct-plansys 210 89 1 5 11 51 33048 5842 [cl-struct-fastseedtype 173 287442 26 25893376] "MATILATI"] [cl-struct-plansys 87 21 5 4 7 38 12160 3671 [cl-struct-fastseedtype 97 754007 168 19113984] "GEERMA"] [cl-struct-plansys 190 11 3 2 7 34 11424 5310 [cl-struct-fastseedtype 209 994494 250 -128321024] "ORGETE"] [cl-struct-plansys 186 60 6 1 4 24 3840 5818 [cl-struct-fastseedtype 141 316858 32 52109312] "ANENUS"] [cl-struct-plansys 21 232 2 0 6 27 6912 6677 [cl-struct-fastseedtype 133 823317 234 -49288704] "ADIEN"] [cl-struct-plansys 80 50 2 1 6 28 8960 2896 [cl-struct-fastseedtype 73 100944 168 126920704] "ERBERAOR"] [cl-struct-plansys 153 244 6 1 3 20 3200 3225 [cl-struct-fastseedtype 73 300953 234 128051712] "LEAMAIS"] [cl-struct-plansys 61 107 3 2 6 30 10080 4925 [cl-struct-fastseedtype 21 444221 64 114835456] "EDLA"] [cl-struct-plansys 238 149 5 3 6 33 9240 4078 [cl-struct-fastseedtype 157 200686 250 -117114368] "ZAESISMA"] [cl-struct-plansys 11 125 5 6 8 44 17600 3083 [cl-struct-fastseedtype 113 535307 232 -49158144] "ATQUTI"] [cl-struct-plansys 100 183 7 0 0 8 768 4452 [cl-struct-fastseedtype 1 1044580 26 62265856] "VEATMA"] [cl-struct-plansys 115 235 3 3 9 43 16856 3187 [cl-struct-fastseedtype 221 736115 160 53583872] "ATATVEOR"] [cl-struct-plansys 249 54 6 6 5 33 10560 3577 [cl-struct-fastseedtype 245 223993 74 46287360] "XEBEAZA"] [cl-struct-plansys 100 175 7 3 2 19 3192 4708 [cl-struct-fastseedtype 217 897636 104 34039808] "SOANSOAR"] [cl-struct-plansys 170 135 7 7 6 39 10296 6570 [cl-struct-fastseedtype 249 195754 138 122587648] "RELEQUAR"] [cl-struct-plansys 74 122 2 4 9 43 22016 4682 [cl-struct-fastseedtype 229 574026 64 -45662208] "SODIONBE"] [cl-struct-plansys 243 159 7 1 4 25 3000 6899 [cl-struct-fastseedtype 141 850675 218 -123741696] "ONENBI"] [cl-struct-plansys 152 198 6 0 1 11 1408 3224 [cl-struct-fastseedtype 129 888984 40 -124704768] "ATAOR"] [cl-struct-plansys 154 25 1 6 11 52 37440 3738 [cl-struct-fastseedtype 49 974746 58 111360512] "GEVERARE"] [cl-struct-plansys 142 148 4 5 8 42 18144 5262 [cl-struct-fastseedtype 45 289166 32 -59170816] "ORANXE"] [cl-struct-plansys 183 162 2 4 10 47 24064 4279 [cl-struct-fastseedtype 101 554935 170 49654272] "LAATEXE"] [cl-struct-plansys 66 252 4 5 8 42 18144 6722 [cl-struct-fastseedtype 105 136258 40 93267968] "AREIS"] [cl-struct-plansys 253 160 0 5 11 50 36000 6141 [cl-struct-fastseedtype 169 368381 42 -127129088] "INESBE"] [cl-struct-plansys 233 115 3 6 8 42 23520 4841 [cl-struct-fastseedtype 181 45545 64 -77119488] "SOZALA"] [cl-struct-plansys 65 21 5 7 7 41 18040 5697 [cl-struct-fastseedtype 125 382017 186 -48514560] "ANENER"] [cl-struct-plansys 94 208 0 2 10 43 20640 3166 [cl-struct-fastseedtype 145 603998 104 27355136] "LEERA"] [cl-struct-plansys 65 207 7 4 3 24 4608 3137 [cl-struct-fastseedtype 97 211009 90 -18785792] "LEENLAES"] [cl-struct-plansys 233 21 5 7 7 41 18040 3305 [cl-struct-fastseedtype 125 480233 160 -118382592] "ATERMADI"] [cl-struct-plansys 173 203 3 2 6 30 10080 5549 [cl-struct-fastseedtype 213 650157 10 -26605056] "ARGEAN"] [cl-struct-plansys 72 251 3 7 8 43 26488 4680 [cl-struct-fastseedtype 249 326728 232 -98048000] "SOINISAT"] [cl-struct-plansys 113 221 5 3 5 29 8120 5489 [cl-struct-fastseedtype 89 1033585 202 12241408] "QUESLA"] [cl-struct-plansys 249 53 7 0 1 12 1152 5113 [cl-struct-fastseedtype 133 21753 64 -113754112] "EDSOEDED"] [cl-struct-plansys 56 152 0 5 10 46 33120 4920 [cl-struct-fastseedtype 109 491064 154 54041088] "EDARANIS"] [cl-struct-plansys 189 123 3 4 7 36 16128 3517 [cl-struct-fastseedtype 161 252605 168 37922816] "XEANAN"] [cl-struct-plansys 57 123 3 2 6 30 10080 2873 [cl-struct-fastseedtype 145 12857 122 36731392] "ERCEA"] [cl-struct-plansys 101 79 7 1 2 17 2040 5733 [cl-struct-fastseedtype 205 846949 32 110829568] "ANERAT"] [cl-struct-plansys 61 81 3 0 5 24 5376 6717 [cl-struct-fastseedtype 69 196157 106 98527744] "ONREAR"] [cl-struct-plansys 216 138 2 1 6 28 8960 3288 [cl-struct-fastseedtype 137 113880 168 64071680] "ATLAONBI"]] [[cl-struct-plansys 128 150 6 2 2 17 3264 6272 [cl-struct-fastseedtype 18 128 212 15586304] "DIZAEN"] [cl-struct-plansys 100 114 2 5 8 40 23040 5732 [cl-struct-fastseedtype 170 1636 128 -69500928] "ANENEN"] [cl-struct-plansys 128 242 2 7 9 46 32384 4224 [cl-struct-fastseedtype 186 18816 244 119927808] "CEOR"] [cl-struct-plansys 255 64 0 4 12 53 33920 5119 [cl-struct-fastseedtype 98 215295 208 -86454272] "EDEDER"] [cl-struct-plansys 225 240 2 0 6 27 6912 5601 [cl-struct-fastseedtype 130 366817 52 116012032] "ARTESORE"] [cl-struct-plansys 46 135 7 7 6 39 10296 3374 [cl-struct-fastseedtype 58 935982 64 -109953024] "ENUSUSGE"] [cl-struct-plansys 99 200 0 5 13 58 41760 3939 [cl-struct-fastseedtype 106 810851 148 89428992] "RAEDRE"] [cl-struct-plansys 14 56 0 6 12 55 44000 4622 [cl-struct-fastseedtype 50 334606 208 13094912] "SOREZAAN"] [cl-struct-plansys 187 228 4 6 9 47 22560 6843 [cl-struct-fastseedtype 114 282299 20 -55634944] "AAORED"] [cl-struct-plansys 184 185 3 1 5 25 7000 3256 [cl-struct-fastseedtype 74 346296 128 79790080] "LEBEDIXE"] [cl-struct-plansys 162 173 5 3 6 33 9240 3746 [cl-struct-fastseedtype 154 312482 180 75740160] "GEBEQUAT"] [cl-struct-plansys 81 250 2 0 6 27 6912 6737 [cl-struct-fastseedtype 130 208209 80 102715392] "ONARAN"] [cl-struct-plansys 101 219 3 4 7 36 16128 5989 [cl-struct-fastseedtype 226 4709 116 -22252544] "INRE"] [cl-struct-plansys 154 0 0 3 11 48 26880 5274 [cl-struct-fastseedtype 218 356762 64 76103680] "ESZAUSVE"] [cl-struct-plansys 246 72 2 1 8 36 11520 3830 [cl-struct-fastseedtype 74 1010422 84 23286784] "GEXEAN"] [cl-struct-plansys 1 251 3 2 6 30 10080 6657 [cl-struct-fastseedtype 82 320257 80 77549568] "ONTEISED"] [cl-struct-plansys 120 61 5 2 3 20 4800 3448 [cl-struct-fastseedtype 210 543096 84 -28158976] "ENUSBE"] [cl-struct-plansys 45 211 3 5 8 41 20664 5165 [cl-struct-fastseedtype 234 197165 128 101285888] "ESARXEVE"] [cl-struct-plansys 86 66 2 7 11 54 38016 3670 [cl-struct-fastseedtype 122 1010262 116 -22842368] "GETEVE"] [cl-struct-plansys 21 54 6 4 4 27 6912 4629 [cl-struct-fastseedtype 162 58901 208 -41431040] "SOBEER"] [cl-struct-plansys 204 112 2 0 5 23 5888 3020 [cl-struct-fastseedtype 66 653516 180 68203520] "ERDIARES"] [cl-struct-plansys 137 42 2 7 10 50 35200 3465 [cl-struct-fastseedtype 122 104841 64 -16629760] "XEVEXEAN"] [cl-struct-plansys 251 66 2 5 11 52 29952 4091 [cl-struct-fastseedtype 42 285435 20 116659200] "RAATBI"] [cl-struct-plansys 70 32 0 6 12 55 44000 4934 [cl-struct-fastseedtype 114 123206 208 -73871360] "EDONED"] [cl-struct-plansys 120 223 7 6 3 26 6240 4728 [cl-struct-fastseedtype 50 790136 148 22516736] "TIARICE"] [cl-struct-plansys 133 126 6 1 3 20 3200 3717 [cl-struct-fastseedtype 138 155781 128 -5013504] "BETIERTE"] [cl-struct-plansys 92 240 0 3 9 40 22400 4188 [cl-struct-fastseedtype 90 544604 52 -16436224] "CEENRAMA"] [cl-struct-plansys 11 180 6 0 4 23 2944 3339 [cl-struct-fastseedtype 194 219659 80 85086208] "ENENER"] [cl-struct-plansys 212 240 0 4 9 41 26240 4564 [cl-struct-fastseedtype 162 52180 244 43447296] "VEANSO"] [cl-struct-plansys 186 199 7 3 4 27 4536 6330 [cl-struct-fastseedtype 26 119738 64 81608704] "ISRIVEEN"] [cl-struct-plansys 50 246 6 1 4 24 3840 4402 [cl-struct-fastseedtype 10 749106 212 126276608] "BIRESO"] [cl-struct-plansys 157 103 7 2 2 18 2592 3997 [cl-struct-fastseedtype 146 502429 80 -38514688] "RAORMAOR"] [cl-struct-plansys 121 11 3 2 6 30 10080 6521 [cl-struct-fastseedtype 146 1003385 212 20894720] "RIGETE"] [cl-struct-plansys 127 124 4 5 9 46 19872 6783 [cl-struct-fastseedtype 42 667007 128 -104890368] "ONANORRA"] [cl-struct-plansys 116 249 1 7 10 49 38808 4980 [cl-struct-fastseedtype 58 273524 244 -14093312] "USVERA"] [cl-struct-plansys 243 52 4 4 8 41 15744 6643 [cl-struct-fastseedtype 226 7155 208 -121712640] "RIBIOR"] [cl-struct-plansys 63 153 3 0 7 32 7168 6719 [cl-struct-fastseedtype 2 16191 52 96416768] "ONTILAIN"] [cl-struct-plansys 236 149 5 7 6 37 16280 5612 [cl-struct-fastseedtype 186 487404 64 -98942976] "QUTEGEQU"] [cl-struct-plansys 90 163 3 5 9 45 22680 5722 [cl-struct-fastseedtype 234 206682 148 77304832] "ANQUERBI"] [cl-struct-plansys 198 144 0 6 12 55 44000 3270 [cl-struct-fastseedtype 178 532422 208 -84815872] "ATESLETE"] [cl-struct-plansys 60 1 1 6 9 44 31680 4924 [cl-struct-fastseedtype 242 37436 20 -108522496] "USBIMAQU"] [cl-struct-plansys 218 139 3 1 7 33 9240 6362 [cl-struct-fastseedtype 202 134874 128 70090752] "DIRATERI"] [cl-struct-plansys 94 156 4 3 7 36 12096 6494 [cl-struct-fastseedtype 26 106078 180 -124865536] "REESVERE"] [cl-struct-plansys 142 118 6 0 3 19 2432 6286 [cl-struct-fastseedtype 2 830094 80 -57847808] "DIATIN"] [cl-struct-plansys 203 172 4 4 8 41 15744 5323 [cl-struct-fastseedtype 98 359115 116 -116820992] "ESLEVE"] [cl-struct-plansys 225 86 6 3 4 26 5824 5345 [cl-struct-fastseedtype 90 866785 64 -88522752] "ORERMALA"] [cl-struct-plansys 53 139 3 1 6 29 8120 3381 [cl-struct-fastseedtype 202 625973 84 -5090304] "ENBEAN"] [cl-struct-plansys 129 91 3 2 6 30 10080 3201 [cl-struct-fastseedtype 210 44417 80 -78557184] "ATREXEXE"] [cl-struct-plansys 130 2 2 2 8 37 14208 3714 [cl-struct-fastseedtype 82 290946 84 95638528] "BETIDI"] [cl-struct-plansys 88 109 5 5 5 31 11160 6232 [cl-struct-fastseedtype 106 902744 128 117276672] "ISGEOROR"] [cl-struct-plansys 217 25 1 7 11 53 41976 4569 [cl-struct-fastseedtype 250 943577 116 79066112] "VEESQU"] [cl-struct-plansys 154 58 2 4 9 43 22016 6298 [cl-struct-fastseedtype 34 503962 208 -58863616] "ISENES"] [cl-struct-plansys 57 105 3 0 5 24 5376 4153 [cl-struct-fastseedtype 194 678457 180 133542912] "LAORUSTI"] [cl-struct-plansys 87 200 0 7 14 64 56320 5463 [cl-struct-fastseedtype 250 440663 64 -88457216] "QUANDIXE"] [cl-struct-plansys 130 237 5 5 7 39 14040 5762 [cl-struct-fastseedtype 170 354946 20 -95742976] "MAANUSRE"] [cl-struct-plansys 142 136 0 6 12 55 44000 3470 [cl-struct-fastseedtype 242 494734 208 -19738624] "ENARINES"] [cl-struct-plansys 9 76 4 6 7 39 18720 2825 [cl-struct-fastseedtype 178 317449 148 21009408] "VEED"] [cl-struct-plansys 184 224 2 1 6 28 8960 6840 [cl-struct-fastseedtype 10 29112 128 36667392] "AUSASO"] [cl-struct-plansys 167 175 7 3 5 31 5208 2983 [cl-struct-fastseedtype 218 305063 52 -48221184] "EDED"] [cl-struct-plansys 216 64 2 0 5 23 5888 3032 [cl-struct-fastseedtype 66 672984 80 -57651200] "ERUSAT"] [cl-struct-plansys 74 17 1 4 10 46 26496 3658 [cl-struct-fastseedtype 34 568650 244 -33295360] "GEONDI"] [cl-struct-plansys 16 173 5 3 4 25 7000 6160 [cl-struct-fastseedtype 154 487952 64 102580224] "ISANESLE"] [cl-struct-plansys 1 9 3 1 6 29 8120 4097 [cl-struct-fastseedtype 138 495105 212 98948096] "CEERTI"] [cl-struct-plansys 174 215 7 2 3 22 3168 4526 [cl-struct-fastseedtype 18 65966 80 -42577920] "VETEBE"] [cl-struct-plansys 147 32 0 2 11 47 22560 6803 [cl-struct-fastseedtype 18 543379 212 128963584] "AGEBI"] [cl-struct-plansys 185 166 6 5 5 32 9216 3769 [cl-struct-fastseedtype 170 510649 128 -37519360] "GEGESO"] [cl-struct-plansys 135 160 0 7 14 64 56320 5767 [cl-struct-fastseedtype 186 11399 244 -78908416] "MARAUS"] [cl-struct-plansys 8 72 0 4 9 41 26240 3848 [cl-struct-fastseedtype 98 76296 208 -121319424] "ZALAXE"] [cl-struct-plansys 188 226 2 0 5 23 5888 4028 [cl-struct-fastseedtype 130 358332 52 112473088] "RABEGEMA"] [cl-struct-plansys 203 195 3 7 11 55 33880 3531 [cl-struct-fastseedtype 58 140235 64 14827520] "XEATRIEN"] [cl-struct-plansys 114 30 6 5 6 36 10368 3442 [cl-struct-fastseedtype 106 264818 148 67277824] "XEBEUSON"] [cl-struct-plansys 159 8 0 6 13 59 47200 5791 [cl-struct-fastseedtype 50 826783 208 121360384] "ANGERIRI"] [cl-struct-plansys 222 190 6 6 6 37 11840 3294 [cl-struct-fastseedtype 114 73182 20 75568128] "LERIISIS"] [cl-struct-plansys 29 125 7 1 2 17 2040 5149 [cl-struct-fastseedtype 74 1009437 128 -105283584] "ORRAMAOR"] [cl-struct-plansys 57 43 3 3 7 35 13720 5177 [cl-struct-fastseedtype 154 762169 180 -122047488] "ORRIENAR"] [cl-struct-plansys 234 18 2 0 7 31 7936 5866 [cl-struct-fastseedtype 130 921322 80 85676032] "ANTIIS"] [cl-struct-plansys 80 29 5 4 4 26 8320 4432 [cl-struct-fastseedtype 226 274768 116 -41520128] "BILAIN"] [cl-struct-plansys 71 204 4 3 8 40 13440 5191 [cl-struct-fastseedtype 218 2631 64 118046720] "ESISRELA"] [cl-struct-plansys 149 110 6 1 3 20 3200 3221 [cl-struct-fastseedtype 74 226965 84 102847488] "LECEAN"] [cl-struct-plansys 34 219 3 2 7 34 11424 3618 [cl-struct-fastseedtype 82 687394 80 69423104] "GELESOMA"] [cl-struct-plansys 171 103 7 2 4 26 3744 4011 [cl-struct-fastseedtype 210 310187 84 53761024] "RASOSO"] [cl-struct-plansys 162 39 7 5 5 33 7128 3234 [cl-struct-fastseedtype 234 784546 128 -32407552] "ATANERIS"] [cl-struct-plansys 125 144 0 7 12 56 49280 5245 [cl-struct-fastseedtype 122 382589 116 -18254848] "ESTIRI"] [cl-struct-plansys 62 94 6 4 5 31 7936 3646 [cl-struct-fastseedtype 162 52798 208 -40644608] "BEERXE"] [cl-struct-plansys 199 2 2 0 8 35 8960 5575 [cl-struct-fastseedtype 66 132551 180 -33901568] "QUZABIBI"] [cl-struct-plansys 70 134 6 7 7 42 14784 3398 [cl-struct-fastseedtype 122 7494 64 -57524224] "ENONEDAR"] [cl-struct-plansys 42 56 0 5 12 54 38880 3370 [cl-struct-fastseedtype 42 797994 20 -37612544] "XEZAERTI"] [cl-struct-plansys 247 16 0 6 13 59 47200 6135 [cl-struct-fastseedtype 114 559351 208 70045696] "INLAORAN"] [cl-struct-plansys 187 89 1 6 12 56 40320 5307 [cl-struct-fastseedtype 50 713147 148 -11955200] "ESRIXEAR"] [cl-struct-plansys 10 98 2 1 8 36 11520 5642 [cl-struct-fastseedtype 138 953610 128 -87326720] "MAEDREBE"] [cl-struct-plansys 19 14 6 3 6 34 7616 5651 [cl-struct-fastseedtype 90 983315 52 123417600] "ANISINZA"] [cl-struct-plansys 196 236 6 0 1 11 1408 6596 [cl-struct-fastseedtype 194 569028 80 103698432] "REONEN"] [cl-struct-plansys 223 210 2 4 10 47 24064 3039 [cl-struct-fastseedtype 162 595167 244 59831296] "ERXEBE"] [cl-struct-plansys 135 179 3 3 9 43 16856 6279 [cl-struct-fastseedtype 26 938119 64 -42123264] "ISTITEAT"] [cl-struct-plansys 241 188 6 1 3 20 3200 4081 [cl-struct-fastseedtype 10 232689 212 -60500992] "ZAATSO"] [cl-struct-plansys 222 103 7 2 3 22 3168 5086 [cl-struct-fastseedtype 146 505310 80 -10989568] "EDRILAIN"] [cl-struct-plansys 204 213 5 2 3 20 4800 3020 [cl-struct-fastseedtype 146 319948 212 71357440] "XEER"] [cl-struct-plansys 20 240 0 5 10 46 33120 4628 [cl-struct-fastseedtype 42 1035796 128 132612096] "SOINSOAN"] [cl-struct-plansys 187 231 7 7 7 43 11352 6587 [cl-struct-fastseedtype 58 915899 244 -74517504] "REATTE"] [cl-struct-plansys 60 124 4 4 5 29 11136 5436 [cl-struct-fastseedtype 226 893756 208 -85274624] "ARGEMA"] [cl-struct-plansys 90 203 3 0 6 28 6272 5210 [cl-struct-fastseedtype 2 766554 52 -104254464] "ESREATES"] [cl-struct-plansys 201 17 1 7 11 53 41976 5577 [cl-struct-fastseedtype 186 185289 64 -37076992] "ARCEORES"] [cl-struct-plansys 169 57 1 5 10 47 30456 5289 [cl-struct-fastseedtype 234 473257 148 59347968] "ESDITI"] [cl-struct-plansys 151 160 0 6 13 59 47200 4247 [cl-struct-fastseedtype 178 607383 208 94752768] "CERIANON"] [cl-struct-plansys 159 27 3 6 10 50 28000 5535 [cl-struct-fastseedtype 242 844191 20 -40233984] "QULAAON"] [cl-struct-plansys 127 143 7 1 4 25 3000 4223 [cl-struct-fastseedtype 202 213375 128 90537984] "CELAQULA"] [cl-struct-plansys 53 90 2 3 8 38 17024 3893 [cl-struct-fastseedtype 26 884021 180 84194304] "ZARARESO"] [cl-struct-plansys 103 206 6 0 4 23 2944 5223 [cl-struct-fastseedtype 2 100967 80 -3584000] "ESRIRE"] [cl-struct-plansys 246 46 6 4 5 31 7936 3830 [cl-struct-fastseedtype 98 501238 116 -64785408] "GEUSXE"] [cl-struct-plansys 206 98 2 3 9 42 18816 5326 [cl-struct-fastseedtype 90 611022 64 -109494272] "ORESATRA"] [cl-struct-plansys 20 241 3 1 5 25 7000 2836 [cl-struct-fastseedtype 202 939796 84 78664704] "ERVEAN"] [cl-struct-plansys 226 123 3 2 7 34 11424 4322 [cl-struct-fastseedtype 210 262626 80 -15380480] "LABEINLA"] [cl-struct-plansys 245 108 4 2 5 27 7776 4341 [cl-struct-fastseedtype 82 858869 84 114643968] "LAVELE"] [cl-struct-plansys 13 1 1 5 10 47 30456 4109 [cl-struct-fastseedtype 106 166157 128 -79331328] "CERASO"] [cl-struct-plansys 64 167 7 7 4 31 8184 5952 [cl-struct-fastseedtype 250 93248 116 -46369792] "TEZAXE"] [cl-struct-plansys 3 162 2 4 10 47 24064 5123 [cl-struct-fastseedtype 34 618243 208 13225984] "ESAAN"] [cl-struct-plansys 116 59 3 0 4 20 4480 6772 [cl-struct-fastseedtype 194 93044 180 102740992] "ONERZARA"] [cl-struct-plansys 84 100 4 7 7 40 21120 5460 [cl-struct-fastseedtype 250 13652 64 76169216] "ARZAGEAT"] [cl-struct-plansys 241 35 3 5 8 41 20664 5361 [cl-struct-fastseedtype 170 185073 20 22615040] "ORREEDON"] [cl-struct-plansys 127 184 0 6 13 59 47200 4479 [cl-struct-fastseedtype 242 99967 208 -72953856] "BIONBIIN"] [cl-struct-plansys 140 6 6 6 4 29 9280 3468 [cl-struct-fastseedtype 178 990092 148 -76377088] "ENCEZAIS"] [cl-struct-plansys 125 4 6 1 3 20 3200 4733 [cl-struct-fastseedtype 10 41597 128 -108560384] "SOESDIRI"] [cl-struct-plansys 158 13 5 3 6 33 9240 4510 [cl-struct-fastseedtype 218 265118 52 -38390784] "VEGEEDAT"] [cl-struct-plansys 209 184 2 0 6 27 6912 6097 [cl-struct-fastseedtype 66 968657 80 32264192] "INLABE"] [cl-struct-plansys 149 51 3 4 7 36 16128 6293 [cl-struct-fastseedtype 34 488085 244 54391808] "ISBIOR"] [cl-struct-plansys 29 217 1 3 9 41 20664 6173 [cl-struct-fastseedtype 154 1040157 64 -84066304] "ISRAA"] [cl-struct-plansys 0 15 7 1 1 13 1560 3584 [cl-struct-fastseedtype 138 170752 212 -83635200] "GEBETI"] [cl-struct-plansys 47 23 7 2 4 26 3744 5423 [cl-struct-fastseedtype 18 227119 80 56250368] "QULEARBI"] [cl-struct-plansys 38 42 2 2 8 37 14208 3110 [cl-struct-fastseedtype 18 197926 212 116511744] "ATXEQU"] [cl-struct-plansys 142 90 2 5 10 48 27648 5774 [cl-struct-fastseedtype 170 337806 128 -131366912] "MARARERE"] [cl-struct-plansys 14 206 6 7 7 42 14784 3086 [cl-struct-fastseedtype 186 738318 244 -920576] "ATAER"] [cl-struct-plansys 145 208 0 4 10 45 28800 2961 [cl-struct-fastseedtype 98 571281 208 -13578240] "ERENRA"] [cl-struct-plansys 23 84 6 0 4 23 2944 6423 [cl-struct-fastseedtype 130 876311 52 -16894976] "RIARONUS"] [cl-struct-plansys 232 127 7 7 4 31 8184 3560 [cl-struct-fastseedtype 58 651240 64 13778944] "ENQURALE"] [cl-struct-plansys 1 244 4 5 7 38 16416 2817 [cl-struct-fastseedtype 106 582145 148 53515264] "ERBIEDER"] [cl-struct-plansys 176 88 0 6 10 47 37600 6832 [cl-struct-fastseedtype 50 50352 208 103796736] "AEDEDLE"] [cl-struct-plansys 129 24 0 6 11 51 40800 3713 [cl-struct-fastseedtype 114 970113 20 80942080] "BEDILEXE"] [cl-struct-plansys 2 193 3 1 7 33 9240 3074 [cl-struct-fastseedtype 74 1019394 128 120684544] "ATLAESER"] [cl-struct-plansys 80 41 1 3 8 37 18648 6736 [cl-struct-fastseedtype 154 385616 180 -43011072] "AESARGE"] [cl-struct-plansys 3 170 2 0 8 35 8960 4611 [cl-struct-fastseedtype 130 871683 80 -57192448] "TIZAON"] [cl-struct-plansys 187 223 7 4 5 32 6144 3003 [cl-struct-fastseedtype 226 1001659 116 81818624] "TEED"] [cl-struct-plansys 116 24 0 3 9 40 22400 5236 [cl-struct-fastseedtype 218 33652 64 34160640] "ESVERARA"] [cl-struct-plansys 180 20 6 1 2 16 2560 6836 [cl-struct-fastseedtype 74 1007284 84 -77638656] "ONUSAN"] [cl-struct-plansys 195 59 3 2 8 38 12768 4803 [cl-struct-fastseedtype 82 715715 80 -64532480] "SOBIATRI"] [cl-struct-plansys 94 17 1 2 9 40 17280 4446 [cl-struct-fastseedtype 210 360030 84 9851904] "VEBIAN"] [cl-struct-plansys 151 251 3 5 10 49 24696 5271 [cl-struct-fastseedtype 234 157591 128 -23494656] "ORINRIZA"] [cl-struct-plansys 36 94 6 7 5 34 11968 6692 [cl-struct-fastseedtype 122 55076 116 -5278720] "AENBI"] [cl-struct-plansys 231 6 6 4 6 35 8960 6887 [cl-struct-fastseedtype 162 705255 208 102748160] "ONDIRA"] [cl-struct-plansys 66 20 6 0 3 19 2432 3906 [cl-struct-fastseedtype 66 850754 180 6599680] "ZAANXEGE"] [cl-struct-plansys 131 98 2 7 12 58 40832 3459 [cl-struct-fastseedtype 122 356739 64 44187648] "XEUSREOR"] [cl-struct-plansys 217 174 6 5 5 32 9216 3033 [cl-struct-fastseedtype 42 494553 20 84939776] "ERTIUS"] [cl-struct-plansys 40 128 0 6 10 47 37600 2856 [cl-struct-fastseedtype 114 734504 208 88133632] "ARBERI"] [cl-struct-plansys 126 83 3 6 9 46 25760 5758 [cl-struct-fastseedtype 50 423294 148 96179200] "ANDIBIA"] [cl-struct-plansys 15 198 6 1 5 28 4480 3599 [cl-struct-fastseedtype 138 434703 128 -27033600] "GEORINAR"] [cl-struct-plansys 74 172 4 3 7 36 12096 3146 [cl-struct-fastseedtype 90 292682 52 3224576] "ATUSZAIS"] [cl-struct-plansys 253 164 6 0 2 15 1920 5629 [cl-struct-fastseedtype 194 573437 80 -3518464] "ARINRA"] [cl-struct-plansys 106 52 4 4 7 37 14208 5482 [cl-struct-fastseedtype 162 865898 244 -49613824] "ARESON"] [cl-struct-plansys 212 31 7 3 2 19 3192 6356 [cl-struct-fastseedtype 26 101844 64 -23248896] "ISERXEER"] [cl-struct-plansys 48 2 2 1 6 28 8960 3376 [cl-struct-fastseedtype 10 780336 212 29545472] "XERASO"] [cl-struct-plansys 159 231 7 2 4 26 3744 6047 [cl-struct-fastseedtype 146 521631 80 -109293568] "TEGEONON"] [cl-struct-plansys 159 31 7 2 4 26 3744 3487 [cl-struct-fastseedtype 146 304287 212 -4008960] "XELEZA"] [cl-struct-plansys 41 228 4 5 7 38 16416 6697 [cl-struct-fastseedtype 42 444201 128 -24150016] "AISLAXE"] [cl-struct-plansys 130 85 5 7 8 45 19800 3970 [cl-struct-fastseedtype 58 637826 244 -126553088] "RAINZA"] [cl-struct-plansys 5 68 4 4 6 33 12672 4357 [cl-struct-fastseedtype 226 104197 208 93769728] "VEIS"] [cl-struct-plansys 245 125 7 0 1 12 1152 3829 [cl-struct-fastseedtype 2 585205 52 106116096] "BECEDIBI"] [cl-struct-plansys 38 13 5 7 8 45 19800 5414 [cl-struct-fastseedtype 186 256038 64 -101040128] "QUREAED"] [cl-struct-plansys 120 79 7 5 3 25 5400 4728 [cl-struct-fastseedtype 234 603768 148 49779712] "TIERUS"] [cl-struct-plansys 232 48 0 6 10 47 37600 5352 [cl-struct-fastseedtype 178 118248 208 -119943168] "ORBELAXE"] [cl-struct-plansys 130 181 5 6 7 40 16000 6018 [cl-struct-fastseedtype 242 381314 20 -97774592] "INZABEZA"] [cl-struct-plansys 164 19 3 1 5 25 7000 6308 [cl-struct-fastseedtype 202 146596 128 -14843904] "ISVEEDIN"] [cl-struct-plansys 140 152 0 3 9 40 22400 5516 [cl-struct-fastseedtype 26 491660 180 33207296] "QUONBI"] [cl-struct-plansys 192 166 6 0 1 11 1408 4288 [cl-struct-fastseedtype 2 231104 80 -75149312] "CEMAER"] [cl-struct-plansys 161 48 0 4 10 45 28800 6305 [cl-struct-fastseedtype 98 952737 116 129856512] "ISARE"] [cl-struct-plansys 59 238 6 3 6 34 7616 5179 [cl-struct-fastseedtype 90 592955 64 12140544] "ORXETIBE"] [cl-struct-plansys 115 215 7 1 4 25 3000 6515 [cl-struct-fastseedtype 202 1031539 84 -97627136] "REORAN"] [cl-struct-plansys 195 27 3 2 8 38 12768 5315 [cl-struct-fastseedtype 210 584387 80 -78032896] "OREDVEUS"] [cl-struct-plansys 232 86 6 2 2 17 3264 4840 [cl-struct-fastseedtype 82 644584 84 7820288] "TILALA"] [cl-struct-plansys 66 21 5 5 7 39 14040 6210 [cl-struct-fastseedtype 106 558146 128 -133332992] "DICELASO"] [cl-struct-plansys 39 181 5 7 9 49 21560 3367 [cl-struct-fastseedtype 250 509735 116 105018368] "XEONAR"] [cl-struct-plansys 236 138 2 4 7 35 17920 4332 [cl-struct-fastseedtype 34 653804 208 -40513536] "LAINDI"] [cl-struct-plansys 47 141 7 0 3 20 1920 5167 [cl-struct-fastseedtype 194 861487 180 -53890048] "ESSOAT"] [cl-struct-plansys 209 128 0 7 12 56 49280 5585 [cl-struct-fastseedtype 250 672209 64 114966528] "QUDIOR"] [cl-struct-plansys 224 217 1 5 9 43 27864 4832 [cl-struct-fastseedtype 170 821216 20 -119073792] "SOLEUSER"] [cl-struct-plansys 240 104 0 6 10 47 37600 5616 [cl-struct-fastseedtype 242 673008 208 16437248] "QURAA"] [cl-struct-plansys 143 64 0 6 13 59 47200 3983 [cl-struct-fastseedtype 178 647055 148 -31157248] "ZARAUSXE"] [cl-struct-plansys 194 168 2 1 8 36 11520 6850 [cl-struct-fastseedtype 10 818114 128 -111181824] "ONARMALA"] [cl-struct-plansys 21 235 3 3 7 35 13720 5909 [cl-struct-fastseedtype 218 324629 52 -20171776] "INREERAR"] [cl-struct-plansys 74 176 2 0 7 31 7936 4938 [cl-struct-fastseedtype 66 968522 80 -3649536] "USXELA"] [cl-struct-plansys 96 213 5 4 4 26 8320 4704 [cl-struct-fastseedtype 34 512096 244 16249856] "TIDICE"] [cl-struct-plansys 170 133 5 3 6 33 9240 6314 [cl-struct-fastseedtype 154 314538 64 -128106496] "ISDILAON"] [cl-struct-plansys 127 149 7 1 4 25 3000 3199 [cl-struct-fastseedtype 138 697471 212 10605568] "LEVETI"] [cl-struct-plansys 48 215 7 2 1 14 2016 6448 [cl-struct-fastseedtype 18 319792 80 29249536] "RIBIRAOR"] [cl-struct-plansys 57 180 4 2 5 27 7776 3641 [cl-struct-fastseedtype 18 1028153 212 -21769216] "BELERE"] [cl-struct-plansys 227 142 6 5 7 40 11520 3811 [cl-struct-fastseedtype 170 1023203 128 -82608128] "BECETELA"] [cl-struct-plansys 21 124 4 7 8 44 23232 4629 [cl-struct-fastseedtype 186 987157 244 85455872] "TIARED"] [cl-struct-plansys 154 216 0 4 11 49 31360 6042 [cl-struct-fastseedtype 98 225690 208 -31666176] "TEABI"] [cl-struct-plansys 242 70 6 0 3 19 2432 5106 [cl-struct-fastseedtype 130 52978 52 -3656704] "USLEANCE"] [cl-struct-plansys 133 187 3 7 9 47 28952 3461 [cl-struct-fastseedtype 58 601221 64 -113098752] "XEGEARER"] [cl-struct-plansys 16 74 2 5 8 40 23040 6416 [cl-struct-fastseedtype 106 812560 148 48141312] "RIORUSLE"] [cl-struct-plansys 65 40 0 6 11 51 40800 3649 [cl-struct-fastseedtype 50 462913 208 -39596032] "GEDIENZA"] [cl-struct-plansys 164 242 2 6 8 41 26240 4260 [cl-struct-fastseedtype 114 318884 20 -39513088] "CETECESO"] [cl-struct-plansys 103 133 7 1 4 25 3000 5223 [cl-struct-fastseedtype 74 343399 128 -47611904] "ESVESOSO"] [cl-struct-plansys 231 167 7 3 5 31 5208 4327 [cl-struct-fastseedtype 154 591847 180 44413952] "CERAXETE"] [cl-struct-plansys 156 194 2 0 5 23 5888 3740 [cl-struct-fastseedtype 130 157596 80 -57454592] "BEATLE"] [cl-struct-plansys 166 33 1 4 10 46 26496 5542 [cl-struct-fastseedtype 226 841894 116 79328256] "QUGEZA"] [cl-struct-plansys 33 228 4 3 6 32 10752 5153 [cl-struct-fastseedtype 218 154913 64 92880896] "ESAQUBE"] [cl-struct-plansys 83 58 2 1 9 40 12800 6227 [cl-struct-fastseedtype 74 828243 84 18699264] "ISMAAN"] [cl-struct-plansys 228 27 3 2 5 26 8736 5860 [cl-struct-fastseedtype 82 241380 80 -55881728] "MAMAANAT"] [cl-struct-plansys 145 59 3 2 6 30 10080 5009 [cl-struct-fastseedtype 210 659857 84 108549120] "EDCEA"] [cl-struct-plansys 12 79 7 5 3 25 5400 3084 [cl-struct-fastseedtype 234 904972 128 128024576] "LEISINMA"] [cl-struct-plansys 75 172 4 7 10 52 27456 4171 [cl-struct-fastseedtype 122 912459 116 16086016] "LADIRE"] [cl-struct-plansys 16 46 6 4 3 23 5888 5648 [cl-struct-fastseedtype 162 541712 208 120311808] "MAARBI"] [cl-struct-plansys 61 166 6 0 2 15 1920 6461 [cl-struct-fastseedtype 66 940349 180 -78728192] "REENRI"] [cl-struct-plansys 64 190 6 7 5 34 11968 3392 [cl-struct-fastseedtype 122 333376 64 20070400] "ENATZAUS"] [cl-struct-plansys 8 164 4 5 6 34 14688 6408 [cl-struct-fastseedtype 42 521992 20 -52554752] "RIAREROR"] [cl-struct-plansys 217 112 0 6 11 51 40800 4057 [cl-struct-fastseedtype 114 1009113 208 -19607552] "RAONDILE"] [cl-struct-plansys 193 205 5 6 6 36 14400 6337 [cl-struct-fastseedtype 50 412097 148 78484480] "DITEARRA"] [cl-struct-plansys 148 170 2 1 6 28 8960 5780 [cl-struct-fastseedtype 138 663444 128 -92569600] "ANQUARLE"] [cl-struct-plansys 1 202 2 3 8 38 17024 4609 [cl-struct-fastseedtype 90 930305 52 -108579840] "SOBETEVE"] [cl-struct-plansys 182 220 6 0 3 19 2432 4534 [cl-struct-fastseedtype 194 331190 80 31870976] "BIORVE"] [cl-struct-plansys 117 22 6 4 4 27 6912 3957 [cl-struct-fastseedtype 162 569461 244 -16452608] "ZAERMA"] [cl-struct-plansys 161 11 3 3 7 35 13720 6305 [cl-struct-fastseedtype 26 461729 64 -130203648] "ISESUSA"] [cl-struct-plansys 239 200 2 1 9 40 12800 3055 [cl-struct-fastseedtype 10 917487 212 127980544] "TISO"] [cl-struct-plansys 224 231 7 2 1 14 2016 3040 [cl-struct-fastseedtype 146 387552 80 -64991232] "USESEN"] [cl-struct-plansys 242 233 1 2 9 40 17280 4082 [cl-struct-fastseedtype 146 923634 212 63230976] "ZAED"] [cl-struct-plansys 190 88 0 5 12 54 38880 4798 [cl-struct-fastseedtype 42 432318 128 -38305792] "TIREGEES"] [cl-struct-plansys 201 67 3 7 9 47 28952 5577 [cl-struct-fastseedtype 58 324041 244 98235392] "QUSOIN"] [cl-struct-plansys 78 140 4 4 7 37 14208 3406 [cl-struct-fastseedtype 226 358222 208 -121450496] "XEISA"] [cl-struct-plansys 16 175 7 0 0 8 768 6160 [cl-struct-fastseedtype 2 750096 52 -77777920] "ISTEESGE"] [cl-struct-plansys 3 137 1 7 13 61 48312 5379 [cl-struct-fastseedtype 186 929027 64 -22396928] "ARTICESO"] [cl-struct-plansys 199 229 5 5 8 43 15480 4295 [cl-struct-fastseedtype 234 696519 148 48600064] "CEBEOR"] [cl-struct-plansys 185 64 0 6 11 51 40800 6329 [cl-struct-fastseedtype 178 474041 208 76402688] "DIUSACE"] [cl-struct-plansys 229 207 7 6 4 30 7200 6629 [cl-struct-fastseedtype 242 188901 20 -12708864] "RIBETIES"] [cl-struct-plansys 73 23 7 1 2 17 2040 4169 [cl-struct-fastseedtype 202 950345 128 22380544] "LATIVEGE"] [cl-struct-plansys 99 86 6 3 6 34 7616 2915 [cl-struct-fastseedtype 26 338019 180 -9391104] "ERARRIOR"] [cl-struct-plansys 153 254 6 0 2 15 1920 3225 [cl-struct-fastseedtype 2 270233 80 -4108288] "LEEDEN"] [cl-struct-plansys 204 178 2 4 7 35 17920 4812 [cl-struct-fastseedtype 98 370124 116 -69766144] "TIVEQU"] [cl-struct-plansys 40 250 2 3 7 34 15232 5160 [cl-struct-fastseedtype 90 517672 64 7946240] "ORANISEN"] [cl-struct-plansys 82 61 7 1 3 21 2520 5970 [cl-struct-fastseedtype 202 475218 84 2905088] "INTEAN"] [cl-struct-plansys 36 59 3 2 5 26 8736 6180 [cl-struct-fastseedtype 210 845860 80 1921024] "ISISAN"] [cl-struct-plansys 91 192 0 2 11 47 22560 5211 [cl-struct-fastseedtype 82 663899 84 43602944] "ORRAES"] [cl-struct-plansys 247 169 1 5 12 55 35640 4343 [cl-struct-fastseedtype 106 473079 128 -44728320] "LAVEGERE"] [cl-struct-plansys 142 67 3 7 10 51 31416 5006 [cl-struct-fastseedtype 250 980622 116 -3640320] "USQUEN"] [cl-struct-plansys 85 242 2 4 8 39 19968 3157 [cl-struct-fastseedtype 34 184661 208 48353280] "LEESON"] [cl-struct-plansys 106 95 7 0 2 16 1536 3690 [cl-struct-fastseedtype 194 67434 180 -67914752] "BERITERE"] [cl-struct-plansys 206 28 4 7 9 48 25344 5582 [cl-struct-fastseedtype 250 548558 64 27934720] "ARVEAA"] [cl-struct-plansys 79 15 7 5 6 37 7992 4175 [cl-struct-fastseedtype 170 264527 20 16061440] "LARAEDLE"] [cl-struct-plansys 225 152 0 6 11 51 40800 6625 [cl-struct-fastseedtype 242 477153 208 -20000768] "REESQUEN"] [cl-struct-plansys 18 250 2 6 10 49 31360 4370 [cl-struct-fastseedtype 178 828434 148 -111766528] "VEGEINSO"] [cl-struct-plansys 135 204 6 1 5 28 4480 4743 [cl-struct-fastseedtype 10 228743 128 28803072] "TIMAESIN"] [cl-struct-plansys 12 73 1 3 8 37 18648 3340 [cl-struct-fastseedtype 218 844044 52 6435840] "XEORUSGE"] [cl-struct-plansys 67 40 2 0 8 35 8960 3907 [cl-struct-fastseedtype 66 770883 80 103043072] "ZAATI"] [cl-struct-plansys 171 247 7 4 5 32 6144 3243 [cl-struct-fastseedtype 34 345771 244 120714240] "ATRAAT"] [cl-struct-plansys 183 177 1 3 11 49 24696 6327 [cl-struct-fastseedtype 154 113335 64 -29540352] "ISBIANRI"] [cl-struct-plansys 126 155 3 1 7 33 9240 6782 [cl-struct-fastseedtype 138 600702 212 113234944] "ONORTI"] [cl-struct-plansys 177 23 7 2 2 18 2592 3505 [cl-struct-fastseedtype 18 180145 80 -123580416] "XEMARIIN"]] [[cl-struct-plansys 1 45 5 4 5 30 9600 5633 [cl-struct-fastseedtype 36 1 169 14395648] "ANESBI"] [cl-struct-plansys 204 230 6 3 3 22 4928 6348 [cl-struct-fastseedtype 90 972 11 113052416] "ISEROR"] [cl-struct-plansys 38 249 1 7 12 57 45144 2854 [cl-struct-fastseedtype 184 10790 101 -40868608] "ERERSO"] [cl-struct-plansys 168 103 7 1 1 13 1560 3240 [cl-struct-fastseedtype 206 123560 55 130103040] "LEATANRE"] [cl-struct-plansys 206 59 3 1 7 33 9240 6094 [cl-struct-fastseedtype 204 365518 97 -2334464] "TEBIENLA"] [cl-struct-plansys 85 146 2 0 6 27 6912 6485 [cl-struct-fastseedtype 130 454997 163 47096576] "REVEQU"] [cl-struct-plansys 95 218 2 4 10 47 24064 2911 [cl-struct-fastseedtype 96 664671 29 99622144] "ERESORBE"] [cl-struct-plansys 147 121 1 6 12 56 40320 4499 [cl-struct-fastseedtype 118 514707 207 -13185280] "VEGEDIUS"] [cl-struct-plansys 136 13 5 6 5 32 12800 5512 [cl-struct-fastseedtype 116 2952 25 131733760] "QUERBEIS"] [cl-struct-plansys 29 211 3 5 8 41 20664 3101 [cl-struct-fastseedtype 170 124957 59 -127845632] "LEATER"] [cl-struct-plansys 132 208 2 1 6 28 8960 4484 [cl-struct-fastseedtype 8 855428 213 44487936] "BIANBIES"] [cl-struct-plansys 201 38 6 3 4 26 5824 5833 [cl-struct-fastseedtype 30 600265 103 -18127104] "MAANA"] [cl-struct-plansys 86 143 7 3 4 27 4536 2902 [cl-struct-fastseedtype 28 519254 209 -104804096] "BIIS"] [cl-struct-plansys 36 189 5 2 3 20 4800 4900 [cl-struct-fastseedtype 210 131364 211 -125250816] "USMAEDIN"] [cl-struct-plansys 12 24 0 6 10 47 37600 2828 [cl-struct-fastseedtype 176 447244 141 -40858368] "ERLABEOR"] [cl-struct-plansys 153 83 3 0 5 24 5376 3481 [cl-struct-fastseedtype 198 852889 255 -106758400] "XEERIN"] [cl-struct-plansys 255 204 6 0 4 23 2944 6143 [cl-struct-fastseedtype 196 215039 137 106727680] "TEESCEAR"] [cl-struct-plansys 10 133 5 7 8 45 19800 5130 [cl-struct-fastseedtype 250 785674 107 62483200] "ORESREAT"] [cl-struct-plansys 17 14 6 3 4 26 5824 5137 [cl-struct-fastseedtype 88 84753 69 40453376] "ESUSGE"] [cl-struct-plansys 245 3 3 5 8 41 20664 3317 [cl-struct-fastseedtype 110 881397 151 58824448] "LEQUATDI"] [cl-struct-plansys 237 241 1 5 10 47 30456 5357 [cl-struct-fastseedtype 108 419053 65 106512640] "OREDRIER"] [cl-struct-plansys 16 126 6 4 3 23 5888 4624 [cl-struct-fastseedtype 34 712720 3 -104398080] "SOLADIAR"] [cl-struct-plansys 74 45 7 0 2 16 1536 5962 [cl-struct-fastseedtype 0 330826 253 -20120320] "INZAAN"] [cl-struct-plansys 108 91 3 2 5 26 8736 5740 [cl-struct-fastseedtype 22 281708 47 -99930368] "MAENES"] [cl-struct-plansys 39 73 1 2 10 44 19008 3367 [cl-struct-fastseedtype 20 222759 249 37943552] "XEBEIS"] [cl-struct-plansys 20 29 7 1 1 13 1560 4116 [cl-struct-fastseedtype 74 1043988 155 -102393088] "CETIAT"] [cl-struct-plansys 14 17 1 5 11 51 33048 4622 [cl-struct-fastseedtype 168 296462 181 37205248] "TITIRIDI"] [cl-struct-plansys 45 158 6 7 6 38 13376 3629 [cl-struct-fastseedtype 190 315181 199 -64764160] "GEALE"] [cl-struct-plansys 84 65 1 7 10 49 38808 4180 [cl-struct-fastseedtype 188 750420 177 -91901696] "CEANVE"] [cl-struct-plansys 151 246 6 6 7 41 13120 5271 [cl-struct-fastseedtype 114 689815 51 44643072] "ESVETI"] [cl-struct-plansys 87 119 7 2 4 26 3744 4183 [cl-struct-fastseedtype 80 120919 109 -33198848] "CERAERAR"] [cl-struct-plansys 10 48 0 4 11 49 31360 6666 [cl-struct-fastseedtype 102 286730 95 34561792] "AARZARI"] [cl-struct-plansys 190 100 4 4 7 37 14208 6334 [cl-struct-fastseedtype 100 254142 105 -9606912] "DIERANOR"] [cl-struct-plansys 185 187 3 3 7 35 13720 4281 [cl-struct-fastseedtype 154 155833 203 33934080] "CEANQUAN"] [cl-struct-plansys 187 58 2 7 12 58 40832 3515 [cl-struct-fastseedtype 248 125883 37 91366656] "ENUSTIEN"] [cl-struct-plansys 114 151 7 1 3 21 2520 3186 [cl-struct-fastseedtype 14 320882 247 91354880] "ATANON"] [cl-struct-plansys 76 95 7 1 1 13 1560 4428 [cl-struct-fastseedtype 12 120652 33 -114941696] "BIATGE"] [cl-struct-plansys 58 67 3 0 6 28 6272 6714 [cl-struct-fastseedtype 194 960314 99 89088768] "ADITIRA"] [cl-struct-plansys 116 87 7 4 2 20 3840 5236 [cl-struct-fastseedtype 160 1001844 221 -40248064] "ORBIRA"] [cl-struct-plansys 116 116 4 6 6 35 16800 6772 [cl-struct-fastseedtype 182 213876 143 -112226560] "AEDIS"] [cl-struct-plansys 133 253 5 6 6 36 14400 5765 [cl-struct-fastseedtype 180 982149 217 -4466432] "ANRI"] [cl-struct-plansys 122 128 0 5 12 54 38880 5242 [cl-struct-fastseedtype 234 291962 251 -113640704] "ORLAAROR"] [cl-struct-plansys 89 234 2 1 7 32 10240 4953 [cl-struct-fastseedtype 72 996185 149 -42429184] "EDANDI"] [cl-struct-plansys 194 141 5 3 6 33 9240 6082 [cl-struct-fastseedtype 94 817090 39 34350848] "INTEARBE"] [cl-struct-plansys 147 42 2 3 10 46 20608 5523 [cl-struct-fastseedtype 92 629395 145 52072704] "QUEDBIQU"] [cl-struct-plansys 122 134 6 2 4 25 4800 5242 [cl-struct-fastseedtype 18 470650 147 -103181568] "ORQURE"] [cl-struct-plansys 225 46 6 6 5 33 10560 5601 [cl-struct-fastseedtype 240 752609 77 -34976512] "ARQUBI"] [cl-struct-plansys 171 198 6 0 4 23 2944 5803 [cl-struct-fastseedtype 6 775595 191 -43270400] "MAISRAIS"] [cl-struct-plansys 61 244 6 0 2 15 1920 6461 [cl-struct-fastseedtype 4 182333 73 51267840] "REONAR"] [cl-struct-plansys 216 138 2 7 9 46 32384 3544 [cl-struct-fastseedtype 58 344792 43 44182272] "XECEON"] [cl-struct-plansys 38 127 7 3 4 27 4536 5670 [cl-struct-fastseedtype 152 237094 5 -106232576] "MAATXERI"] [cl-struct-plansys 30 34 2 5 10 48 27648 3358 [cl-struct-fastseedtype 174 320030 87 -91072768] "ENBEZA"] [cl-struct-plansys 234 132 4 5 8 42 18144 3818 [cl-struct-fastseedtype 172 856298 1 121831680] "GEEN"] [cl-struct-plansys 213 224 0 4 10 45 28800 4821 [cl-struct-fastseedtype 98 770773 195 -26754304] "SOISQU"] [cl-struct-plansys 223 90 2 0 8 35 8960 4575 [cl-struct-fastseedtype 64 497119 189 -44647168] "VEERBIDI"] [cl-struct-plansys 173 198 6 2 3 21 4032 3757 [cl-struct-fastseedtype 86 741293 239 33812224] "GETIUSZA"] [cl-struct-plansys 164 40 0 2 8 35 16800 4004 [cl-struct-fastseedtype 84 924836 185 121944320] "ZAATQUAT"] [cl-struct-plansys 81 250 2 1 7 32 10240 6481 [cl-struct-fastseedtype 138 745297 91 123624192] "RIARQUGE"] [cl-struct-plansys 99 90 2 5 11 52 29952 5219 [cl-struct-fastseedtype 232 980835 117 124351744] "ESUSLA"] [cl-struct-plansys 134 245 5 7 8 45 19800 3974 [cl-struct-fastseedtype 254 760454 135 -39549184] "ZAINAT"] [cl-struct-plansys 17 76 4 7 8 44 23232 6673 [cl-struct-fastseedtype 252 382993 113 41906432] "ONISAIN"] [cl-struct-plansys 204 111 7 6 3 26 6240 5324 [cl-struct-fastseedtype 178 607436 243 119141120] "ORLATEIN"] [cl-struct-plansys 172 60 4 2 4 23 6624 6828 [cl-struct-fastseedtype 144 968620 45 -130077440] "ONUSRA"] [cl-struct-plansys 123 20 4 4 8 41 15744 4987 [cl-struct-fastseedtype 166 443515 31 12066560] "EDSOAN"] [cl-struct-plansys 123 123 3 4 9 44 19712 6779 [cl-struct-fastseedtype 164 892027 41 -130078464] "ONVEAT"] [cl-struct-plansys 102 241 1 3 10 45 22680 6502 [cl-struct-fastseedtype 218 415590 139 110004992] "REBITE"] [cl-struct-plansys 81 220 4 7 8 44 23232 3665 [cl-struct-fastseedtype 56 37969 229 34858240] "BELEBI"] [cl-struct-plansys 251 166 6 1 5 28 4480 3579 [cl-struct-fastseedtype 78 241915 183 -1919232] "XEZAXEES"] [cl-struct-plansys 201 98 2 1 7 32 10240 6857 [cl-struct-fastseedtype 76 120777 225 -5250816] "AANRA"] [cl-struct-plansys 224 84 6 0 1 11 1408 3040 [cl-struct-fastseedtype 2 478944 35 -32496896] "ERZARA"] [cl-struct-plansys 137 52 4 4 6 33 12672 3721 [cl-struct-fastseedtype 224 871305 157 -117203712] "GEXEALA"] [cl-struct-plansys 21 79 7 6 4 30 7200 4885 [cl-struct-fastseedtype 246 565525 79 -114798848] "USREINXE"] [cl-struct-plansys 130 204 4 6 8 43 20640 6274 [cl-struct-fastseedtype 244 570498 153 -2254592] "ISDIDIED"] [cl-struct-plansys 152 141 5 5 5 31 11160 3480 [cl-struct-fastseedtype 42 537240 187 89307904] "ENEDGE"] [cl-struct-plansys 46 99 3 1 7 33 9240 5422 [cl-struct-fastseedtype 136 939054 85 51008768] "ARTELAAN"] [cl-struct-plansys 123 213 5 3 7 37 10360 6011 [cl-struct-fastseedtype 158 1003387 231 -68360448] "INISBI"] [cl-struct-plansys 208 166 6 3 3 22 4928 4048 [cl-struct-fastseedtype 156 541136 81 129257728] "RAMAA"] [cl-struct-plansys 143 175 7 2 4 26 3744 5519 [cl-struct-fastseedtype 82 374159 83 57299712] "ARESGETI"] [cl-struct-plansys 183 163 3 6 10 50 28000 4023 [cl-struct-fastseedtype 48 484791 13 -133952256] "ZARIORTE"] [cl-struct-plansys 124 25 3 0 4 20 4480 3964 [cl-struct-fastseedtype 70 404604 127 16023296] "RAARAN"] [cl-struct-plansys 122 251 3 0 6 28 6272 2938 [cl-struct-fastseedtype 68 957306 9 100665600] "LAACE"] [cl-struct-plansys 101 239 7 7 5 35 9240 5477 [cl-struct-fastseedtype 122 455269 235 -20256000] "ARERAN"] [cl-struct-plansys 59 80 0 3 12 52 29120 5947 [cl-struct-fastseedtype 216 761915 197 28099840] "INORLE"] [cl-struct-plansys 7 33 1 5 12 55 35640 3591 [cl-struct-fastseedtype 238 80391 23 40048384] "GEINTISO"] [cl-struct-plansys 231 247 7 5 6 37 7992 6119 [cl-struct-fastseedtype 236 954855 193 23904512] "ININLEQU"] [cl-struct-plansys 90 161 1 4 10 46 26496 4954 [cl-struct-fastseedtype 162 132954 131 -45579520] "USZASORA"] [cl-struct-plansys 116 231 7 0 0 8 768 2932 [cl-struct-fastseedtype 128 25716 125 -73368320] "TEAT"] [cl-struct-plansys 174 17 1 2 9 40 17280 6062 [cl-struct-fastseedtype 150 853934 175 62697216] "TETEUS"] [cl-struct-plansys 33 232 0 2 9 39 18720 4385 [cl-struct-fastseedtype 148 217633 121 8812800] "BIERED"] [cl-struct-plansys 78 56 2 1 8 36 11520 4686 [cl-struct-fastseedtype 202 397902 27 68623104] "TIRIGE"] [cl-struct-plansys 185 3 3 5 8 41 20664 5817 [cl-struct-fastseedtype 40 27577 53 56308992] "ANEDIN"] [cl-struct-plansys 160 44 4 7 7 40 21120 4256 [cl-struct-fastseedtype 62 413344 71 -102414592] "CEENTI"] [cl-struct-plansys 207 55 7 7 7 43 11352 5327 [cl-struct-fastseedtype 60 888271 49 28913920] "ORUS"] [cl-struct-plansys 193 72 0 6 11 51 40800 5569 [cl-struct-fastseedtype 242 330945 179 130724608] "ARLALE"] [cl-struct-plansys 1 97 1 2 8 36 15552 4865 [cl-struct-fastseedtype 208 106497 237 -130487040] "EDTETIIN"] [cl-struct-plansys 172 215 7 4 2 20 3840 2988 [cl-struct-fastseedtype 230 568748 223 52485888] "CEENED"] [cl-struct-plansys 56 114 2 4 7 35 17920 2872 [cl-struct-fastseedtype 228 828216 233 55634176] "ERTEBIRA"] [cl-struct-plansys 212 134 6 3 3 22 4928 4820 [cl-struct-fastseedtype 26 526292 75 -61388032] "TIATISBI"] [cl-struct-plansys 230 221 5 7 8 45 19800 4326 [cl-struct-fastseedtype 120 13286 165 -76176128] "LAORLAZA"] [cl-struct-plansys 68 149 7 1 1 13 1560 3652 [cl-struct-fastseedtype 142 460100 119 -15501568] "BEDICE"] [cl-struct-plansys 70 69 7 1 3 21 2520 5190 [cl-struct-fastseedtype 140 410950 161 -75915008] "ORCECE"] [cl-struct-plansys 69 197 7 0 1 12 1152 2885 [cl-struct-fastseedtype 66 542789 227 84992768] "ERTEENON"] [cl-struct-plansys 159 114 2 4 10 47 24064 6303 [cl-struct-fastseedtype 32 96927 93 2972928] "DIRIMA"] [cl-struct-plansys 119 11 3 6 10 50 28000 3191 [cl-struct-fastseedtype 54 1045367 15 113315584] "LEGEAN"] [cl-struct-plansys 128 123 3 6 7 38 21280 6784 [cl-struct-fastseedtype 52 992128 89 4151552] "ONANQU"] [cl-struct-plansys 117 250 2 5 9 44 25344 5749 [cl-struct-fastseedtype 106 508533 123 78347008] "MAANTEGE"] [cl-struct-plansys 3 60 6 1 5 28 4480 5891 [cl-struct-fastseedtype 200 65539 21 -77851392] "TETETE"] [cl-struct-plansys 244 252 4 3 5 28 9408 6388 [cl-struct-fastseedtype 222 61428 167 76392192] "DIRILEDI"] [cl-struct-plansys 13 1 1 3 9 41 20664 6413 [cl-struct-fastseedtype 220 463373 17 -7466752] "REISORZA"] [cl-struct-plansys 100 57 1 2 7 32 13824 5732 [cl-struct-fastseedtype 146 226916 19 -46460160] "ANEDED"] [cl-struct-plansys 140 120 0 6 10 47 37600 6284 [cl-struct-fastseedtype 112 680076 205 64867584] "ISXEIN"] [cl-struct-plansys 13 76 6 0 2 15 1920 6157 [cl-struct-fastseedtype 134 690189 63 -63095040] "ISTIXETI"] [cl-struct-plansys 183 226 2 0 8 35 8960 3255 [cl-struct-fastseedtype 132 733623 201 120703232] "ATMALA"] [cl-struct-plansys 178 181 5 7 8 45 19800 3762 [cl-struct-fastseedtype 186 666546 171 3386112] "BEANLE"] [cl-struct-plansys 81 129 1 3 9 41 20664 6481 [cl-struct-fastseedtype 24 155985 133 40797440] "RELELEAT"] [cl-struct-plansys 177 1 1 5 10 47 30456 3761 [cl-struct-fastseedtype 46 539313 215 49534720] "BEBIMA"] [cl-struct-plansys 229 75 3 5 8 41 20664 4581 [cl-struct-fastseedtype 44 38885 129 -53051136] "VEBIXE"] [cl-struct-plansys 159 194 2 4 10 47 24064 5279 [cl-struct-fastseedtype 226 134559 67 -26656000] "ESMARA"] [cl-struct-plansys 9 212 6 0 2 15 1920 5385 [cl-struct-fastseedtype 192 116745 61 27933952] "ARUSTEA"] [cl-struct-plansys 111 60 4 2 7 35 10080 4207 [cl-struct-fastseedtype 214 947311 111 120942336] "LAXESORI"] [cl-struct-plansys 158 135 7 2 3 22 3168 5022 [cl-struct-fastseedtype 212 652958 57 101202176] "USRELAIN"] [cl-struct-plansys 12 213 7 1 1 13 1560 6668 [cl-struct-fastseedtype 10 501516 219 -133178624] "AATDIRE"] [cl-struct-plansys 14 13 5 5 7 39 14040 5902 [cl-struct-fastseedtype 104 291598 245 -32705280] "INUSGE"] [cl-struct-plansys 121 67 3 7 9 47 28952 4473 [cl-struct-fastseedtype 126 76665 7 -119142656] "BIGEXEIN"] [cl-struct-plansys 140 2 2 7 9 46 32384 3468 [cl-struct-fastseedtype 124 705676 241 3338496] "ENXELETI"] [cl-struct-plansys 119 129 1 6 12 56 40320 5751 [cl-struct-fastseedtype 50 48759 115 -54824192] "ANRASOTI"] [cl-struct-plansys 87 231 7 2 4 26 3744 3415 [cl-struct-fastseedtype 16 995671 173 99790080] "ENERQU"] [cl-struct-plansys 158 122 2 4 9 43 22016 5278 [cl-struct-fastseedtype 38 367518 159 21602048] "ESXEAR"] [cl-struct-plansys 246 74 2 4 9 43 22016 3574 [cl-struct-fastseedtype 36 681206 169 -123557632] "XEXEAN"] [cl-struct-plansys 1 123 3 3 7 35 13720 2817 [cl-struct-fastseedtype 90 889345 11 -77591808] "ISRI"] [cl-struct-plansys 123 62 6 7 8 46 16192 4731 [cl-struct-fastseedtype 184 973435 101 -107518720] "TIATZA"] [cl-struct-plansys 77 100 6 1 3 20 3200 3917 [cl-struct-fastseedtype 206 107085 55 -83609856] "ZAVEUSGE"] [cl-struct-plansys 195 8 2 1 9 40 12800 3779 [cl-struct-fastseedtype 204 643011 97 75718912] "GEATIAR"] [cl-struct-plansys 106 151 7 0 2 16 1536 3178 [cl-struct-fastseedtype 130 193386 163 38904576] "ATBEA"] [cl-struct-plansys 180 15 7 4 2 20 3840 4788 [cl-struct-fastseedtype 96 206516 29 -82371328] "TIQUBIED"] [cl-struct-plansys 152 166 6 6 4 29 9280 5272 [cl-struct-fastseedtype 118 735896 207 -98971904] "OREDARIS"] [cl-struct-plansys 125 10 2 6 9 45 28800 3197 [cl-struct-fastseedtype 116 932221 25 -119465728] "LEESUSEN"] [cl-struct-plansys 18 200 0 5 12 54 38880 3858 [cl-struct-fastseedtype 170 508946 59 -12305664] "ZARILA"] [cl-struct-plansys 217 117 7 1 2 17 2040 6361 [cl-struct-fastseedtype 8 509657 213 -26356480] "DITEGERE"] [cl-struct-plansys 46 3 3 3 8 39 15288 6446 [cl-struct-fastseedtype 30 694574 103 65955584] "RETE"] [cl-struct-plansys 75 60 4 3 8 40 13440 4683 [cl-struct-fastseedtype 28 211787 209 44552448] "SOAXE"] [cl-struct-plansys 249 34 2 2 7 33 12672 5881 [cl-struct-fastseedtype 210 20729 211 -11808000] "MAUSDILE"] [cl-struct-plansys 97 173 5 6 6 36 14400 4705 [cl-struct-fastseedtype 176 932961 141 -109605632] "TIBIRI"] [cl-struct-plansys 94 96 2 0 7 31 7936 4190 [cl-struct-fastseedtype 198 92254 255 122027776] "CECEES"] [cl-struct-plansys 244 169 3 0 4 20 4480 3828 [cl-struct-fastseedtype 196 457460 137 -22836992] "GEXEQUON"] [cl-struct-plansys 191 218 2 7 12 58 40832 6079 [cl-struct-fastseedtype 250 134847 107 -19109120] "TEVEBEBI"] [cl-struct-plansys 102 19 3 3 8 39 15288 2918 [cl-struct-fastseedtype 88 717158 69 66077952] "ERES"] [cl-struct-plansys 26 192 0 5 12 54 38880 3866 [cl-struct-fastseedtype 110 631834 151 71603968] "ZAONRIXE"] [cl-struct-plansys 226 126 6 5 6 36 10368 3042 [cl-struct-fastseedtype 108 185058 65 25182464] "LEGECE"] [cl-struct-plansys 165 67 3 4 7 36 16128 5541 [cl-struct-fastseedtype 34 669093 3 -104201472] "ARENXEON"] [cl-struct-plansys 159 34 2 0 8 35 8960 3743 [cl-struct-fastseedtype 0 528543 253 125041920] "BELAUS"] [cl-struct-plansys 241 72 0 2 9 39 18720 6641 [cl-struct-fastseedtype 22 955889 47 74329856] "RESOBI"] [cl-struct-plansys 28 6 6 2 2 17 3264 5148 [cl-struct-fastseedtype 20 195100 249 -3540736] "ESINEN"] [cl-struct-plansys 137 210 2 1 7 32 10240 5001 [cl-struct-fastseedtype 74 114057 155 -79127808] "USZAVE"] [cl-struct-plansys 99 118 6 5 7 40 11520 6499 [cl-struct-fastseedtype 168 40291 181 -8473344] "RIEDANEN"] [cl-struct-plansys 18 59 3 7 10 51 31416 4370 [cl-struct-fastseedtype 190 160018 199 44484352] "BIRARE"] [cl-struct-plansys 73 174 6 7 6 38 13376 5961 [cl-struct-fastseedtype 188 1027145 177 99397888] "INZAAN"] [cl-struct-plansys 236 27 3 6 7 38 21280 6124 [cl-struct-fastseedtype 114 604652 51 -34852096] "INBEIN"] [cl-struct-plansys 172 204 4 2 4 23 6624 6060 [cl-struct-fastseedtype 80 412588 109 -110334720] "INCEISA"] [cl-struct-plansys 79 253 5 4 7 38 12160 3407 [cl-struct-fastseedtype 102 200271 95 53632768] "ENONLEBE"] [cl-struct-plansys 179 1 1 4 11 50 28800 4019 [cl-struct-fastseedtype 100 676275 105 3434752] "RAESERRE"] [cl-struct-plansys 238 208 0 3 11 48 26880 5102 [cl-struct-fastseedtype 154 464366 203 -72824064] "USUSONER"] [cl-struct-plansys 16 255 7 7 4 31 8184 5136 [cl-struct-fastseedtype 248 301072 37 75048192] "ORESRATI"] [cl-struct-plansys 23 20 6 1 5 28 4480 3863 [cl-struct-fastseedtype 14 18455 247 -72026368] "RAIN"] [cl-struct-plansys 65 172 6 1 3 20 3200 6209 [cl-struct-fastseedtype 12 75585 33 46997760] "DIQUUS"] [cl-struct-plansys 79 200 2 0 8 35 8960 3407 [cl-struct-fastseedtype 194 176207 99 -36543744] "ENARINES"] [cl-struct-plansys 201 12 4 4 6 33 12672 3017 [cl-struct-fastseedtype 160 237513 221 29416704] "TILE"] [cl-struct-plansys 121 33 1 6 10 48 34560 3449 [cl-struct-fastseedtype 182 423545 143 -80572672] "ENDIQU"] [cl-struct-plansys 122 122 2 6 10 49 31360 3450 [cl-struct-fastseedtype 180 779898 217 29546752] "XETILA"] [cl-struct-plansys 111 245 5 5 8 43 15480 5999 [cl-struct-fastseedtype 234 448367 251 -48432384] "TEXEARE"] [cl-struct-plansys 174 15 7 1 3 21 2520 6830 [cl-struct-fastseedtype 72 866478 149 71275776] "ONTEAR"] [cl-struct-plansys 39 234 2 3 10 46 20608 6695 [cl-struct-fastseedtype 94 1018663 39 34547456] "ALETIUS"] [cl-struct-plansys 136 87 7 3 2 19 3192 3208 [cl-struct-fastseedtype 92 257416 145 -117337856] "LELEMAA"] [cl-struct-plansys 79 107 3 2 8 38 12768 5967 [cl-struct-fastseedtype 18 402767 147 27038464] "TETIGE"] [cl-struct-plansys 54 67 3 6 9 46 25760 3126 [cl-struct-fastseedtype 240 444726 77 13716736] "ATMABE"] [cl-struct-plansys 112 83 3 0 4 20 4480 6512 [cl-struct-fastseedtype 6 871792 191 -99696896] "REENATEN"] [cl-struct-plansys 50 81 3 0 6 28 6272 4146 [cl-struct-fastseedtype 4 681778 73 72698112] "LAEDON"] [cl-struct-plansys 141 95 7 7 5 35 9240 4237 [cl-struct-fastseedtype 58 768909 43 46476032] "CEENZA"] [cl-struct-plansys 123 4 4 3 8 40 13440 3451 [cl-struct-fastseedtype 152 155771 5 -30276352] "ENENONGE"] [cl-struct-plansys 67 95 7 5 6 37 7992 4163 [cl-struct-fastseedtype 174 996931 87 -27961600] "LAEDAT"] [cl-struct-plansys 223 145 1 5 12 55 35640 5599 [cl-struct-fastseedtype 172 979679 1 124387584] "ARANCE"] [cl-struct-plansys 106 37 5 4 6 34 10880 5482 [cl-struct-fastseedtype 98 188266 195 124437248] "ARQUA"] [cl-struct-plansys 52 207 7 0 0 8 768 6196 [cl-struct-fastseedtype 64 626228 189 83737856] "ISLEBEEN"] [cl-struct-plansys 50 51 3 2 7 34 11424 4402 [cl-struct-fastseedtype 86 420914 239 57077504] "BIINCEOR"] [cl-struct-plansys 153 101 5 2 4 24 5760 5785 [cl-struct-fastseedtype 84 609433 185 97237248] "MAARABI"] [cl-struct-plansys 198 47 7 1 3 21 2520 3270 [cl-struct-fastseedtype 138 1045958 91 96557824] "LETIONED"] [cl-struct-plansys 184 63 7 5 3 25 5400 3000 [cl-struct-fastseedtype 232 293560 117 -5212928] "ERESEN"] [cl-struct-plansys 107 18 2 7 12 58 40832 4715 [cl-struct-fastseedtype 254 679787 135 -14186752] "SOCEORBI"] [cl-struct-plansys 6 57 1 7 12 57 45144 4358 [cl-struct-fastseedtype 252 554246 113 -85561088] "BIBIRALE"] [cl-struct-plansys 33 20 4 6 7 39 18720 5921 [cl-struct-fastseedtype 178 352033 243 56423168] "TEENATLE"] [cl-struct-plansys 1 17 1 2 8 36 15552 4353 [cl-struct-fastseedtype 144 1031937 45 -89772800] "BIORLE"] [cl-struct-plansys 192 97 1 4 8 38 21888 5824 [cl-struct-fastseedtype 166 34240 31 14360320] "ANTEED"] [cl-struct-plansys 112 152 0 4 9 41 26240 4464 [cl-struct-fastseedtype 164 645488 41 33958144] "BIABI"] [cl-struct-plansys 155 134 6 3 6 34 7616 3227 [cl-struct-fastseedtype 218 963483 139 87132928] "ATBELE"] [cl-struct-plansys 166 33 1 7 12 57 45144 5542 [cl-struct-fastseedtype 56 228518 229 68871424] "QUXEGE"] [cl-struct-plansys 160 163 3 1 5 25 7000 4256 [cl-struct-fastseedtype 78 636576 183 -114968832] "CEESARI"] [cl-struct-plansys 190 47 7 1 3 21 2520 4542 [cl-struct-fastseedtype 76 719806 225 -27860736] "VEZAORLA"] [cl-struct-plansys 245 89 3 0 5 24 5376 3829 [cl-struct-fastseedtype 2 843509 35 -7134464] "BELEES"] [cl-struct-plansys 222 105 1 4 10 46 26496 5598 [cl-struct-fastseedtype 224 931294 157 -64316160] "ARBETEQU"] [cl-struct-plansys 26 124 4 6 8 43 20640 5658 [cl-struct-fastseedtype 246 501530 79 34295552] "MAGEESTI"] [cl-struct-plansys 119 201 1 6 12 56 40320 3959 [cl-struct-fastseedtype 244 531063 153 48535808] "ZABIXEDI"] [cl-struct-plansys 141 130 2 5 9 44 25344 4237 [cl-struct-fastseedtype 42 892045 187 104184576] "LACEUS"] [cl-struct-plansys 131 8 2 1 9 40 12800 3203 [cl-struct-fastseedtype 136 386435 85 80827648] "ATISEN"] [cl-struct-plansys 224 178 2 3 7 34 15232 6880 [cl-struct-fastseedtype 158 853472 231 116385536] "AXEBE"] [cl-struct-plansys 197 83 3 3 7 35 13720 5829 [cl-struct-fastseedtype 156 678085 81 -90484480] "ANRARA"] [cl-struct-plansys 100 20 4 2 4 23 6624 6244 [cl-struct-fastseedtype 82 578404 83 -64138496] "DIBIEDIN"] [cl-struct-plansys 12 56 0 6 10 47 37600 5644 [cl-struct-fastseedtype 48 120588 13 32181504] "MAABILE"] [cl-struct-plansys 65 38 6 0 2 15 1920 4673 [cl-struct-fastseedtype 70 702273 127 -57180416] "TIONED"] [cl-struct-plansys 111 216 2 0 8 35 8960 4719 [cl-struct-fastseedtype 68 517743 9 4655360] "SOREZAQU"] [cl-struct-plansys 26 68 4 7 9 48 25344 6170 [cl-struct-fastseedtype 122 938522 235 65923840] "DIDILAER"] [cl-struct-plansys 144 85 5 3 4 25 7000 3728 [cl-struct-fastseedtype 216 1031824 197 -114047744] "BEQURI"] [cl-struct-plansys 44 222 6 5 4 28 8064 4396 [cl-struct-fastseedtype 238 831788 23 -114944256] "BIATZATE"] [cl-struct-plansys 220 132 4 5 6 34 14688 3804 [cl-struct-fastseedtype 236 567260 193 110346496] "BELABIA"] [cl-struct-plansys 239 102 6 4 6 35 8960 5871 [cl-struct-fastseedtype 162 944879 131 -11828480] "MALETEES"] [cl-struct-plansys 201 220 6 0 2 15 1920 4809 [cl-struct-fastseedtype 128 430281 125 38239488] "SODIRI"] [cl-struct-plansys 51 254 6 2 5 29 5568 6707 [cl-struct-fastseedtype 150 587571 175 -65032448] "ONATCE"] [cl-struct-plansys 22 165 5 2 5 28 6720 6166 [cl-struct-fastseedtype 148 122390 121 882944] "DIESDI"] [cl-struct-plansys 195 237 7 1 4 25 3000 5571 [cl-struct-fastseedtype 202 520131 27 -8774912] "QUMAUS"] [cl-struct-plansys 14 104 0 5 12 54 38880 3342 [cl-struct-fastseedtype 40 629518 53 111293696] "XEORESCE"] [cl-struct-plansys 133 201 1 7 11 53 41976 4997 [cl-struct-fastseedtype 62 210565 71 107497216] "USTIZA"] [cl-struct-plansys 196 164 4 7 7 40 21120 3012 [cl-struct-fastseedtype 60 741060 49 119550208] "ESDI"] [cl-struct-plansys 22 109 5 6 7 40 16000 6166 [cl-struct-fastseedtype 242 396822 179 84783872] "DIENVE"] [cl-struct-plansys 86 182 6 2 4 25 4800 6742 [cl-struct-fastseedtype 208 940886 237 27258112] "ONDIZAAT"] [cl-struct-plansys 241 164 4 4 6 33 12672 3825 [cl-struct-fastseedtype 230 492017 223 38002432] "GEQUADI"] [cl-struct-plansys 45 15 7 4 3 24 4608 4653 [cl-struct-fastseedtype 228 27693 233 102230272] "TILAANES"] [cl-struct-plansys 9 155 3 3 7 35 13720 5385 [cl-struct-fastseedtype 26 559881 75 -374016] "QURIXEAN"] [cl-struct-plansys 59 162 2 7 12 58 40832 5947 [cl-struct-fastseedtype 120 497723 165 8168704] "TEQUENES"] [cl-struct-plansys 233 18 2 1 7 32 10240 4585 [cl-struct-fastseedtype 142 962025 119 -78219520] "VEENEN"] [cl-struct-plansys 59 146 2 1 9 40 12800 2875 [cl-struct-fastseedtype 140 1047867 161 -14638848] "REAR"] [cl-struct-plansys 90 74 2 0 7 31 7936 3674 [cl-struct-fastseedtype 66 57178 227 -7085312] "BEORSORA"] [cl-struct-plansys 244 39 7 4 2 20 3840 4084 [cl-struct-fastseedtype 32 538868 93 39083264] "RAAED"] [cl-struct-plansys 124 184 0 6 10 47 37600 3964 [cl-struct-fastseedtype 54 969852 15 111415040] "ZAEDED"] [cl-struct-plansys 117 248 0 6 11 51 40800 4469 [cl-struct-fastseedtype 52 836981 89 71719168] "BIRAA"] [cl-struct-plansys 106 111 7 5 5 33 7128 6506 [cl-struct-fastseedtype 106 963434 123 42892032] "REUSLEED"] [cl-struct-plansys 88 97 3 1 5 25 7000 3672 [cl-struct-fastseedtype 200 23896 21 -131918592] "GEISOR"] [cl-struct-plansys 89 89 1 3 9 41 20664 2905 [cl-struct-fastseedtype 222 674137 167 -91183360] "ERGEREXE"] [cl-struct-plansys 2 46 6 3 5 30 6720 4098 [cl-struct-fastseedtype 220 109826 17 -9105152] "LABIRIOR"] [cl-struct-plansys 57 30 6 2 3 21 4032 6457 [cl-struct-fastseedtype 146 408377 19 117314304] "RILADI"] [cl-struct-plansys 225 141 5 6 6 36 14400 4065 [cl-struct-fastseedtype 112 472545 205 80006400] "ZABEOR"] [cl-struct-plansys 210 217 3 0 6 28 6272 3026 [cl-struct-fastseedtype 134 9682 63 115359488] "INONIN"] [cl-struct-plansys 172 63 7 0 0 8 768 5036 [cl-struct-fastseedtype 132 780460 201 -92747520] "EDZAAR"] [cl-struct-plansys 103 138 2 7 12 58 40832 4455 [cl-struct-fastseedtype 186 717415 171 -94983424] "VEUSBI"] [cl-struct-plansys 166 6 6 3 5 30 6720 4262 [cl-struct-fastseedtype 24 269222 133 -51018496] "LAXERIVE"] [cl-struct-plansys 214 62 6 5 6 36 10368 4566 [cl-struct-fastseedtype 46 1037526 215 -55126272] "VEMAED"] [cl-struct-plansys 218 88 0 5 12 54 38880 6362 [cl-struct-fastseedtype 44 893402 129 117276928] "ISASO"] [cl-struct-plansys 52 7 7 4 2 20 3840 5940 [cl-struct-fastseedtype 226 604212 67 -110345472] "INUSES"] [cl-struct-plansys 94 73 3 0 6 28 6272 3166 [cl-struct-fastseedtype 192 616542 61 122764544] "ATORESRA"] [cl-struct-plansys 244 169 1 2 7 32 13824 5108 [cl-struct-fastseedtype 214 210676 111 110653184] "EDTIZABE"] [cl-struct-plansys 147 196 4 2 7 35 10080 6803 [cl-struct-fastseedtype 212 761491 57 110049536] "ASOARLE"] [cl-struct-plansys 129 10 2 1 7 32 10240 3457 [cl-struct-fastseedtype 10 609153 219 7527168] "ENRIENGE"] [cl-struct-plansys 99 242 2 5 11 52 29952 3683 [cl-struct-fastseedtype 104 233059 245 -61606656] "BEES"] [cl-struct-plansys 94 96 0 7 13 60 52800 5214 [cl-struct-fastseedtype 126 79454 7 6883072] "ESUSALE"] [cl-struct-plansys 129 239 7 7 5 35 9240 5249 [cl-struct-fastseedtype 124 551297 241 43643136] "ORMABIIN"] [cl-struct-plansys 204 38 6 6 4 29 9280 6604 [cl-struct-fastseedtype 50 403148 115 -83987712] "RIATTEIN"] [cl-struct-plansys 172 188 4 2 4 23 6624 5292 [cl-struct-fastseedtype 16 979116 173 106540288] "ORLESO"] [cl-struct-plansys 227 199 7 4 5 32 6144 6115 [cl-struct-fastseedtype 38 754403 159 -9658624] "INTISO"]]])


(provide 'elite-variables)