;;; elite-ai-commanders.el -  Elite for EMACS AI Commanders 

;; Elite for EMACS is based on Elite series by Ian Bell and David Braben.
;; Original Elite, (C) 1984 Ian Bell and David Braben.
;; Elite for EMACS uses code from original Elite and it is (C) 1984 Ian Bell and David Braben.
;; Additional code :
;; Author: Sami Salkosuo (sami@roguemail.net)

;; This file is not part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:
;;
;; Features now and future
;; -AI roaming in galaxy
;; -trading
;; -list ai commander info
;; -display list of commanders in current system when docked
;; -talk to ai commander
;;    -ask out, romantic dinner?
;;      -if three times out with same companion ==> engaged
;;      -if six times out with same companion ==> married
;; -if on the same station ==> play othello with ai commander for money
;; -ai commander combat
;; -AI roaming in other galaxies
;; -AI does missions
;; -can ask ai has seen person
;; -if male and female on the same station ==> new ai commander, not always,love relationships??
;;    -family events notification on screen..
;; -if several commanders on same stations 
;;    ==> something happens...
;;  
;;

(defvar elite-ai-commander-list nil
  "List of ai commanders")

;;(setq elite-ai-commander-list nil)
;;(elite-ai-initialize)
;;(elite-ai-commander-activity)
;;(elite-ai-test-activity t)
;;(elite-ai-commander-display-info)
;;(length elite-ai-commander-list)
;;(setq elite-ai-commander-list nil)

(defun elite-ai-test-activity(&optional init)
  (let (
	(i)
	(len)
	)
    (if init
	(progn
	  (setq elite-ai-commander-list nil)
	  (elite-ai-initialize)
	  )
      )
    (setq i 1)
    (setq len (length elite-ai-commander-list))
    (while (<= i len)
      (message (concat "Testing.." (number-to-string i) "/" (number-to-string len)))
      (elite-ai-commander-activity)
      (setq i (1+ i))
      )
)
)

(defun elite-ai-initialize ()
  "Initializes ai commanders"
  (let (
	(i)
	(len)
	)
    (setq i 0)
    (elite-ai-set-commander-names)

    (setq elite-additional-commands 
	  (append elite-additional-commands (list
					     (list "elite-federation-pilots" 1);shows buffer where is status of special mission 1
					     ))
	  )

    (setq len (length elite-ai-commander-names))
    (while (< i len)
      (setq elite-ai-commander-list (append elite-ai-commander-list (vector (elite-ai-commander-generate i)) nil))
      (setq i (1+ i))
      )
    )
  )

(defvar elite-ai-commander-activity-in-progress nil
  )

(defvar elite-ai-commander-activity-current-commander 0
  "index of commander in commander list")

(defun elite-ai-commander-start-activity ()
  "Starts commander activity"
  (let (

	)
    ;;(message "Start activity")
    (setq elite-ai-commander-activity-in-progress t)
    (setq elite-ai-commander-activity-current-commander 0)
    )
  )

(defun elite-ai-commander-continue-activity (&optional end-activity saving)
  "Ends  commander activity"
  (let (
	(commander)
	(len)
	(i 0)
	(tmp)
	)
    (if elite-ai-commander-activity-in-progress
	(progn
	  ;;(message "Continue activity")
	  (if end-activity
	      (setq len (length elite-ai-commander-list))
	    (setq len (+ 1 elite-ai-commander-activity-current-commander))		  
	    )
	  
	  (if saving
	      (setq tmp "Saving")
	    (setq tmp (concat "Hyperspacing to " (elite-get-system-name currentplanet)))
	    )
	  (while (< elite-ai-commander-activity-current-commander len)
	    ;;(setq commander (nth elite-ai-commander-activity-current-commander elite-ai-commander-list))
	    ;;do commander activity
	    (if end-activity
		(progn
		  (setq msg (concat tmp (make-string i ?. )))
		  ;;(setq msg (concat  "Hyperspacing to " (elite-get-system-name currentplanet) ". Initializing engines" (make-string i ?. )))
		  (if (>= (length msg) (frame-width))
		      (progn
			(setq i 0)
			;;(setq msg (concat "Hyperspacing to " (elite-get-system-name currentplanet) (make-string i ?. )))
			(setq msg (concat tmp (make-string i ?. )))
			)
		    )
		  (message msg)
		  (setq i (1+ i))
		  )
	      )
	    (if (< elite-ai-commander-activity-current-commander (length elite-ai-commander-list))
		(elite-ai-commander-activity elite-ai-commander-activity-current-commander)
	      )

	    (setq elite-ai-commander-activity-current-commander (1+ elite-ai-commander-activity-current-commander))
	    )
	  (if (>= elite-ai-commander-activity-current-commander (length elite-ai-commander-list))
	      (setq elite-ai-commander-activity-in-progress nil)	      
	      )
	  )
	)
    )
  )

(defun elite-ai-commander-end-activity (&optional save)
  "Ends  commander activity"
  (let (

	)
    ;;(elite-ai-commander-continue-activity t)
    (if save
	(elite-ai-commander-continue-activity t t)
      (elite-ai-commander-continue-activity t)
    )
    
    ;;check if there are male and female on the same station ==> new ai commander, but now always

    (setq elite-ai-commander-activity-in-progress nil)
    )
  )


(defun elite-ai-commander-activity (current-commander-index &optional display-hyperspace-message)
  "AI commander activity (trading etc) happens when 
   player jumps to hyperspace"
  (let (
	(commanders)
	(commander)
	(local-system-number)	
	(local-system-name)	
	(local-system)	
	(local-market)
	(system-log-persons)
	(next-system)
	(markets)
	(fuel-bought)
	(msg)
	(i)
	(len)
	(tmp)
	(people-in-system)
	)
    (setq markets nil)
    ;;order of thing for AI
    ;; do trading
    ;; accept missions
    ;; jump to next planet
    ;; do combat
    ;; dock
    ;; buy fuel
    (setq i 0)
;;     (setq commanders elite-ai-commander-list)
;;     (setq len (length commanders))
    ;(while commanders
      (if display-hyperspace-message
	  (progn
	    (setq msg (concat  "Hyperspacing to " (elite-get-system-name currentplanet) ". Initializing engines.." (number-to-string i) "/" (number-to-string len)))
;; 	    (if (>= (length msg) (frame-width))
;; 		(progn
;; 		  (setq i 0)
;; 		  (setq msg (concat "Hyperspacing to " (elite-get-system-name currentplanet) (make-string i ?. )))
;; 		  )
;; 	      )
	    (message msg)
	    )
	)
      (setq i (1+ i))

      ;;(setq commander (car commanders))
      (setq commander (nth current-commander-index elite-ai-commander-list))

      (if (= (elite-ai-commander-status commander) AI_COMMANDER_STATUS_ACTIVE)
	  (progn
	    ;;(setf (commander-current-day elite-commander) elite-day)
	    (setq local-system-number (elite-ai-commander-current-planet commander))
	    (setq local-system (aref galaxy local-system-number) )
	    ;;(commander-fluct elite-commander)
	    (if (= local-system-number currentplanet)
		(setq local-market localmarket)
	      (progn
		(if (car (cdr (assoc local-system-number markets)))
		    (setq local-market (car (cdr (assoc local-system-number markets))))
		  (setq local-market (genmarket (commander-fluct elite-commander) local-system))
		  )
		)
	      )
					;(setq local-market (genmarket 0 local-system)) ;;for testing, lave market
	    ;;(setq markets (append markets (list (list local-system-number (1- local-system-number)))))
	    ;;(car (cdr (assoc 7 markets)))

	    ;;list of people in current system
	    ;;(setq local-system-number 4)
	    (setq people-in-system (elite-get-people-in-system local-system-number))
	    (setq local-system-name (elite-get-system-name local-system-number))
	    (setq system-log-persons (elite-ai-commander-system-log-persons commander))
	    (while people-in-system
	      ;;(setq system-log-persons nil)
	      (setq tmp (elite-person-name (car people-in-system)))
	      (setq system-log-persons (append system-log-persons (list (list tmp local-system-name elite-day)) nil))
	      ;;(assoc local-system-name system-log-persons)
	      (setq people-in-system (cdr people-in-system))
	      )
	    (setf (elite-ai-commander-system-log-persons commander) system-log-persons)
	    ;;(assoc "key" '(("key" . "value")))


	    ;;sell stuff
	    (setq local-market (elite-ai-commander-sell commander local-market))

	    ;;buy fuel
	    ;;todo: if commander can't buy fuel, sell any items
	    (setq fuel-bought (elite-ai-commander-buy-fuel commander))
	    ;;       (if (= fuel-bought 0)
	    ;; 	  (progn
	    ;; 	    (setq local-market (elite-ai-commander-sell commander local-market t))
	    ;; 	    (setq fuel-bought (elite-ai-commander-buy-fuel commander))
	    ;; 	    )
	    ;; 	  )
	    ;;buy stuff
	    (setq local-market (elite-ai-commander-buy commander local-system local-market))

	    ;;set visited planet
	    (setq visited (elite-ai-commander-visited-systems commander))
	    (setf (elite-ai-commander-visited-systems commander) (append (cdr visited) (list local-system-number)))

	    ;;hyperspace to next planet
	    (setq next-system (elite-ai-commander-hyperspace-to-next-planet commander))
	    (if  (not next-system)
		(progn

		  ;;(message (concat "Stuck at " (elite-get-system-name local-system-number)))
		  ;;(sit-for 2)
		  (setq tmp AI_COMMANDER_STATUS_STUCK)
		  ;;(setf (elite-ai-commander-status commander) AI_COMMANDER_STATUS_STUCK)
		  ;;(setf (elite-ai-commander-credits commander) 1000)
		  ;;(setf (elite-ai-commander-fuel commander) 70)
		  ;;(setq next-system (elite-ai-commander-hyperspace-to-next-planet commander))
		  )
	      (progn
		  (setq tmp AI_COMMANDER_STATUS_ACTIVE)
		)
	      )
	    (setf (elite-ai-commander-status commander) tmp)
	    (setq markets (append markets (list (list local-system-number local-market))))
	    )
	)


      ;;(elite-ai-commander-planet-visited commander (elite-ai-commander-current-planet commander))
    ;;  (setq commanders (cdr commanders))
     ;; )

    )
  )

(defun elite-ai-commander-hyperspace-to-next-planet (commander)
  "Find commanders' next planet and do hyperjump"
  (let (
	(hyper-to-planet nil)
	(i)
	)
;;     (setq commander-list elite-ai-commander-list)
;;     (while commander-list
    ;;(setq commander (car commander-list))
      (setq hyper-to-planet (elite-ai-commander-find-next-planet commander))
      ;;if hyper-to-planet nil
      (if hyper-to-planet
	  (progn
	    ;;hyperspace to planet
	    (setf (elite-ai-commander-fuel commander) (- (elite-ai-commander-fuel commander) (distance (aref galaxy hyper-to-planet) (aref galaxy (elite-ai-commander-current-planet commander)))))
	    (setf (elite-ai-commander-current-planet commander) hyper-to-planet)
	    )
	)
      hyper-to-planet	    
      ;;(setq commander-list (cdr commander-list))
     ;; )
    )
  )

(defun elite-ai-commander-find-next-planet (commander)
  "Returns next planet where to jump"
  (let (
	(current-planet)
	(current-planet-info)
	(current-planet-economy)
	(hyper-to-planet-info)
	(hyper-to-planet)
	(hyper-to-planet-economy)
	(commander-fuel)
	(local-systems)
	(i)
	(len)
	(distance)
	(dist)
	)
    (setq current-planet (elite-ai-commander-current-planet commander))
    (setq current-planet-info (aref galaxy current-planet))
    (setq current-planet-economy (plansys-economy current-planet-info))
    (setq commander-fuel (elite-ai-commander-fuel commander))

    ;;if none found get planet which is farthest away
    (setq local-systems (elite-systems-within-radius commander-fuel current-planet))
    (setq len (length local-systems))

    ;;occasianally random destination
    (if (and (> len 0) (> (elite-rand1 t) 250))
	(progn	 
	  (setq hyper-to-planet (aref local-systems (random len)))
	  )
    (progn
      (setq hyper-to-planet-economy current-planet-economy)
      (setq i 0)
      (while (< i len)
	;;(setq i (1+ i))
	(setq hyper-to-planet-info (aref galaxy (aref local-systems i)))
	(if (>= current-planet-economy 4)
	    (progn 
	      ;;find planet where economy is less that current planet economy
	      (if (< (plansys-economy hyper-to-planet-info) current-planet-economy)
		  (progn
		    (if (and (not (elite-ai-commander-planet-visited commander (aref local-systems i))) (< (plansys-economy hyper-to-planet-info) hyper-to-planet-economy))
			(progn
			  (setq hyper-to-planet-economy (plansys-economy hyper-to-planet-info))
			  (setq hyper-to-planet (aref local-systems i))		  
			  )
		      )
		    )
		)
	      )
	  (progn
	    ;;find planet where economy is greater that current planet economy
	    (if (> (plansys-economy hyper-to-planet-info) current-planet-economy)
		(progn
		  (if (and (not (elite-ai-commander-planet-visited commander (aref local-systems i))) (> (plansys-economy hyper-to-planet-info) hyper-to-planet-economy))
		      (progn
			(setq hyper-to-planet-economy (plansys-economy hyper-to-planet-info))
			(setq hyper-to-planet (aref local-systems i))		  
			)
		    )
		  )
	      )
	    )
	  )
	(setq i (1+ i))
	)
      (if (= hyper-to-planet-economy current-planet-economy)
	  (progn
	    ;;find planet farthest away
	    (setq distance 0)
	    (setq i 0)
	    (while (< i len)
	      (setq dist (distance (aref galaxy current-planet) (aref galaxy (aref local-systems i))))
	      ;;(if (and (not (elite-ai-commander-planet-visited commander (aref local-systems i))) (> dist distance))
	      (if  (> dist distance)
		  (progn
		    (setq hyper-to-planet (aref local-systems i))
		    (setq distance dist)
		    )
		)
	      (setq i (1+ i))
	      )
	    )
	)
      )
    )
    hyper-to-planet
    )
  )

(defun elite-ai-commander-planet-visited (commander hyper-to-planet)
  "Checks if commander has visited planet recently.Return true is visited"
  (let (
	)
    (member hyper-to-planet (elite-ai-commander-visited-systems commander))
    )
  )


(defun elite-ai-commander-buy-fuel (commander)
  "Attempt to buy fuel-to-buy tonnes of fuel."
  (let
      (
       (f 70)
       (fuel)
       )
    (setq fuel (elite-ai-commander-fuel commander))
    (if (> (+ f fuel) maxfuel)
	(setq f (- maxfuel fuel)))
    (if (> elite-fuelcost 0)
	(if (> (* f elite-fuelcost) (elite-ai-commander-credits commander))
	    (setq f (/ (elite-ai-commander-credits commander) elite-fuelcost))
	  )
      )
    (setf (elite-ai-commander-fuel commander) (+ (elite-ai-commander-fuel commander) f))
    (setf (elite-ai-commander-credits commander) (- (elite-ai-commander-credits commander) (* elite-fuelcost f)))
    f
  )
)

(defvar elite-ai-commander-agriculture-tradegoods
  (list TRADEGOOD_FOOD
	TRADEGOOD_TEXTILES
	TRADEGOOD_LIQUOR
	TRADEGOOD_FURS
	)
  "Tradegoods that are bought in agricultural planets")

(defvar elite-ai-commander-agriculture-profit-tradegoods
  (list TRADEGOOD_FURS
	)
  "Tradegoods that are bought in agricultural planets for big profit")

(defvar elite-ai-commander-industrial-tradegoods
  (list TRADEGOOD_COMPUTERS
	TRADEGOOD_LUXURIES
	TRADEGOOD_MACHINERY
	TRADEGOOD_ALLOYS
	)
  "Tradegoods that are bought in industrial planets")

(defvar elite-ai-commander-industrial-profit-tradegoods
  (list TRADEGOOD_COMPUTERS
	)
  "Tradegoods that are bought in industrial  planets for profit")

(defun elite-ai-commander-buy (ai-commander local-system local-market)
  "AI commander buys cargo"
  (let (
	(trade-good)
	(economy)
	(market-quantity)
	(market-price)	
	(cash)
	(max-amount)
	(cargo)
	(available-cargo-space)
	)
    (setq cargo (elite-ai-commander-current-cargo ai-commander))
    
    ;;get localsystem economy type
    ;;0       anarchy           Rich Ind
    ;;1       Feudal            Average Ind
    ;;2       Multi-gov         Poor Ind
    ;;3       Dictatorship      Mainly Ind
    ;;4       Communist         Mainly Agri
    ;;5       Confederacy       Rich Agri
    ;;6       Democracy         Average Agri
    ;;7       Corporate State   Poor agri
    (setq economy (plansys-economy local-system))

    (if (>= economy 4)
	(progn
	  ;;agriculture, items:food, textiles,liquor,furs
	  ;;set trade good
	  (if (> (elite-ai-commander-credits ai-commander) 2000)
	      (setq trade-good (nth (random (length elite-ai-commander-agriculture-profit-tradegoods)) elite-ai-commander-agriculture-profit-tradegoods  ))
	  (setq trade-good (nth (random (length elite-ai-commander-agriculture-tradegoods)) elite-ai-commander-agriculture-tradegoods  ))
	  )
	  ;;(setq trade-good TRADEGOOD_FOOD)

	  )
      (progn
	;;industrial, items:computers,luxuries,machinery,alloys
	  (if (> (elite-ai-commander-credits ai-commander) 2000)
	      (setq trade-good (nth (random (length elite-ai-commander-industrial-profit-tradegoods)) elite-ai-commander-industrial-profit-tradegoods  ))
	(setq trade-good (nth (random (length elite-ai-commander-industrial-tradegoods)) elite-ai-commander-industrial-tradegoods  ))	
	)
	  )
      )
    (setq market-quantity (aref (markettype-quantity local-market) trade-good))
    (if (> market-quantity 0)
	(progn
	  (setq market-price  (aref (markettype-price local-market) trade-good))
	  (setq cash (elite-ai-commander-credits ai-commander))
	  
	  (setq max-amount (mymin market-quantity (/ cash market-price)))

	  (setq max-amount (mymin max-amount (elite-ai-commander-holdspace ai-commander)))
	  

	  (if (> max-amount 0)
	      (progn
		;;buy

		(aset (markettype-quantity local-market) trade-good (- (aref (markettype-quantity local-market) trade-good) max-amount))
		(aset cargo trade-good (make-elite-ai-commander-cargo :quantity max-amount :purchase-price market-price))
		(setf (elite-ai-commander-holdspace ai-commander) (- (elite-ai-commander-holdspace ai-commander) max-amount))
		(setf (elite-ai-commander-current-cargo ai-commander) cargo)
		(setf (elite-ai-commander-credits ai-commander) (- (elite-ai-commander-credits ai-commander) (* max-amount market-price)))
		)
	    )
	  )
      )
    local-market
    )
  )

(defun elite-ai-commander-sell (ai-commander local-market &optional force-sell)
  "AI commander sells cargo"
  (let (
	(cargo)
	(len)
	(i)
	(item)
	(tmp)
	(qty)
	(fsell)
	)
    (setq fsell force-sell)
    (setq cargo (elite-ai-commander-current-cargo ai-commander))
    (setq len (length cargo))
    (setq i 0)
    (while (< i len)
      ;;check quantity
      ;;check if local price > purchase price ==> sell
      (setq item (aref cargo i))
      (setq qty (elite-ai-commander-cargo-quantity item))
      (if (> qty 0)
	  (progn
;; 	    (if (< (elite-ai-commander-credits ai-commander) 200)
;; 		(progn
;; 		  (setq fsell t)
;; 		  (message (concat "force sell!!"))
;; 		  (sit-for 2)
;; 
;; 		  )
;; 		)
	    (if (or fsell (>= (aref (markettype-price local-market) i) (elite-ai-commander-cargo-purchase-price item)))
		(progn
		  ;;sell goods
		  (aset cargo i (make-elite-ai-commander-cargo :quantity 0 :purchase-price 0))
		  (setf (elite-ai-commander-current-cargo ai-commander) cargo)
		  (setq tmp (* qty (aref (markettype-price local-market) i)))
		  (aset (markettype-quantity local-market) i (+ (aref (markettype-quantity local-market) i) qty))

		  ;;set ai commander cash
		  (setf (elite-ai-commander-credits ai-commander) (+ tmp (elite-ai-commander-credits ai-commander)))
		  (setf (elite-ai-commander-holdspace ai-commander) (+ (elite-ai-commander-holdspace ai-commander) qty))
		  (setf (elite-ai-commander-current-cargo ai-commander) cargo)

		  )
	      )
	    )
	)
      (setq i (1+ i))
      )
    local-market
    )
  )

(defun elite-ai-commander-in-system (system)
  "Returns AI commanders in system"
  (let (
	(commanders)
	(commander)
	(commanders-in-system)
	)
    (setq commanders-in-system nil)
    (setq commanders elite-ai-commander-list)
    (while commanders
      (setq commander (car commanders))
      ;;(setq markets (append markets (list (list local-system-number local-market))))
      (if (= (elite-ai-commander-current-planet commander) system)
	  (progn
	    (setq commanders-in-system (append commanders-in-system (list commander) ))
	    )
	  )
      (setq commanders (cdr commanders))
      )
    commanders-in-system
    )
  )
;;(elite-ai-commander-has-seen-person "Laurel Takashima" "akseli SNELLMA")
(defun elite-ai-commander-has-seen-person (commander-name person-name)
  "Return system name where commander has seen person"
  (let (
	(commanders)
	(commander)
	(system-log-persons)
	(system)
	(system-log-persons-entry)
	)
    (setq system nil)
    (setq commanders elite-ai-commander-list)
    (while commanders
      (setq commander (car commanders))
      (if (equal (elite-ai-commander-name commander) commander-name)
	  (progn
	    (setq system-log-persons (reverse (elite-ai-commander-system-log-persons commander)))
	    (while system-log-persons
	      (setq system-log-persons-entry (car system-log-persons))
	      (if (equal (downcase (car system-log-persons-entry)) (downcase person-name))
		  (setq system (cdr system-log-persons-entry))
		  )	      
	      (setq system-log-persons (cdr system-log-persons))
	      )
	    )
	)      
      (setq commanders (cdr commanders))
      )
    system
    )
  )

(defun elite-ai-commander-info ()
  "Display ai commander info"
  (let (
	(commanders)
	(commander)
	(txt ">Elite Federation commanders\n")
	)
    ;;info: name,credits,current planet,current galaxy
    (setq commanders elite-ai-commander-list)
    (while commanders
      (setq commander (car commanders))
      (setq txt (concat txt (elite-ai-commander-name commander) "\n" ) )
      (if (not (equal (elite-ai-commander-heritage commander) ""))
	  (setq txt (concat txt (elite-ai-commander-heritage commander) " " "\n" ) )	  
	  )
      (setq txt (concat txt "  " (elite-get-system-name (elite-ai-commander-current-planet commander)) (format " %.1f CR" (/ (elite-ai-commander-credits commander) 10.0)) "\n" ) )
      (setq commanders (cdr commanders))
      )
    (elite-insert-text txt)
      
    ;;(message "To be implemented")
    )
  )

(defun elite-ai-commander-richest ()
  "Displays commanders 'highscore' list, richest first"
  (let (

	)

    )
)

(defun elite-ai-commander-generate (commander-id)
  "Generate ai commander"
  (let (
	(local-planet)
	)
    ;;(setq local-planet numforLave)
    (setq local-planet (random galsize))
    (make-elite-ai-commander
     :id commander-id
     :name (aref elite-ai-commander-names commander-id);;(concat "AI Commander " (number-to-string commander-id));;todo commander name
     :gender (aref elite-ai-commander-genders commander-id)
     :heritage ""
     :credits 1000
     :fuel maxfuel
     :status AI_COMMANDER_STATUS_ACTIVE
     :holdspace 20
     :current-cargo (make-vector (+ lasttrade 1) (make-elite-ai-commander-cargo :quantity 0 :purchase-price 0))
     :current-galaxy galaxynum;;todo random galaxy
     :current-planet local-planet
     :system-log-persons (list)
     :visited-systems (make-list 3 -1)
     )
    )
  )

;;(length (make-vector (+ lasttrade 1) (make-elite-ai-commander-cargo :quantity 0 :purchase-price 0)))

(defstruct elite-ai-commander-cargo
  quantity
  purchase-price
  )

(defstruct elite-ai-commander
  id
  name
  heritage;heritage like son of dart vader and mara jade
  gender;0=female,1=male
  credits
  fuel
  status;;commanders status can be any string
  holdspace
  current-galaxy
  current-planet
  visited-systems;list of system numbers where commander has been,hold up to 5-10 systems.
                 ;;commander does not go to system which number is in list
  system-log-persons;;for each system show people in system and other stuff
  current-cargo
  )

(defconst AI_COMMANDER_STATUS_ACTIVE 0)
(defconst AI_COMMANDER_STATUS_STUCK 1)

(defun elite-ai-commander-display-info ()
  "Displays ai commander info. Mainly for debugging/testing."
  (let (
	(commander-list)
	(commander)
	(info)
	(i)
	(tmp)
	)
    (setq info "")
    (setq commander-list elite-ai-commander-list)
    (while commander-list
      (setq commander (car commander-list))
      (setq info (concat info 
			 "Name: " (elite-ai-commander-name commander) "\n"
			 "Credits: " (format "%.1f" (/ (elite-ai-commander-credits commander) 10)) "\n"
			 "Status: " (elite-ai-commander-status commander) "\n"
			 "Fuel: " (elite-ai-commander-fuel commander) "\n"
			 "Holdspace: " (elite-ai-commander-holdspace commander) "\n"
			 "Galaxy: " (elite-ai-commander-current-galaxy commander) "\n"
			 "Planet: " (elite-get-system-name (elite-ai-commander-current-planet commander)) "(" (elite-ai-commander-current-planet commander)")" "\n"
			 )
	    )
      ;;visited planets
      (setq info (concat info "Visited planets: "))
      (setq tmp (elite-ai-commander-visited-systems commander))
      (while tmp
	(if (> (car tmp) -1)
	    (setq info (concat info
			       (elite-get-system-name (car tmp))
			       " "
			       ))
	  )
	(setq tmp (cdr tmp))
	)
      (setq info (concat info "\n"))
      ;;commander cargo
      (setq i 0)
      (while (< i (length (elite-ai-commander-current-cargo commander)))
	(if (> (elite-ai-commander-cargo-quantity (aref (elite-ai-commander-current-cargo commander) i)) 0)
	    (setq info (concat info
			       (tradegood-name (aref commodities i))
			       ": "
			       (elite-ai-commander-cargo-quantity (aref (elite-ai-commander-current-cargo commander) i))
			       " Purchase price: "
			       (elite-ai-commander-cargo-purchase-price (aref (elite-ai-commander-current-cargo commander) i))
			       "\n"
			       )
		  )
	  )
	(setq i (1+ i))
	)
      (setq info (concat info "\n"))      
      (setq commander-list (cdr commander-list))
      )
    (with-electric-help
     '(lambda () (insert info) (goto-char 0) "*Elite AI Commander info*")
     )    
    )
  )

(defun elite-ai-set-commander-names ()

  (setq elite-ai-commander-genders
	(vconcat (make-vector 42 ELITE_GENDER_MALE)
		(make-vector 22 ELITE_GENDER_FEMALE)
	 )
	)
  (setq elite-ai-commander-names
	(vector
	 ;;names should have first name and last name, or just singular name
	 "Darth Vader";;first in list are males
	 "Darth Maul"
	 "Darth Sidious"
	 "Luke Skywalker"
	 "Han Solo"
	 "Korben Dallas"
	 "Jean-Luc Picard"
	 "Protector"
	 "Silenius"
	 "Paul Atreides"
	 "Clint Eastwood"
	 "Edmund Blackadder"
	 "John Sheridan"
	 "Baldrick"
	 "Bruce Wayne"
	 "Zack Allan"
	 "Harley Davidson"
	 "Alec Holland"
	 "John Constantine"
	 "Etrigan"
	 "Michael Garibaldi"
	 "Clark Kent"
	 "Conan"
	 "William Riker"
	 "Ben Kenobi"
	 "Jeffrey Sinclair"
	 "Morden"
	 "Londo Mollari"
	 "G'Kar"
	 "Worf"
	 "Garrett"
	 "Vladimir Harkonnen"
	 "Duncan Idaho"
	 "John Connor"
	 "Kyle Reese"
	 "Thor"
	 "Odin"
	 "Loki"
	 "Jack Slater"
	 "Kyle Katarn"
	 "Tuco"
	 "William Shakespeare"
	 "Susan Ivanova";;here start females
	 "Elektra"
	 "Beverly Crusher"
	 "Ellen Ripley"
	 "Lyta Alexander"
	 "Marion Sherwood"
	 "Valeria"
	 "Martha Washington"
	 "Kathryn Janeway"
	 "Leia Organa"
	 "Meredith Argent";FFE
	 "Lorelei"
	 "Delenn"
	 "Sarah Connor"
	 "Sif"
	 "Amidala"
	 "Jessica Atreides"
	 "Mara Jade"
	 "Talia Winters"
	 "Elizabeth Lochley"
	 "Catherine Sakai"
	 "Laurel Takashima"
	 )
	)
  )
;; garrett mara jade 
;;boy garrett jade
:;daughter: mara garrett
;; boy: Garrett, son of Mara Jade
;; girl: Mara, daughther of Garret
  
(defvar elite-ai-commander-names nil
  "AI Commander names")

(defvar elite-ai-commander-genders nil
  "AI Commander genders")

    
(provide 'elite-ai-commanders)
