;;; elite-windows.el -  Functions for Emacs-Elite windowed user interface

;; Elite for EMACS is based on Elite series by Ian Bell and David Braben.
;; Original Elite, (C) 1984 Ian Bell and David Braben.
;; Elite for EMACS uses code from original Elite and it is (C) 1984 Ian Bell and David Braben.
;; Additional code :
;; Author: Sami Salkosuo (sami@roguemail.net)


;; This file is not part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

(defvar elite-command-buffer nil
  "Buffer for commands")
(defvar elite-command-window nil
  "Window for commands")

(defvar elite-market-buffer nil
  "Buffer for market info")
(defvar elite-market-window nil
  "Window for market info")

(defvar elite-message-buffer nil
  "Buffer for messages")
(defvar elite-message-window nil
  "Window for messages")

(defvar elite-use-windows t
  "t if using separate windows and buffers")

(defun elite-initialize-windows ()
  "initialise windows"
  (let (
	(tmp)
	)
    (if (not (one-window-p))
	(progn
	  (delete-other-windows)
	  (switch-to-buffer elite-buffer-name)
	  )
      )

  ;create buffers
  (setq elite-command-buffer (get-buffer-create "Elite Command Buffer"))
  (setq elite-market-buffer  (get-buffer-create "Elite Market Buffer"))
  (setq elite-message-buffer (get-buffer-create "Elite Message Buffer"))

     ;create windows
  (setq elite-command-window (selected-window))
  (setq elite-market-window (split-window elite-command-window 57 t))
  (setq elite-message-window (split-window elite-market-window 10))

  (set-window-buffer elite-command-window elite-command-buffer)
  (set-window-buffer elite-market-window elite-market-buffer)
  (set-window-buffer elite-message-window elite-message-buffer)
;   (set-window-dedicated-p elite-command-window t)
;   (set-window-dedicated-p elite-message-window t)
;   (set-window-dedicated-p elite-market-window t)  
  ;set modes
  (select-window elite-command-window)
  (use-local-map elite-mode-map)
  (setq local-abbrev-table elite-mode-abbrev-table)
  (set-syntax-table elite-mode-syntax-table)
  (setq major-mode 'elite-mode)
  (setq mode-line-format (list   
			  (elite-short-local-system-info)
			  "  "
			  "Day: "
			  (number-to-string elite-day)
			  "%-"))
  (force-mode-line-update)

  (select-window elite-market-window)
  (use-local-map elite-mode-map)
  (setq local-abbrev-table elite-mode-abbrev-table)
  (set-syntax-table elite-mode-syntax-table)
  (setq major-mode 'elite-mode)
  (setq mode-line-format (list   
			  "Market"
			  "%-"))
  (force-mode-line-update)

  (select-window elite-message-window)
  (use-local-map elite-mode-map)
  (setq local-abbrev-table elite-mode-abbrev-table)
  (set-syntax-table elite-mode-syntax-table)
  (setq major-mode 'elite-mode)
  (setq mode-line-format (list   
			  "Messages"
			  "%-"))
  (force-mode-line-update)


  (select-window elite-command-window)

  ;(message "")
  )
)

(defun elite-refresh-windows ()
  "refresh windows"

  ;ai commander activity
  (elite-display-market)
  ;(elite-update-command-shell-mode-line)

)

(defun elite-update-command-shell-mode-line ()

  (select-window elite-command-window)
  (switch-to-buffer elite-command-buffer)
  (setq mode-line-format (list   
			  (elite-short-local-system-info)
			  " "
			  (format "F:%.1fLY" (/ (commander-fuel elite-commander) 10.0))
			  " "
			  "Day: "
			  (number-to-string elite-day)
			  "%-"))
  (force-mode-line-update)
)

;(elite-initialize-windows)

(defun elite-display-market-window (txt)
  "displays market info in market window"
  (let (
	(market-list)
	(list-item)
	(len)
	)
  (select-window elite-market-window)
  (switch-to-buffer elite-market-buffer)
  (erase-buffer)
  (setq market-list (split-string txt "\n"))
  (while market-list
    (setq list-item (car market-list))
    (setq len (length list-item))
    (insert list-item)	  
    (insert (make-string (- 28 len) ? ))
    (setq market-list (cdr market-list))
    (if market-list
	(progn
	  (setq list-item (car market-list))
	  (insert list-item)	  
	  (insert "\n")
	  ;(insert "\t     " list-item "\n")
	  (setq market-list (cdr market-list))
	  )
      )
     )

  ;insert total cargo, free space, cash to modeline
  (setq mode-line-format (list   
			  "Total Cargo: "
			  (number-to-string (elite-cargo))
			  " "
			  "Free Space: "
			  (number-to-string holdspace)
			  " "
			  (format "F: %.1fLY" (/ (commander-fuel elite-commander) 10.0))
			  " "
			  (format "Cash: %.1f CR" (/ (commander-credits elite-commander) 10.0))
			  "%-"))
  (force-mode-line-update)

  ;insert cargo also in market list
;     (setq i 0)
;     (while (< i AlienItems)
;       (setq cargo (aref shipshold i))
;       (if (> cargo 0)
; 	  (progn 
; 	    (setq msg (concat msg "\n" (aref tradnames i) " "  cargo (elite-get-unit i)))
; 	  ))
;       (setq i (1+ i))
;       )

  (select-window elite-command-window)
  (switch-to-buffer elite-command-buffer)

  )
)

(defun elite-command-shell (txt)
  "Command shell "
  (let (
	(txt-list)
	)
    (select-window elite-command-window)
    (switch-to-buffer elite-command-buffer)
    (goto-char (point-max))
    ;(setq txt "tret\netetttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt")
    (setq txt-list (elite-split-string-for-shell txt))
    (while txt-list
      (insert (car txt-list) "\n")
      (setq txt-list (cdr txt-list))
      )
    ;(insert ">")
    ;;continue ai commander activity
    (elite-ai-commander-continue-activity)

    )
  )

(defvar elite-message-shell-inserted-day -1
  "Inserted day in message shell")

(defun elite-message-shell (txt &optional long)
  "message shell"
  (let (
	(txt-list)
	(max-height)
	(width)
	(txt-line)
	(current-line)
	)
    (select-window elite-message-window)
    (switch-to-buffer elite-message-buffer)
    (setq max-height (- (window-height) 4))
    (setq width (window-width));todo: use width==>arbitrary window sizes
    (goto-char (point-max))
    (if (> elite-day elite-message-shell-inserted-day)
	(progn
	  (insert "Day: " (number-to-string elite-day) "\n")
	  (setq elite-message-shell-inserted-day elite-day)
	  )
      )
    (setq current-line 1)
    ;(setq txt "tret\netetttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt")
    (setq txt-list (elite-split-string-for-shell txt))
    (while txt-list
      (setq txt-line (concat (car txt-list) "\n"))
      (if (and long (= current-line max-height))
	  (progn
	    (read-string "More..")
	    (recenter 0)
	    )
	  )
      (insert txt-line)
      (setq current-line (1+ current-line))
;       (if (pos-visible-in-window-p (+ (point) (length txt-line)))
; 	  (insert txt-line)
; 	(progn
; 	  (read-string "More...")
; 	  (insert txt-line)
; 	  )
; 	)

      (setq txt-list (cdr txt-list))
      )
    (select-window elite-command-window)
    (switch-to-buffer elite-command-buffer)
    )
)

(defun elite-split-string-for-mini-buffer (txt)
  "Splits string for mini buffer"
  (let (
	(len)
	(text "")
	(msg)
	(tmp)
	(tmp-line)
	(minibuffer-list "")
	)
    (setq len (- elite-screen-width 25))
    (setq msg (split-string txt "\n"))
    (while msg
      (setq tmp (car msg))
      (setq text (concat text tmp " "))
      (setq msg (cdr msg))
      )
    
    ;split word by word
    (setq msg (split-string text " "))
    (while msg
      (setq tmp (car msg))
      (setq tmp-line (concat tmp-line tmp " "))
      (if (> (length tmp-line) len)
	  (progn
	    (setq minibuffer-list (concat minibuffer-list tmp-line "\n"))
	    (setq tmp-line "")
	    )
	  )
      (setq msg (cdr msg))
      )
    (setq minibuffer-list (concat minibuffer-list tmp-line))
    
    (split-string minibuffer-list "\n")
    )
  )

(provide 'elite-windows)